/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import edu.umd.marbl.mhap.sketch.AbstractBitSketch;
import edu.umd.marbl.mhap.sketch.SketchRuntimeException;
import edu.umd.marbl.mhap.utils.MersenneTwisterFast;
import edu.umd.marbl.mhap.utils.Pair;
import edu.umd.marbl.mhap.utils.SortablePair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class BitVectorIndex<T, B extends AbstractBitSketch<B>> {
    private final long[][] bitsUsed;
    private final ArrayList<HashMap<Integer, ArrayList<Pair<T, B>>>> hashList;
    private final HashMap<T, B> indexedWords;
    private final double minSimilarity;

    public BitVectorIndex(List<Pair<T, B>> valuePairs, double minSimilarity, double confidence) {
        this.minSimilarity = minSimilarity;
        int b = 10;
        int numIndexes = (int)Math.ceil(Math.log(1.0 - confidence) / Math.log(1.0 - Math.pow(this.minSimilarity, b)));
        this.bitsUsed = new long[numIndexes][b];
        MersenneTwisterFast rand = new MersenneTwisterFast();
        long numBits = 1L;
        if (!valuePairs.isEmpty()) {
            numBits = ((AbstractBitSketch)valuePairs.get((int)0).y).numberOfBits();
        }
        for (int index = 0; index < numIndexes; ++index) {
            for (int bit = 0; bit < b; ++bit) {
                this.bitsUsed[index][bit] = rand.nextLong(numBits);
            }
        }
        this.hashList = new ArrayList(numIndexes);
        for (int iter = 0; iter < numIndexes; ++iter) {
            this.hashList.add(new HashMap(valuePairs.size()));
        }
        this.indexedWords = new HashMap(valuePairs.size());
        valuePairs.parallelStream().forEach(pair -> {
            int[] lookupPositions = this.lookupPositions((AbstractBitSketch)pair.y);
            int count = 0;
            Object object = this.hashList.iterator();
            while (object.hasNext()) {
                ArrayList list;
                HashMap<Integer, ArrayList<Pair<T, B>>> map;
                Cloneable cloneable = map = object.next();
                synchronized (cloneable) {
                    list = map.computeIfAbsent(lookupPositions[count], key -> new ArrayList(1));
                }
                cloneable = list;
                synchronized (cloneable) {
                    list.add(pair);
                }
                ++count;
            }
            object = this.indexedWords;
            synchronized (object) {
                this.indexedWords.put(pair.x, pair.y);
            }
        });
    }

    public int getBitsPerHash() {
        return this.bitsUsed[0].length;
    }

    public Map<T, B> getIndexedItems() {
        return Collections.unmodifiableMap(this.indexedWords);
    }

    public List<SortablePair<Double, T>> getNeighbors(B sketch, double minSimilarity) {
        if (minSimilarity < this.minSimilarity) {
            throw new SketchRuntimeException("Similarity request threshold below the ability of the indexer to compute.");
        }
        int[] lookupPositions = this.lookupPositions(sketch);
        HashSet<Pair<T, B>> set = new HashSet<Pair<T, B>>();
        int count = 0;
        for (HashMap<Integer, ArrayList<Pair<T, B>>> map : this.hashList) {
            ArrayList<Pair<T, B>> arrayList = map.get(lookupPositions[count]);
            if (arrayList == null) continue;
            set.addAll(arrayList);
            ++count;
        }
        ArrayList<SortablePair<Double, T>> returnList = new ArrayList<SortablePair<Double, T>>();
        for (Pair pair : set) {
            double score = ((AbstractBitSketch)pair.y).similarity(sketch);
            if (!(score >= minSimilarity)) continue;
            returnList.add(new SortablePair(score, pair.x));
        }
        return returnList;
    }

    public int getNumberOfIndexes() {
        return this.hashList.size();
    }

    public B getSketch(T word) {
        return (B)((AbstractBitSketch)this.indexedWords.get(word));
    }

    public boolean isEmpty() {
        return this.indexedWords.isEmpty();
    }

    private int[] lookupPositions(B bits) {
        int numIndexes = this.hashList.size();
        int[] returnValues = new int[numIndexes];
        for (int index = 0; index < numIndexes; ++index) {
            long[] usedBits = this.bitsUsed[index];
            int val = 0;
            int mask = 1;
            for (int bit = 0; bit < usedBits.length; ++bit) {
                if (((AbstractBitSketch)bits).getBit(usedBits[bit])) {
                    val |= mask;
                }
                mask <<= 1;
            }
            returnValues[index] = val;
        }
        return returnValues;
    }
}

