/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.jetty.plus.annotation.LifeCycleCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreDestroyCallback
extends LifeCycleCallback {
    private static final Logger LOG = Log.getLogger(PreDestroyCallback.class);

    @Override
    public void validate(Class<?> clazz, Method method) {
        if (method.getExceptionTypes().length > 0) {
            throw new IllegalArgumentException(clazz.getName() + "." + method.getName() + " cannot not throw a checked exception");
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new IllegalArgumentException(clazz.getName() + "." + method.getName() + " cannot not have a return type");
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException(clazz.getName() + "." + method.getName() + " cannot be static");
        }
    }

    @Override
    public void callback(Object instance) {
        try {
            super.callback(instance);
        }
        catch (Exception e) {
            LOG.warn("Ignoring exception thrown on preDestroy call to " + this.getTargetClass() + "." + this.getTarget().getName(), (Throwable)e);
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && o instanceof PreDestroyCallback;
    }
}

