/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.editextras;

import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.editextras.ConvertToStringBufferAction;
import net.sourceforge.squirrel_sql.plugins.editextras.CopySqlAction;
import net.sourceforge.squirrel_sql.plugins.editextras.CutSqlAction;
import net.sourceforge.squirrel_sql.plugins.editextras.EditExtrasExternalServiceImpl;
import net.sourceforge.squirrel_sql.plugins.editextras.EscapeDateAction;
import net.sourceforge.squirrel_sql.plugins.editextras.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.plugins.editextras.InQuotesAction;
import net.sourceforge.squirrel_sql.plugins.editextras.RemoveNewLinesAction;
import net.sourceforge.squirrel_sql.plugins.editextras.RemoveQuotesAction;
import net.sourceforge.squirrel_sql.plugins.editextras.Resources;

public class EditExtrasPlugin
extends DefaultSessionPlugin {
    private static final ILogger s_log = LoggerController.createLogger(EditExtrasPlugin.class);
    static final String USER_PREFS_FILE_NAME = "prefs.xml";
    private Resources _resources;

    public String getInternalName() {
        return "editextras";
    }

    public String getDescriptiveName() {
        return "SQL Entry Area Enhancements";
    }

    public String getVersion() {
        return "1.0.1";
    }

    public String getAuthor() {
        return "Gerd Wagner";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public void initialize() throws PluginException {
        super.initialize();
        IApplication app = this.getApplication();
        this._resources = new Resources((IPlugin)this);
        this.createMenu();
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        ISQLPanelAPI sqlPanelAPI = FrameWorkAcessor.getSQLPanelAPI(session, this);
        this.initEditExtras(sqlPanelAPI);
        PluginSessionCallback ret = new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
                EditExtrasPlugin.this.initEditExtras(sqlInternalFrame.getSQLPanelAPI());
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
            }
        };
        return ret;
    }

    private void initEditExtras(ISQLPanelAPI sqlPanelAPI) {
        ActionCollection actions1 = this.getApplication().getActionCollection();
        sqlPanelAPI.addToSQLEntryAreaMenu(actions1.get(InQuotesAction.class));
        sqlPanelAPI.addToSQLEntryAreaMenu(actions1.get(RemoveQuotesAction.class));
        sqlPanelAPI.addToSQLEntryAreaMenu(actions1.get(ConvertToStringBufferAction.class));
        JMenuItem mnu = sqlPanelAPI.addToSQLEntryAreaMenu(actions1.get(RemoveNewLinesAction.class));
        this._resources.configureMenuItem(actions1.get(RemoveNewLinesAction.class), mnu);
        sqlPanelAPI.addToSQLEntryAreaMenu(actions1.get(EscapeDateAction.class));
        mnu = sqlPanelAPI.addToSQLEntryAreaMenu(actions1.get(CutSqlAction.class));
        this._resources.configureMenuItem(actions1.get(CutSqlAction.class), mnu);
        mnu = sqlPanelAPI.addToSQLEntryAreaMenu(actions1.get(CopySqlAction.class));
        this._resources.configureMenuItem(actions1.get(CopySqlAction.class), mnu);
        ActionCollection actions = this.getApplication().getActionCollection();
        sqlPanelAPI.addToToolsPopUp("quote", actions.get(InQuotesAction.class));
        sqlPanelAPI.addToToolsPopUp("unquote", actions.get(RemoveQuotesAction.class));
        sqlPanelAPI.addToToolsPopUp("quotesb", actions.get(ConvertToStringBufferAction.class));
        sqlPanelAPI.addToToolsPopUp("date", actions.get(EscapeDateAction.class));
        sqlPanelAPI.addToToolsPopUp("sqlcut", actions.get(CutSqlAction.class));
        sqlPanelAPI.addToToolsPopUp("sqlcopy", actions.get(CopySqlAction.class));
        sqlPanelAPI.addToToolsPopUp("remnewlines", actions.get(RemoveNewLinesAction.class));
    }

    public PluginResources getResources() {
        return this._resources;
    }

    private void createMenu() {
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        JMenu menu = this._resources.createMenu("editextras");
        app.addToMenu(2, menu);
        SquirrelAction act = new InQuotesAction(app, this);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new RemoveQuotesAction(app, this);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new ConvertToStringBufferAction(app, this);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new EscapeDateAction(this.getApplication(), (net.sourceforge.squirrel_sql.fw.util.Resources)this._resources);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new CutSqlAction(this.getApplication(), (net.sourceforge.squirrel_sql.fw.util.Resources)this._resources);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new CopySqlAction(this.getApplication(), (net.sourceforge.squirrel_sql.fw.util.Resources)this._resources);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new RemoveNewLinesAction(this.getApplication(), this);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
    }

    public Object getExternalService() {
        return new EditExtrasExternalServiceImpl();
    }

    private static interface IMenuResourceKeys {
        public static final String MENU = "editextras";
    }
}

