# An awk script to convert Gmsh *.msh file to Tochnog
# data file.
# processes 3 noded triangles, 4 noded quads, 8 noded hex
#           and 4 noded tetras. 
#
# usage:
# gawk -f gmsh2tn.awk  foo.msh > foo.dat
#
# Osman Buyukisik   osman@fuse.net
# Revision 1.1  2000/04/11 19:22:29  osman
# Initial revision
#
BEGIN    {mode="NONE";ndim=3;enmax=0;}
/ENDELM/ {mode="NONE";  getline;}
/ENDNOD/ {mode="NONE";  getline;}
/\$ELM/    {
           if (mode=="ELEM") { mode="NONE"; getline;}
            else { mode="ELEM"; getline;enmax=$1+0;
                   printf("\n( %d elements )\n",enmax);
                        getline}
         }
/\$NOD/    {
            if (mode=="NODE") { mode="NONE";  getline; } 
            else { mode="NODE";getline;nmax=$1+0;getline }
            printf("\n( %d nodes )\n",nmax+1);
         }
{   
 if (mode=="NODE") {         n=$1+0;
                             node[n,"x"]=$2+0.0;
                             node[n,"y"]=$3+0.0;
                             node[n,"z"]=$4+0.0;
                    }
   else if (mode == "ELEM") {
                      en=$1+0;etype=$2+0;nelem=$5+0;
                      etypes[en]=etype;
                      if(etype == 1 || etype == 2 || etype == 3) ndim=2;
                      enodes[en]=nelem;
                      elem[en,1]=$6+0;
                      elem[en,2]=$7+0;
                      elem[en,3]=$8+0;
                      elem[en,4]=$9+0;
                      elem[en,5]=$10+0;
                      elem[en,6]=$11+0;
                      elem[en,7]=$12+0;
                      elem[en,8]=$13+0;
                             } 
                            }
END  {
      printf("echo -yes\n");
      printf("number_of_space_dimensions %d\n",ndim);
      printf("materi_velocity\nmateri_stress\nmateri_strain_total\nend_initia\n\n");
      for (i=1;i<=nmax+1;i++) {
       if (ndim == 2 ) {
         printf("node %d %f %f\n",i,node[i,"x"],node[i,"y"])
                       }
       else { 
         printf("node %d %f %f %f\n",i,node[i,"x"],node[i,"y"],
                                            node[i,"z"]); 
            }
                             };
      for (i=1;i<=enmax;i++) {
       if(etypes[i]==2) {
                    printf("element %d -tria3 %d %d %d\n",i,
                               elem[i,1],elem[i,2],elem[i,3]);
                         }
       else if (etypes[i]==3) {
                    printf("element %d -quad4 %d %d %d %d\n",
                             i,elem[i,1],elem[i,2],elem[i,3],elem[i,4])
                               }
       else if (etypes[i]==4) {
                    printf("element %d -tet4 %d %d %d %d\n",
                             i,elem[i,1],elem[i,2],elem[i,3],elem[i,4])
                              }
       else if (etypes[i]==5) {
                    printf("element %d -hex8 %d %d %d %d %d %d %d %d\n",
                             i,elem[i,1],elem[i,2],elem[i,3],elem[i,4],
                               elem[i,5],elem[i,6],elem[i,7],elem[i,8])
                              }
                             }
       printf("\ngroup_type  0  -materi\ngroup_materi_elasti_young 0 1\n");
       printf("\ngroup_materi_elasti_poisson 0 0.3\n\ncontrol_timestep 10 1 1\n\n");
       printf("end_data\n");
       }
