/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.StringUtils;

public class Concat
extends Task {
    private File destinationFile = null;
    private boolean append = false;
    private String encoding = null;
    private StringBuffer textBuffer;
    private Vector fileSets = new Vector();

    public void setDestfile(File destinationFile) {
        this.destinationFile = destinationFile;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void addFileset(FileSet set) {
        this.fileSets.addElement(set);
    }

    public void addFilelist(FileList list) {
        this.fileSets.addElement(list);
    }

    public void addText(String text) {
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(text.length());
        }
        this.textBuffer.append(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.sanitizeText();
        if (this.fileSets.size() == 0 && this.textBuffer == null) {
            throw new BuildException("At least one file must be provided, or some text.");
        }
        if (this.fileSets.size() > 0 && this.textBuffer != null) {
            throw new BuildException("Cannot include inline text when using filesets.");
        }
        boolean savedAppend = this.append;
        try {
            Enumeration e = this.fileSets.elements();
            while (e.hasMoreElements()) {
                File fileSetBase = null;
                String[] srcFiles = null;
                Object next = e.nextElement();
                if (next instanceof FileSet) {
                    FileSet fileSet = (FileSet)next;
                    DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                    fileSetBase = fileSet.getDir(this.getProject());
                    srcFiles = scanner.getIncludedFiles();
                } else if (next instanceof FileList) {
                    FileList fileList = (FileList)next;
                    fileSetBase = fileList.getDir(this.getProject());
                    srcFiles = fileList.getFiles(this.getProject());
                }
                if (srcFiles != null) {
                    this.catFiles(fileSetBase, srcFiles);
                    continue;
                }
                this.log("Warning: Concat received empty fileset.", 1);
            }
        }
        finally {
            this.append = savedAppend;
        }
        this.catText();
    }

    public void reset() {
        this.append = false;
        this.destinationFile = null;
        this.encoding = null;
        this.fileSets = new Vector();
    }

    /*
     * Loose catch block
     */
    private void catFiles(File base, String[] files) {
        block41: {
            Exception ignore32;
            BufferedReader in;
            Writer out;
            block39: {
                Object[] input;
                int len;
                block40: {
                    Exception ignore222;
                    InputStream is;
                    OutputStream os;
                    block38: {
                        Vector<String> inputFileNames = new Vector<String>();
                        for (int i = 0; i < files.length; ++i) {
                            File current = new File(base, files[i]);
                            if (!current.exists()) {
                                this.log("File " + current + " does not exist.", 0);
                                continue;
                            }
                            inputFileNames.addElement(current.getAbsolutePath());
                        }
                        len = inputFileNames.size();
                        if (len == 0) {
                            this.log("Warning: Could not find any of the files specified in concat task.", 1);
                            return;
                        }
                        input = new String[len];
                        inputFileNames.copyInto(input);
                        if (this.encoding != null) break block40;
                        os = null;
                        is = null;
                        if (this.destinationFile == null) {
                            os = new LogOutputStream(this, 1);
                        } else {
                            os = new FileOutputStream(this.destinationFile.getAbsolutePath(), this.append);
                            this.append = true;
                        }
                        for (int i = 0; i < len; ++i) {
                            int bytesRead;
                            if (this.destinationFile != null && this.destinationFile.getAbsolutePath().equals(input[i])) {
                                throw new BuildException("Input file \"" + this.destinationFile.getName() + "\" is the same as the output file.");
                            }
                            is = new FileInputStream((String)input[i]);
                            byte[] buffer = new byte[8192];
                            while ((bytesRead = is.read(buffer)) != -1) {
                                os.write(buffer, 0, bytesRead);
                            }
                            os.flush();
                            is.close();
                            is = null;
                        }
                        Object var12_17 = null;
                        if (is == null) break block38;
                        try {
                            is.close();
                        }
                        catch (Exception ignore222) {
                            // empty catch block
                        }
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception ignore222) {}
                    }
                    break block41;
                    {
                        catch (IOException ioex) {
                            throw new BuildException("Error while concatenating: " + ioex.getMessage(), ioex);
                        }
                    }
                    catch (Throwable throwable) {
                        Exception ignore222;
                        Object var12_18 = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception ignore222) {
                                // empty catch block
                            }
                        }
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Exception ignore222) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                out = null;
                in = null;
                if (this.destinationFile == null) {
                    out = new OutputStreamWriter(new LogOutputStream(this, 1));
                } else {
                    out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.destinationFile.getAbsolutePath(), this.append), this.encoding);
                    this.append = true;
                }
                for (int i = 0; i < len; ++i) {
                    int charsRead;
                    in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((String)input[i]), this.encoding));
                    char[] buffer = new char[4096];
                    while ((charsRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, charsRead);
                    }
                    out.flush();
                    in.close();
                    in = null;
                }
                Object var15_23 = null;
                if (in == null) break block39;
                try {
                    in.close();
                }
                catch (Exception ignore32) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ignore32) {}
            }
            break block41;
            {
                catch (IOException ioe) {
                    throw new BuildException("Error while concatenating: " + ioe.getMessage(), ioe);
                }
            }
            catch (Throwable throwable) {
                Exception ignore32;
                Object var15_24 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ignore32) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception ignore32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void catText() {
        block20: {
            Exception ignore22;
            BufferedReader reader;
            FileWriter writer;
            block19: {
                String line;
                if (this.textBuffer == null) {
                    return;
                }
                String text = this.textBuffer.toString();
                text = ProjectHelper.replaceProperties(this.getProject(), text, this.getProject().getProperties());
                writer = null;
                if (this.destinationFile != null) {
                    try {
                        writer = new FileWriter(this.destinationFile.getAbsolutePath(), this.append);
                    }
                    catch (IOException ioe) {
                        throw new BuildException("Error creating destination file.", ioe);
                    }
                }
                reader = null;
                reader = new BufferedReader(new StringReader(text));
                while ((line = reader.readLine()) != null) {
                    if (this.destinationFile == null) {
                        this.log(line, 1);
                        continue;
                    }
                    writer.write(line);
                    writer.write(StringUtils.LINE_SEP);
                    writer.flush();
                }
                Object var6_7 = null;
                if (reader == null) break block19;
                try {
                    reader.close();
                }
                catch (Exception ignore22) {
                    // empty catch block
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ignore22) {}
            }
            break block20;
            {
                catch (IOException ioe) {
                    throw new BuildException("Error while concatenating text.", ioe);
                }
            }
            catch (Throwable throwable) {
                Exception ignore22;
                Object var6_8 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception ignore22) {
                        // empty catch block
                    }
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception ignore22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private void sanitizeText() {
        if (this.textBuffer != null && this.textBuffer.toString().trim().length() == 0) {
            this.textBuffer = null;
        }
    }
}

