/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.LiteralFormatUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.utils.NumberWithRadix;
import org.jetbrains.kotlin.utils.NumbersKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0007\u001a\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0014\u001a\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"FP_LITERAL_PARTS", "Lkotlin/text/Regex;", "hasIllegalUnderscore", "", "text", "", "elementType", "Lcom/intellij/psi/tree/IElementType;", "hasLongSuffix", "hasUnsignedSuffix", "hasUnsignedLongSuffix", "parseNumericLiteral", "", "type", "parseLong", "", "(Ljava/lang/String;)Ljava/lang/Long;", "parseFloatingLiteral", "parseDouble", "", "(Ljava/lang/String;)Ljava/lang/Double;", "parseFloat", "", "(Ljava/lang/String;)Ljava/lang/Float;", "parseBoolean", "psi"})
@SourceDebugExtension(value={"SMAP\nParseUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParseUtils.kt\norg/jetbrains/kotlin/parsing/ParseUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1761#2,3:114\n*S KotlinDebug\n*F\n+ 1 ParseUtils.kt\norg/jetbrains/kotlin/parsing/ParseUtilsKt\n*L\n26#1:114,3\n*E\n"})
public final class ParseUtilsKt {
    @NotNull
    private static final Regex FP_LITERAL_PARTS = new Regex("([_\\d]*)\\.?([_\\d]*)e?[+-]?([_\\d]*)[f]?");

    public static final boolean hasIllegalUnderscore(@NotNull String text, @NotNull IElementType elementType) {
        boolean bl;
        block7: {
            List<Object> list;
            Intrinsics.checkNotNullParameter(text, "text");
            Intrinsics.checkNotNullParameter(elementType, "elementType");
            if (elementType == KtNodeTypes.INTEGER_CONSTANT) {
                int start = 0;
                int end = text.length();
                if (StringsKt.startsWith(text, "0x", true) || StringsKt.startsWith(text, "0b", true)) {
                    start += 2;
                }
                if (StringsKt.endsWith((CharSequence)text, 'l', true)) {
                    --end;
                }
                String string = text.substring(start, end);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                list = CollectionsKt.listOf(string);
            } else {
                list = SequencesKt.toList(SequencesKt.flatMapIterable(Regex.findAll$default(FP_LITERAL_PARTS, text, 0, 2, null), ParseUtilsKt::hasIllegalUnderscore$lambda$0));
            }
            List parts = list;
            Iterable $this$any$iv = parts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(it != null && (StringsKt.startsWith$default(it, "_", false, 2, null) || StringsKt.endsWith$default(it, "_", false, 2, null)))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasLongSuffix(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return StringsKt.endsWith$default((CharSequence)text, 'l', false, 2, null) || StringsKt.endsWith$default((CharSequence)text, 'L', false, 2, null);
    }

    public static final boolean hasUnsignedSuffix(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return StringsKt.endsWith$default((CharSequence)text, 'u', false, 2, null) || StringsKt.endsWith$default((CharSequence)text, 'U', false, 2, null);
    }

    public static final boolean hasUnsignedLongSuffix(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return StringsKt.endsWith$default(text, "ul", false, 2, null) || StringsKt.endsWith$default(text, "uL", false, 2, null) || StringsKt.endsWith$default(text, "Ul", false, 2, null) || StringsKt.endsWith$default(text, "UL", false, 2, null);
    }

    @Nullable
    public static final Number parseNumericLiteral(@NotNull String text, @NotNull IElementType type) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(type, "type");
        String string = LiteralFormatUtil.removeUnderscores(text);
        Intrinsics.checkNotNullExpressionValue(string, "removeUnderscores(...)");
        String canonicalText = string;
        IElementType iElementType = type;
        return Intrinsics.areEqual(iElementType, KtNodeTypes.INTEGER_CONSTANT) ? (Number)ParseUtilsKt.parseLong(canonicalText) : (Number)(Intrinsics.areEqual(iElementType, KtNodeTypes.FLOAT_CONSTANT) ? ParseUtilsKt.parseFloatingLiteral(canonicalText) : null);
    }

    private static final Long parseLong(String text) {
        Long l2;
        try {
            boolean isUnsigned = false;
            String numberWithoutSuffix = null;
            if (ParseUtilsKt.hasUnsignedLongSuffix(text)) {
                isUnsigned = true;
                numberWithoutSuffix = ParseUtilsKt.parseLong$removeSuffix(text, 2);
            } else if (ParseUtilsKt.hasUnsignedSuffix(text)) {
                isUnsigned = true;
                numberWithoutSuffix = ParseUtilsKt.parseLong$removeSuffix(text, 1);
            } else if (ParseUtilsKt.hasLongSuffix(text)) {
                isUnsigned = false;
                numberWithoutSuffix = ParseUtilsKt.parseLong$removeSuffix(text, 1);
            } else {
                isUnsigned = false;
                numberWithoutSuffix = text;
            }
            NumberWithRadix numberWithRadix = NumbersKt.extractRadix(numberWithoutSuffix);
            String number = numberWithRadix.component1();
            int radix = numberWithRadix.component2();
            l2 = isUnsigned ? Long.parseUnsignedLong(number, radix) : Long.parseLong(number, radix);
        }
        catch (NumberFormatException e2) {
            l2 = null;
        }
        return l2;
    }

    private static final Number parseFloatingLiteral(String text) {
        if (StringsKt.endsWith$default((CharSequence)text, 'f', false, 2, null) || StringsKt.endsWith$default((CharSequence)text, 'F', false, 2, null)) {
            return ParseUtilsKt.parseFloat(text);
        }
        return ParseUtilsKt.parseDouble(text);
    }

    private static final Double parseDouble(String text) {
        Double d2;
        try {
            d2 = Double.parseDouble(text);
        }
        catch (NumberFormatException e2) {
            d2 = null;
        }
        return d2;
    }

    private static final Float parseFloat(String text) {
        Float f2;
        try {
            f2 = Float.valueOf(Float.parseFloat(text));
        }
        catch (NumberFormatException e2) {
            f2 = null;
        }
        return f2;
    }

    public static final boolean parseBoolean(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        if (Intrinsics.areEqual("true", text)) {
            return true;
        }
        if (Intrinsics.areEqual("false", text)) {
            return false;
        }
        throw new IllegalStateException("Must not happen. A boolean literal has text: " + text);
    }

    private static final Iterable hasIllegalUnderscore$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getGroupValues();
    }

    private static final String parseLong$removeSuffix(String $this$parseLong_u24removeSuffix, int i2) {
        String string = $this$parseLong_u24removeSuffix.substring(0, $this$parseLong_u24removeSuffix.length() - i2);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        return string;
    }
}

