<?php

/**
 * BaseEmpEmergencyContact
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                  $emp_number                  Type: integer(4), primary key
 * @property float                $seqno                       Type: decimal(2), primary key
 * @property string               $name                        Type: string(100)
 * @property string               $relationship                Type: string(100)
 * @property string               $home_phone                  Type: string(100)
 * @property string               $mobile_phone                Type: string(100)
 * @property string               $office_phone                Type: string(100)
 * @property Employee             $Employee                    
 *  
 * @method int                    getEmpNumber()               Type: integer(4), primary key
 * @method float                  getSeqno()                   Type: decimal(2), primary key
 * @method string                 getName()                    Type: string(100)
 * @method string                 getRelationship()            Type: string(100)
 * @method string                 getHomePhone()               Type: string(100)
 * @method string                 getMobilePhone()             Type: string(100)
 * @method string                 getOfficePhone()             Type: string(100)
 * @method Employee               getEmployee()                
 *  
 * @method EmpEmergencyContact    setEmpNumber(int $val)       Type: integer(4), primary key
 * @method EmpEmergencyContact    setSeqno(float $val)         Type: decimal(2), primary key
 * @method EmpEmergencyContact    setName(string $val)         Type: string(100)
 * @method EmpEmergencyContact    setRelationship(string $val) Type: string(100)
 * @method EmpEmergencyContact    setHomePhone(string $val)    Type: string(100)
 * @method EmpEmergencyContact    setMobilePhone(string $val)  Type: string(100)
 * @method EmpEmergencyContact    setOfficePhone(string $val)  Type: string(100)
 * @method EmpEmergencyContact    setEmployee(Employee $val)   
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseEmpEmergencyContact extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('hs_hr_emp_emergency_contacts');
        $this->hasColumn('emp_number', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 4,
             ));
        $this->hasColumn('eec_seqno as seqno', 'decimal', 2, array(
             'type' => 'decimal',
             'primary' => true,
             'length' => 2,
             ));
        $this->hasColumn('eec_name as name', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('eec_relationship as relationship', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('eec_home_no as home_phone', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('eec_mobile_no as mobile_phone', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('eec_office_no as office_phone', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Employee', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));
    }
}