/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.database.util.Case;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCloseBlockProcessorImpl
implements SqlCloseBlockProcessor {
    private final SubstitutionDescriptor[] myDescriptors;

    public SqlCloseBlockProcessorImpl(SubstitutionDescriptor ... descriptors) {
        if (descriptors == null) {
            SqlCloseBlockProcessorImpl.$$$reportNull$$$0(0);
        }
        this.myDescriptors = descriptors;
    }

    @Override
    public boolean process(@NotNull PsiElement workingElement, @NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        if (workingElement == null) {
            SqlCloseBlockProcessorImpl.$$$reportNull$$$0(1);
        }
        if (file == null) {
            SqlCloseBlockProcessorImpl.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            SqlCloseBlockProcessorImpl.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            SqlCloseBlockProcessorImpl.$$$reportNull$$$0(4);
        }
        for (SubstitutionDescriptor descriptor : this.myDescriptors) {
            PsiElement root2 = descriptor.getExprRoot(workingElement);
            if (root2 == null) continue;
            ArrayList path = ContainerUtil.newArrayList();
            do {
                path.add(workingElement);
            } while (workingElement != root2 && (workingElement = workingElement.getParent()) != null);
            return this.processDescriptor(path, descriptor, editor, dataContext);
        }
        return false;
    }

    private boolean needsSubstitution(@NotNull List<PsiElement> path) {
        if (path == null) {
            SqlCloseBlockProcessorImpl.$$$reportNull$$$0(5);
        }
        for (SubstitutionDescriptor descriptor : this.myDescriptors) {
            if (!descriptor.isExprRoot(path)) continue;
            if (!descriptor.needsSubstitution(path)) break;
            return true;
        }
        return false;
    }

    private boolean processDescriptor(@NotNull List<PsiElement> path, @NotNull SubstitutionDescriptor desc, @NotNull Editor editor, @NotNull DataContext dataContext) {
        int i2;
        Project project;
        if (path == null) {
            SqlCloseBlockProcessorImpl.$$$reportNull$$$0(6);
        }
        if (desc == null) {
            SqlCloseBlockProcessorImpl.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            SqlCloseBlockProcessorImpl.$$$reportNull$$$0(8);
        }
        if (dataContext == null) {
            SqlCloseBlockProcessorImpl.$$$reportNull$$$0(9);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return false;
        }
        int oldSize = path.size();
        if (!desc.needsSubstitution(path)) {
            boolean mismatchFound = false;
            while (((PsiElement)ContainerUtil.getLastItem(path)).getNode() != null && ((PsiElement)ContainerUtil.getLastItem(path)).getParent() != null && !mismatchFound) {
                path.add(((PsiElement)ContainerUtil.getLastItem(path)).getParent());
                mismatchFound = this.needsSubstitution(path);
            }
            if (!mismatchFound) {
                return false;
            }
        }
        Pair<String, String> substitution = desc.getSubstitution(path.subList(0, oldSize));
        int caret = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(caret);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        SqlCodeStyleSettings sqlSettings = (SqlCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(SqlCodeStyleSettings.class);
        Case caseModeExt = sqlSettings.getCaseModeExt(sqlSettings.KEYWORD_CASE);
        int nlines1 = ((String)substitution.getFirst()).split("\\n").length;
        int nlines2 = ((String)substitution.getSecond()).split("\\n").length;
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + caseModeExt.apply((String)substitution.getFirst())));
        editor.getCaretModel().moveToOffset(lineEndOffset + 1 + ((String)substitution.getFirst()).length());
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + caseModeExt.apply((String)substitution.getSecond())));
        for (i2 = 1; i2 < nlines1; ++i2) {
            SqlCloseBlockProcessorImpl.indentLine(project, document, lineNumber + i2);
        }
        for (i2 = 0; i2 < nlines2; ++i2) {
            SqlCloseBlockProcessorImpl.indentLine(project, document, lineNumber + nlines1 + 1 + i2);
        }
        SqlCloseBlockProcessorImpl.indentLineAndMoveCaret(project, editor, document, lineNumber + nlines1);
        return true;
    }

    protected static int indentLine(@NotNull Project project, @NotNull Document document, int lineNumber) {
        if (project == null) {
            SqlCloseBlockProcessorImpl.$$$reportNull$$$0(10);
        }
        if (document == null) {
            SqlCloseBlockProcessorImpl.$$$reportNull$$$0(11);
        }
        if (0 > lineNumber || lineNumber >= document.getLineCount()) {
            return -1;
        }
        return CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, document.getLineStartOffset(lineNumber));
    }

    protected static int indentLineAndMoveCaret(@NotNull Project project, @NotNull Editor editor, @NotNull Document document, int lineNumber) {
        int offset;
        if (project == null) {
            SqlCloseBlockProcessorImpl.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            SqlCloseBlockProcessorImpl.$$$reportNull$$$0(13);
        }
        if (document == null) {
            SqlCloseBlockProcessorImpl.$$$reportNull$$$0(14);
        }
        if ((offset = SqlCloseBlockProcessorImpl.indentLine(project, document, lineNumber)) != -1) {
            editor.getCaretModel().moveToOffset(offset);
        }
        return offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/editor/SqlCloseBlockProcessorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "needsSubstitution";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "processDescriptor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "indentLine";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "indentLineAndMoveCaret";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface SubstitutionDescriptor {
        public boolean isExprRoot(@NotNull List<PsiElement> var1);

        @Nullable
        public PsiElement getExprRoot(@NotNull PsiElement var1);

        public boolean needsSubstitution(@NotNull List<PsiElement> var1);

        @NotNull
        public Pair<String, String> getSubstitution(@NotNull List<PsiElement> var1);
    }
}

