/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.context.NamespaceContext;
import org.intellij.lang.xpath.psi.PrefixReference;
import org.intellij.lang.xpath.psi.QNameElement;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.psi.impl.PrefixedNameImpl;
import org.intellij.lang.xpath.psi.impl.ReferenceBase;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PrefixReferenceImpl
extends ReferenceBase
implements PrefixReference {
    PrefixReferenceImpl(QNameElement element, ASTNode nameNode) {
        super(element, nameNode);
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        ContextProvider provider = this.getElement().getXPathContext();
        NamespaceContext namespaceContext = provider.getNamespaceContext();
        if (namespaceContext != null) {
            return namespaceContext.resolve(this.getCanonicalText(), provider.getContextElement());
        }
        return null;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            PrefixReferenceImpl.$$$reportNull$$$0(0);
        }
        XPathNodeTest expr = (XPathNodeTest)XPathChangeUtil.createExpression(this.getElement(), newElementName + ":x").getFirstChild().getChildren()[1];
        ASTNode nameNode = this.getNameNode();
        nameNode.getTreeParent().replaceChild(nameNode, ((PrefixedNameImpl)expr.getQName()).getPrefixNode());
        return this.getElement();
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            PrefixReferenceImpl.$$$reportNull$$$0(1);
        }
        return EMPTY_ARRAY;
    }

    @Override
    public boolean isSoft() {
        if ("*".equals(this.getPrefix())) {
            return true;
        }
        ContextProvider context = this.getElement().getXPathContext();
        if (context instanceof ContextProvider.DefaultProvider) {
            return true;
        }
        return !this.canResolve();
    }

    @Override
    public String getPrefix() {
        return this.getCanonicalText();
    }

    @Override
    public boolean isUnresolved() {
        if (!this.canResolve()) {
            return true;
        }
        if (this.resolve() != null) {
            return false;
        }
        ContextProvider provider = this.getElement().getXPathContext();
        NamespaceContext namespaceContext = provider.getNamespaceContext();
        assert (namespaceContext != null);
        String prefix = this.getCanonicalText();
        return !namespaceContext.getKnownPrefixes(provider.getContextElement()).contains(prefix);
    }

    private boolean canResolve() {
        NamespaceContext namespaceContext = this.getElement().getXPathContext().getNamespaceContext();
        return namespaceContext != null && !"xml".equals(this.getCanonicalText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/psi/impl/PrefixReferenceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/psi/impl/PrefixReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

