/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.configData;

import com.google.gson.JsonElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.configData.ComposerConfigClient;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ComposerConfigListener<T> {
    @NotNull
    private final ComposerConfigClient<T> myClient;
    private final List<ComposerConfigElement> myConfigElements;
    private T myOldData;

    ComposerConfigListener(@NotNull ComposerConfigClient<T> client) {
        if (client == null) {
            ComposerConfigListener.$$$reportNull$$$0(0);
        }
        this.myClient = client;
        this.myConfigElements = ContainerUtil.newSmartList();
        for (String path : client.getPath()) {
            this.myConfigElements.add(new ComposerConfigElement(path));
        }
    }

    public void inform(@Nullable JsonElement fileElement, @NotNull Project project, boolean initialized) {
        if (project == null) {
            ComposerConfigListener.$$$reportNull$$$0(1);
        }
        boolean wasUpdated = false;
        HashMap updated = ContainerUtil.newHashMap();
        for (ComposerConfigElement element : this.myConfigElements) {
            JsonElement newElement;
            wasUpdated = element.update(newElement = ComposerConfigListener.findElement(fileElement, element.path, 0)) || wasUpdated;
            updated.put(element.getName(), newElement);
        }
        if (!initialized && !wasUpdated) {
            return;
        }
        T newData = this.myClient.parse(updated);
        if (newData == null ? this.myOldData == null : newData.equals(this.myOldData) && !initialized) {
            return;
        }
        this.myOldData = newData;
        this.myClient.consume(newData, project);
    }

    @Nullable
    private static JsonElement findElement(@Nullable JsonElement element, @NotNull List<String> path, int index) {
        if (path == null) {
            ComposerConfigListener.$$$reportNull$$$0(2);
        }
        if (element == null) {
            return null;
        }
        if (index == path.size()) {
            return element;
        }
        if (element.isJsonObject()) {
            JsonElement childElement = element.getAsJsonObject().get(path.get(index));
            return ComposerConfigListener.findElement(childElement, path, index + 1);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/configData/ComposerConfigListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "inform";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ComposerConfigElement {
        private final List<String> path;
        private JsonElement oldElement;

        private ComposerConfigElement(@NotNull String path) {
            if (path == null) {
                ComposerConfigElement.$$$reportNull$$$0(0);
            }
            this.path = StringUtil.split((String)path, (String)"/");
        }

        @NotNull
        public String getName() {
            String string = this.path.isEmpty() ? "" : this.path.get(this.path.size() - 1);
            if (string == null) {
                ComposerConfigElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean update(@Nullable JsonElement newElement) {
            boolean updated;
            boolean bl = newElement == null ? this.oldElement != null : (updated = !newElement.equals(this.oldElement));
            if (updated) {
                this.oldElement = newElement;
            }
            return updated;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/composer/configData/ComposerConfigListener$ComposerConfigElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/composer/configData/ComposerConfigListener$ComposerConfigElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

