/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Statement;
import org.jetbrains.annotations.NotNull;

public class GeneratePhpDocQuickFix
implements LocalQuickFix {
    public static final GeneratePhpDocQuickFix INSTANCE = new GeneratePhpDocQuickFix(false);
    public static final GeneratePhpDocQuickFix ON_THE_FLY = new GeneratePhpDocQuickFix(true);
    public static final String NAME = "Generate PHPDoc Comment";
    private final boolean myOnTheFly;

    private GeneratePhpDocQuickFix(boolean onTheFly) {
        this.myOnTheFly = onTheFly;
    }

    @NotNull
    public String getFamilyName() {
        if (NAME == null) {
            GeneratePhpDocQuickFix.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            GeneratePhpDocQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            GeneratePhpDocQuickFix.$$$reportNull$$$0(2);
        }
        PsiElement element = descriptor.getPsiElement();
        Object beforeElement = null;
        Object forElement = null;
        IElementType elementType = element.getNode().getElementType();
        if (elementType == PhpTokenTypes.IDENTIFIER) {
            beforeElement = element.getParent();
            if (beforeElement instanceof Field || beforeElement instanceof Constant) {
                beforeElement = beforeElement.getParent();
            }
            forElement = beforeElement;
        } else if (elementType == PhpTokenTypes.VARIABLE) {
            forElement = PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)Field.INSTANCEOF);
            if (forElement != null) {
                beforeElement = forElement.getParent();
            }
        } else if ((elementType == PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE || elementType == PhpTokenTypes.STRING_LITERAL) && (forElement = PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)Constant.INSTANCEOF)) != null) {
            beforeElement = PhpPsiUtil.getParentByCondition(forElement, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        }
        if (beforeElement == null) {
            return;
        }
        PhpDocComment docComment = PhpDocCommentGenerator.constructDocComment(project, forElement, this.myOnTheFly);
        if (docComment != null) {
            TextRange docRange = PhpCodeEditUtil.insertDocCommentBeforeAndGetTextRange(beforeElement, docComment);
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor != null) {
                PhpDocCommentGenerator.tryMoveCaretOnMarker(editor, docRange);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/GeneratePhpDocQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/GeneratePhpDocQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

