/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="composite_test_pattern")
public class PhpUnitTestPattern {
    public static final PhpUnitTestPattern[] EMPTY_ARRAY = new PhpUnitTestPattern[0];
    @NotNull
    private String myClassFqn;
    @Nullable
    private String myMethodName;
    @Nullable
    private String myContainingFileAbsolutePath;
    @Nullable
    private String myDataSet;

    public PhpUnitTestPattern() {
        this.myClassFqn = "";
    }

    public PhpUnitTestPattern(@NotNull String classFqn, @Nullable String methodName, @Nullable String containingFileAbsolutePath, @Nullable String dataSet) {
        if (classFqn == null) {
            PhpUnitTestPattern.$$$reportNull$$$0(0);
        }
        this.myClassFqn = classFqn;
        this.myMethodName = methodName;
        this.myContainingFileAbsolutePath = containingFileAbsolutePath;
        this.myDataSet = dataSet;
    }

    public PhpUnitTestPattern(@NotNull String classFqn, @Nullable String methodName, @Nullable String containingFileAbsolutePath) {
        if (classFqn == null) {
            PhpUnitTestPattern.$$$reportNull$$$0(1);
        }
        this(classFqn, methodName, containingFileAbsolutePath, null);
    }

    @Attribute(value="class_fqn")
    @NotNull
    public String getClassFqn() {
        String string = this.myClassFqn;
        if (string == null) {
            PhpUnitTestPattern.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Attribute(value="method_name")
    @Nullable
    public String getMethodName() {
        return this.myMethodName;
    }

    @Attribute(value="file_path")
    @Nullable
    public String getContainingFileAbsolutePath() {
        return this.myContainingFileAbsolutePath;
    }

    @Attribute(value="dataset")
    @Nullable
    public String getDataSet() {
        return this.myDataSet;
    }

    public void setClassFqn(@NotNull String classFqn) {
        if (classFqn == null) {
            PhpUnitTestPattern.$$$reportNull$$$0(3);
        }
        this.myClassFqn = classFqn;
    }

    public void setMethodName(@Nullable String methodName) {
        this.myMethodName = methodName;
    }

    public void setContainingFileAbsolutePath(@Nullable String containingFileAbsolutePath) {
        this.myContainingFileAbsolutePath = containingFileAbsolutePath;
    }

    public void setDataSet(@Nullable String dataSet) {
        this.myDataSet = dataSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhpUnitTestPattern pattern = (PhpUnitTestPattern)o;
        return Objects.equals(this.myClassFqn, pattern.myClassFqn) && Objects.equals(this.myMethodName, pattern.myMethodName) && Objects.equals(this.myContainingFileAbsolutePath, pattern.myContainingFileAbsolutePath) && Objects.equals(this.myDataSet, pattern.myDataSet);
    }

    public int hashCode() {
        return Objects.hash(this.myClassFqn, this.myMethodName, this.myContainingFileAbsolutePath, this.myDataSet);
    }

    @Nullable
    public static PhpUnitTestPattern create(@Nullable PsiElement element, @Nullable String dataSet) {
        if (element instanceof PhpNamedElement) {
            String path = element.getContainingFile().getVirtualFile().getPath();
            if (element instanceof PhpClass) {
                return new PhpUnitTestPattern(((PhpClass)element).getPresentableFQN(), null, path);
            }
            if (element instanceof Method) {
                PhpClass aClass = ((Method)element).getContainingClass();
                assert (aClass != null);
                return new PhpUnitTestPattern(aClass.getPresentableFQN(), ((Method)element).getName(), path, PhpUnitTestPattern.parseDataSet(dataSet));
            }
        }
        return null;
    }

    @Nullable
    public static String parseDataSet(@Nullable String dataSet) {
        if (StringUtil.isEmptyOrSpaces((String)dataSet)) {
            return null;
        }
        if (StringUtil.startsWithChar((CharSequence)dataSet, (char)'#') || PhpUnitTestPattern.isDoubleQuoted(dataSet)) {
            return dataSet;
        }
        if (!StringUtil.startsWithChar((CharSequence)dataSet, (char)'0') && StringUtil.parseInt((String)dataSet, (int)-1) >= 0) {
            return '#' + dataSet;
        }
        return StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeQuotes((String)dataSet));
    }

    private static boolean isDoubleQuoted(@NotNull String dataSet) {
        if (dataSet == null) {
            PhpUnitTestPattern.$$$reportNull$$$0(4);
        }
        return dataSet.length() > 1 && dataSet.charAt(0) == '\"' && dataSet.charAt(0) == dataSet.charAt(dataSet.length() - 1);
    }

    public static PhpUnitTestPattern create(@Nullable PhpNamedElement element) {
        return PhpUnitTestPattern.create((PsiElement)element, null);
    }

    public String toString() {
        String dataSetPart = this.myDataSet != null ? " with data set " + this.myDataSet : "";
        return StringUtil.isNotEmpty((String)this.myMethodName) ? this.myClassFqn + "." + this.myMethodName + dataSetPart : this.myClassFqn;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitTestPattern";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitTestPattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setClassFqn";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDoubleQuoted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

