/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.ui.NonFocusableCheckBox;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpClassMemberRenameProcessor
extends RenamePsiElementProcessor {
    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            PhpClassMemberRenameProcessor.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            PhpClassMemberRenameProcessor.$$$reportNull$$$0(1);
        }
        if (allRenames == null) {
            PhpClassMemberRenameProcessor.$$$reportNull$$$0(2);
        }
        PhpClassMember member = (PhpClassMember)element;
        Project project = member.getProject();
        ArrayList list = new ArrayList();
        PhpClassHierarchyUtils.HierarchyClassMemberProcessor collect = (classMember, subClass, baseClass) -> {
            list.add(classMember);
            return true;
        };
        PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)member, (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)collect);
        for (PhpClassMember curMethod : new ArrayList(list)) {
            PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)curMethod, (PhpIndex)PhpIndex.getInstance((Project)project), (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)collect);
        }
        PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)member, (PhpIndex)PhpIndex.getInstance((Project)project), (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)collect);
        for (PsiElement overridder : list) {
            allRenames.put(overridder, newName);
        }
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element) {
        PhpModifier.Access access;
        if (element == null) {
            PhpClassMemberRenameProcessor.$$$reportNull$$$0(3);
        }
        if (element instanceof PhpClassMember && (access = ((PhpClassMember)element).getModifier().getAccess()).isPrivate() && !this.isSearchInGlobalScope()) {
            Collection collection = ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope((PsiElement)element.getContainingFile())).findAll();
            if (collection == null) {
                PhpClassMemberRenameProcessor.$$$reportNull$$$0(4);
            }
            return collection;
        }
        Collection collection = super.findReferences(element);
        if (collection == null) {
            PhpClassMemberRenameProcessor.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
        if (project == null) {
            PhpClassMemberRenameProcessor.$$$reportNull$$$0(6);
        }
        if (element == null) {
            PhpClassMemberRenameProcessor.$$$reportNull$$$0(7);
        }
        if (element instanceof PhpClassMember && !((PhpClassMember)element).getModifier().getAccess().isPrivate()) {
            RenameDialog renameDialog = super.createRenameDialog(project, element, nameSuggestionContext, editor);
            if (renameDialog == null) {
                PhpClassMemberRenameProcessor.$$$reportNull$$$0(8);
            }
            return renameDialog;
        }
        RenameDialog renameDialog = new RenameDialog(project, element, nameSuggestionContext, editor){
            private JCheckBox myCbSearchInGlobalScope;

            protected void createCheckboxes(JPanel panel, GridBagConstraints gbConstraints) {
                super.createCheckboxes(panel, gbConstraints);
                this.myCbSearchInGlobalScope = new NonFocusableCheckBox(PhpBundle.message("refactoring.rename.search.in.global.scope", new Object[0]));
                this.myCbSearchInGlobalScope.setSelected(PhpClassMemberRenameProcessor.this.isSearchInGlobalScope());
                panel.add((Component)this.myCbSearchInGlobalScope, gbConstraints);
            }

            protected void doAction() {
                PhpClassMemberRenameProcessor.this.setSearchInGlobalScope(this.myCbSearchInGlobalScope.isSelected());
                super.doAction();
            }
        };
        if (renameDialog == null) {
            PhpClassMemberRenameProcessor.$$$reportNull$$$0(9);
        }
        return renameDialog;
    }

    protected abstract boolean isSearchInGlobalScope();

    protected abstract void setSearchInGlobalScope(boolean var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/rename/PhpClassMemberRenameProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/rename/PhpClassMemberRenameProcessor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

