/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework.run;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.run.PhpRunConfiguration;
import com.jetbrains.php.testFramework.run.PhpTestRunConfiguration;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationSettings;
import com.jetbrains.php.testFramework.run.PhpTestRunnerSettings;
import com.jetbrains.php.testFramework.run.PhpTestRunnerSettingsValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTestConfigurationProducer<C extends PhpTestRunConfiguration>
extends RunConfigurationProducer<C> {
    protected Condition<PsiElement> myMethodCondition;
    protected Function<PsiFile, PsiElement> myFileToScopeFunction;
    protected Function<PsiElement, String> myMethodNameProvider;
    protected PhpTestRunnerSettingsValidator myValidator;

    public PhpTestConfigurationProducer(@NotNull ConfigurationType type, @NotNull PhpTestRunnerSettingsValidator validator, @NotNull Function<PsiFile, PsiElement> fileToScope, @NotNull Function<PsiElement, String> methodNameProvider, @NotNull Condition<PsiElement> methodCondition) {
        if (type == null) {
            PhpTestConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (validator == null) {
            PhpTestConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (fileToScope == null) {
            PhpTestConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (methodNameProvider == null) {
            PhpTestConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (methodCondition == null) {
            PhpTestConfigurationProducer.$$$reportNull$$$0(4);
        }
        super(type);
        this.myValidator = validator;
        this.myFileToScopeFunction = fileToScope;
        this.myMethodNameProvider = methodNameProvider;
        this.myMethodCondition = methodCondition;
    }

    protected abstract boolean isEnabled(@NotNull Project var1);

    @Nullable
    protected abstract VirtualFile getWorkingDirectory(@NotNull PsiElement var1);

    protected boolean setupConfigurationFromContext(C configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (!this.isEnabled(configuration.getProject())) {
            return false;
        }
        Location location = context.getLocation();
        if (!(location instanceof PsiLocation)) {
            return false;
        }
        PsiElement originalElement = location.getPsiElement();
        PsiElement element = this.findTestElement(originalElement, this.getWorkingDirectory(originalElement));
        if (element == null) {
            return false;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return false;
        }
        PhpTestRunnerSettings testRunnerSettings = ((PhpTestRunConfigurationSettings)((PhpRunConfiguration)configuration).getSettings()).getRunnerSettings();
        PsiElement source = this.setupConfiguration(testRunnerSettings, element, virtualFile);
        if (source == null) {
            return false;
        }
        sourceElement.set((Object)source);
        configuration.setName(((PhpTestRunConfiguration)configuration).suggestedName());
        return true;
    }

    @Nullable
    protected PsiElement setupConfiguration(@NotNull PhpTestRunnerSettings testRunnerSettings, @NotNull PsiElement element, @NotNull VirtualFile virtualFile) {
        String methodName;
        if (testRunnerSettings == null) {
            PhpTestConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (element == null) {
            PhpTestConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (virtualFile == null) {
            PhpTestConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (element instanceof PsiDirectory) {
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.Directory);
            testRunnerSettings.setDirectoryPath(virtualFile.getPresentableUrl());
            return element;
        }
        if (element instanceof PsiFile) {
            PsiElement scope = (PsiElement)this.myFileToScopeFunction.fun((Object)((PsiFile)element));
            if (scope != null) {
                testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.File);
                testRunnerSettings.setFilePath(virtualFile.getPresentableUrl());
            }
            return scope;
        }
        if (this.myMethodCondition.value((Object)element) && StringUtil.isNotEmpty((String)(methodName = (String)this.myMethodNameProvider.fun((Object)element)))) {
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.Method);
            testRunnerSettings.setMethodName(methodName);
            testRunnerSettings.setFilePath(virtualFile.getPresentableUrl());
            return element;
        }
        return null;
    }

    public boolean isConfigurationFromContext(C configuration, ConfigurationContext context) {
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        PsiElement originalElement = location.getPsiElement();
        PsiElement psiElement = this.findTestElement(originalElement, this.getWorkingDirectory(originalElement));
        if (psiElement == null) {
            return false;
        }
        PhpTestRunnerSettings testRunnerSettings = ((PhpTestRunConfigurationSettings)((PhpRunConfiguration)configuration).getSettings()).getRunnerSettings();
        return this.isConfigurationFromContext(testRunnerSettings, psiElement);
    }

    protected boolean isConfigurationFromContext(@NotNull PhpTestRunnerSettings testRunnerSettings, @NotNull PsiElement psiElement) {
        PsiFile psiFile;
        VirtualFile virtualFile;
        String methodName;
        if (testRunnerSettings == null) {
            PhpTestConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (psiElement == null) {
            PhpTestConfigurationProducer.$$$reportNull$$$0(9);
        }
        if (psiElement instanceof PsiDirectory) {
            String directoryPath = ((PsiDirectory)psiElement).getVirtualFile().getPath();
            String path = testRunnerSettings.getDirectoryPath();
            return testRunnerSettings.getScope() == PhpTestRunnerSettings.Scope.Directory && path != null && FileUtil.comparePaths((String)directoryPath, (String)FileUtil.toSystemIndependentName((String)path)) == 0;
        }
        if (psiElement instanceof PsiFile) {
            PsiFile psiFile2 = psiElement.getContainingFile();
            VirtualFile virtualFile2 = psiFile2.getVirtualFile();
            if (virtualFile2 != null) {
                String path = virtualFile2.getPath();
                String filePath = testRunnerSettings.getFilePath();
                return testRunnerSettings.getScope() == PhpTestRunnerSettings.Scope.File && filePath != null && FileUtil.comparePaths((String)path, (String)FileUtil.toSystemIndependentName((String)filePath)) == 0;
            }
        } else if (this.myMethodCondition.value((Object)psiElement) && StringUtil.isNotEmpty((String)(methodName = (String)this.myMethodNameProvider.fun((Object)psiElement))) && (virtualFile = (psiFile = psiElement.getContainingFile()).getVirtualFile()) != null) {
            String path = virtualFile.getPath();
            String filePath = testRunnerSettings.getFilePath();
            return testRunnerSettings.getScope() == PhpTestRunnerSettings.Scope.Method && filePath != null && FileUtil.comparePaths((String)path, (String)FileUtil.toSystemIndependentName((String)filePath)) == 0 && StringUtil.equals((CharSequence)methodName, (CharSequence)testRunnerSettings.getMethodName());
        }
        return false;
    }

    @Nullable
    public PsiElement findTestElement(@Nullable PsiElement element, @Nullable VirtualFile workingDirectory) {
        if (element == null || workingDirectory == null) {
            return null;
        }
        if (element instanceof PsiDirectory) {
            return this.myValidator.isDirectoryValid(((PsiDirectory)element).getVirtualFile(), workingDirectory) == null ? element : null;
        }
        PsiFile file = element.getContainingFile();
        if (this.myValidator.isFileValid(file, workingDirectory) == null) {
            Object method = PhpPsiUtil.getParentByCondition(element, false, this.myMethodCondition);
            String name = (String)this.myMethodNameProvider.fun(method);
            if (StringUtil.isNotEmpty((String)name) && this.myValidator.isMethodValid(file, name) == null) {
                return method;
            }
            return file;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodNameProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCondition";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnerSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/testFramework/run/PhpTestConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfiguration";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationFromContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

