/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.view.actions.MarkUnmarkAction;
import com.jetbrains.nodejs.run.profile.heap.view.components.ChainTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.nodes.FixedRetainerNode;
import javax.swing.tree.TreePath;

public class EntryDataGetter {
    private final TreeTable myTable;
    private V8HeapEntry myData;
    private Long mySelectedEdgeId;
    private boolean myUnreachable;
    private final Runnable myRunnable;
    private final Project myProject;

    public EntryDataGetter(DataContext dc, TreeTable table) {
        this.myTable = table;
        this.myData = null;
        this.myUnreachable = false;
        if (this.myTable != null) {
            TreePath path = this.myTable.getTree().getSelectionPath();
            if (path != null && path.getLastPathComponent() instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                V8HeapContainmentTreeTableModel.NamedEntry namedEntry = (V8HeapContainmentTreeTableModel.NamedEntry)path.getLastPathComponent();
                this.myData = namedEntry.getEntry();
                this.myUnreachable = path.getLastPathComponent() instanceof FixedRetainerNode && ((FixedRetainerNode)path.getLastPathComponent()).isUnreachable();
                this.mySelectedEdgeId = namedEntry.getLinkOffset() / 37L;
            } else if (path != null && path.getLastPathComponent() instanceof ChainTreeTableModel.Node && ((ChainTreeTableModel.Node)path.getLastPathComponent()).getT() instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                Object nodeData = ((ChainTreeTableModel.Node)path.getLastPathComponent()).getT();
                V8HeapContainmentTreeTableModel.NamedEntry namedEntry = (V8HeapContainmentTreeTableModel.NamedEntry)nodeData;
                this.myData = namedEntry.getEntry();
                this.myUnreachable = nodeData instanceof FixedRetainerNode && ((FixedRetainerNode)nodeData).isUnreachable();
                this.mySelectedEdgeId = namedEntry.getLinkOffset() / 37L;
            }
        } else {
            this.mySelectedEdgeId = (Long)MarkUnmarkAction.SELECTED_LINK.getData(dc);
            this.myData = (V8HeapEntry)MarkUnmarkAction.SELECTED_NODE.getData(dc);
            this.myUnreachable = Boolean.TRUE.equals(MarkUnmarkAction.UNREACHABLE_NODE.getData(dc));
        }
        this.myRunnable = (Runnable)MarkUnmarkAction.REVALIDATION.getData(dc);
        this.myProject = (Project)PlatformDataKeys.PROJECT.getData(dc);
    }

    public V8HeapEntry getData() {
        return this.myData;
    }

    public boolean isUnreachable() {
        return this.myUnreachable;
    }

    public Runnable getRunnable() {
        return this.myRunnable;
    }

    public Project getProject() {
        return this.myProject;
    }

    public Long getSelectedEdgeId() {
        return this.mySelectedEdgeId;
    }
}

