/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything;

import com.intellij.ide.actions.BigPopupUI;
import com.intellij.ide.actions.runAnything.RunAnythingPopupUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.JBInsets;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAnythingManager {
    private static final String LOCATION_SETTINGS_KEY = "run.anything.popup";
    private final Project myProject;
    private JBPopup myBalloon;
    private RunAnythingPopupUI myRunAnythingUI;
    private Dimension myBalloonFullSize;

    public RunAnythingManager(@NotNull Project project) {
        if (project == null) {
            RunAnythingManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    static RunAnythingManager getInstance(@NotNull Project project) {
        if (project == null) {
            RunAnythingManager.$$$reportNull$$$0(1);
        }
        return (RunAnythingManager)ServiceManager.getService((Project)project, RunAnythingManager.class);
    }

    public void show(@Nullable String searchText, @NotNull AnActionEvent initEvent) {
        if (initEvent == null) {
            RunAnythingManager.$$$reportNull$$$0(2);
        }
        Project project = initEvent.getProject();
        this.myRunAnythingUI = this.createView(initEvent);
        if (searchText != null && !searchText.isEmpty()) {
            this.myRunAnythingUI.getSearchField().setText(searchText);
            this.myRunAnythingUI.getSearchField().selectAll();
        }
        this.myBalloon = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)this.myRunAnythingUI), (JComponent)this.myRunAnythingUI.getSearchField()).setProject(this.myProject).setModalContext(false).setCancelOnClickOutside(true).setRequestFocus(true).setCancelKeyEnabled(false).addUserData((Object)"SIMPLE_WINDOW").setResizable(true).setMovable(true).setDimensionServiceKey(project, LOCATION_SETTINGS_KEY, true).setLocateWithinScreenBounds(false).createPopup();
        Disposer.register((Disposable)this.myBalloon, (Disposable)this.myRunAnythingUI);
        if (project != null) {
            Disposer.register((Disposable)project, (Disposable)this.myBalloon);
        }
        Dimension size = this.myRunAnythingUI.getMinimumSize();
        JBInsets.addTo((Dimension)size, (Insets)this.myBalloon.getContent().getInsets());
        this.myBalloon.setMinimumSize(size);
        Disposer.register((Disposable)this.myBalloon, () -> {
            this.saveSize();
            this.myRunAnythingUI = null;
            this.myBalloon = null;
            this.myBalloonFullSize = null;
        });
        if (this.myRunAnythingUI.getViewType() == BigPopupUI.ViewType.SHORT) {
            this.myBalloonFullSize = DimensionService.getInstance().getSize(LOCATION_SETTINGS_KEY, project);
            Dimension prefSize = this.myRunAnythingUI.getPreferredSize();
            this.myBalloon.setSize(prefSize);
        }
        this.calcPositionAndShow(project, this.myBalloon);
    }

    private void calcPositionAndShow(Project project, JBPopup balloon) {
        Point savedLocation = DimensionService.getInstance().getLocation(LOCATION_SETTINGS_KEY, project);
        if (project != null) {
            balloon.showCenteredInCurrentWindow(project);
        } else {
            balloon.showInFocusCenter();
        }
        if (savedLocation == null && this.myRunAnythingUI.getViewType() == BigPopupUI.ViewType.SHORT) {
            Point location = balloon.getLocationOnScreen();
            location.y /= 2;
            balloon.setLocation(location);
        }
    }

    public boolean isShown() {
        return this.myRunAnythingUI != null && this.myBalloon != null && !this.myBalloon.isDisposed();
    }

    @NotNull
    private RunAnythingPopupUI createView(@NotNull AnActionEvent event) {
        if (event == null) {
            RunAnythingManager.$$$reportNull$$$0(3);
        }
        RunAnythingPopupUI view = new RunAnythingPopupUI(event);
        view.setSearchFinishedHandler(() -> {
            if (this.isShown()) {
                this.myBalloon.cancel();
            }
        });
        view.addViewTypeListener(viewType -> {
            if (!this.isShown()) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                Dimension minSize = this.myRunAnythingUI.getMinimumSize();
                JBInsets.addTo((Dimension)minSize, (Insets)this.myBalloon.getContent().getInsets());
                this.myBalloon.setMinimumSize(minSize);
                if (viewType == BigPopupUI.ViewType.SHORT) {
                    this.myBalloonFullSize = this.myBalloon.getSize();
                    JBInsets.removeFrom((Dimension)this.myBalloonFullSize, (Insets)this.myBalloon.getContent().getInsets());
                    this.myBalloon.pack(false, true);
                } else {
                    if (this.myBalloonFullSize == null) {
                        this.myBalloonFullSize = this.myRunAnythingUI.getPreferredSize();
                        JBInsets.addTo((Dimension)this.myBalloonFullSize, (Insets)this.myBalloon.getContent().getInsets());
                    }
                    this.myBalloonFullSize.height = Integer.max(this.myBalloonFullSize.height, minSize.height);
                    this.myBalloonFullSize.width = Integer.max(this.myBalloonFullSize.width, minSize.width);
                    this.myBalloon.setSize(this.myBalloonFullSize);
                }
            });
        });
        RunAnythingPopupUI runAnythingPopupUI = view;
        if (runAnythingPopupUI == null) {
            RunAnythingManager.$$$reportNull$$$0(4);
        }
        return runAnythingPopupUI;
    }

    private void saveSize() {
        if (this.myRunAnythingUI.getViewType() == BigPopupUI.ViewType.SHORT) {
            DimensionService.getInstance().setSize(LOCATION_SETTINGS_KEY, this.myBalloonFullSize, this.myProject);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initEvent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/runAnything/RunAnythingManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/runAnything/RunAnythingManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createView";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

