/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.ui.CommittedChangeListPanel;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Function;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListViewerDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(ChangeListViewerDialog.class);
    private final JBLoadingPanel myLoadingPanel;
    private final CommittedChangeListPanel myChangesPanel;

    public ChangeListViewerDialog(@NotNull Project project) {
        if (project == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(0);
        }
        this(project, null, (CommittedChangeList)CommittedChangeListPanel.createChangeList(Collections.emptyList()), null);
    }

    public ChangeListViewerDialog(@NotNull Project project, @NotNull CommittedChangeList changeList, @Nullable VirtualFile toSelect2) {
        if (project == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(1);
        }
        if (changeList == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(2);
        }
        this(project, null, changeList, toSelect2);
    }

    public ChangeListViewerDialog(@NotNull Project project, @NotNull Collection<Change> changes2) {
        if (project == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(3);
        }
        if (changes2 == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(4);
        }
        this(null, project, changes2);
    }

    public ChangeListViewerDialog(@Nullable Component parent, @NotNull Project project, @NotNull Collection<Change> changes2) {
        if (project == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(5);
        }
        if (changes2 == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(6);
        }
        this(project, parent, (CommittedChangeList)CommittedChangeListPanel.createChangeList(changes2), null);
        this.myChangesPanel.setShowCommitMessage(false);
    }

    private ChangeListViewerDialog(@NotNull Project project, @Nullable Component parentComponent, @NotNull CommittedChangeList changeList, @Nullable VirtualFile toSelect2) {
        if (project == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(7);
        }
        if (changeList == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(8);
        }
        super(project, parentComponent, true, DialogWrapper.IdeModalityType.IDE);
        this.myChangesPanel = new CommittedChangeListPanel(project);
        this.myChangesPanel.setChangeList(changeList);
        this.myChangesPanel.getChangesBrowser().getViewer().selectFile(toSelect2);
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.getDisposable());
        this.myLoadingPanel.add((Component)this.myChangesPanel, (Object)"Center");
        this.setTitle(VcsBundle.message((String)"dialog.title.changes.browser", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.message((String)"close.action.name", (Object[])new Object[0]));
        this.setModal(false);
        this.init();
    }

    public void markChangesInAir(boolean inAir) {
        this.myChangesPanel.getChangesBrowser().setUseCase(inAir ? CommittedChangesBrowserUseCase.IN_AIR : null);
    }

    public void loadChangesInBackground(@NotNull ThrowableComputable<? extends ChangelistData, ? extends VcsException> computable) {
        if (computable == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(9);
        }
        StatusText emptyText = this.myChangesPanel.getChangesBrowser().getViewer().getEmptyText();
        emptyText.setText("");
        BackgroundTaskUtil.executeAndTryWait((Function<? super ProgressIndicator, ? extends Runnable>)((Function)indicator -> {
            if (computable == null) {
                ChangeListViewerDialog.$$$reportNull$$$0(11);
            }
            try {
                ChangelistData result2 = (ChangelistData)computable.compute();
                return () -> {
                    this.myLoadingPanel.stopLoading();
                    this.myChangesPanel.setChangeList(result2.changeList);
                    this.myChangesPanel.getChangesBrowser().getViewer().selectFile(result2.toSelect);
                    emptyText.setText(DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{0}));
                };
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return () -> {
                    this.myLoadingPanel.stopLoading();
                    this.myChangesPanel.setChangeList((CommittedChangeList)CommittedChangeListPanel.createChangeList(Collections.emptySet()));
                    emptyText.setText(e.getMessage(), SimpleTextAttributes.ERROR_ATTRIBUTES);
                };
            }
        }), () -> this.myLoadingPanel.startLoading());
    }

    protected String getDimensionServiceKey() {
        return "VCS.ChangeListViewerDialog";
    }

    public JComponent createCenterPanel() {
        return this.myLoadingPanel;
    }

    @NotNull
    protected Action[] createActions() {
        Action cancelAction = this.getCancelAction();
        cancelAction.putValue("DefaultAction", Boolean.TRUE);
        Action[] actionArray = new Action[]{cancelAction};
        if (actionArray == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(10);
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myChangesPanel.getPreferredFocusedComponent();
    }

    public void setDescription(@Nullable String description) {
        this.myChangesPanel.setDescription(description);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangeListViewerDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangeListViewerDialog";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadChangesInBackground";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadChangesInBackground$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ChangelistData {
        @NotNull
        public final CommittedChangeList changeList;
        @Nullable
        public final FilePath toSelect;

        public ChangelistData(@NotNull CommittedChangeList changeList, @Nullable FilePath toSelect2) {
            if (changeList == null) {
                ChangelistData.$$$reportNull$$$0(0);
            }
            this.changeList = changeList;
            this.toSelect = toSelect2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/ui/ChangeListViewerDialog$ChangelistData", "<init>"));
        }
    }
}

