/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MoveDirectoryWithClassesHelper {
    private static final ExtensionPointName<MoveDirectoryWithClassesHelper> EP_NAME = ExtensionPointName.create((String)"com.intellij.refactoring.moveDirectoryWithClassesHelper");

    public abstract void findUsages(Collection<PsiFile> var1, PsiDirectory[] var2, Collection<UsageInfo> var3, boolean var4, boolean var5, Project var6);

    public abstract boolean move(PsiFile var1, PsiDirectory var2, Map<PsiElement, PsiElement> var3, List<PsiFile> var4, RefactoringElementListener var5);

    public abstract void postProcessUsages(UsageInfo[] var1, Function<PsiDirectory, PsiDirectory> var2);

    public abstract void beforeMove(PsiFile var1);

    public abstract void afterMove(PsiElement var1);

    public void preprocessUsages(Project project, Set<PsiFile> files2, UsageInfo[] infos, PsiDirectory directory, MultiMap<PsiElement, String> conflicts) {
    }

    public static List<MoveDirectoryWithClassesHelper> findAll() {
        return EP_NAME.getExtensionList();
    }

    public static class Default
    extends MoveDirectoryWithClassesHelper {
        @Override
        public void findUsages(Collection<PsiFile> filesToMove, PsiDirectory[] directoriesToMove, Collection<UsageInfo> result2, boolean searchInComments, boolean searchInNonJavaFiles, Project project) {
            for (PsiFile file2 : filesToMove) {
                for (PsiReference reference2 : ReferencesSearch.search((PsiElement)file2)) {
                    result2.add(new MyUsageInfo(reference2, (PsiFileSystemItem)file2));
                }
            }
            for (PsiDirectory psiDirectory : directoriesToMove) {
                for (PsiReference reference3 : ReferencesSearch.search((PsiElement)psiDirectory)) {
                    result2.add(new MyUsageInfo(reference3, (PsiFileSystemItem)psiDirectory));
                }
            }
        }

        @Override
        public void postProcessUsages(UsageInfo[] usages, Function<PsiDirectory, PsiDirectory> newDirMapper) {
            for (UsageInfo usage : usages) {
                PsiReference reference2;
                if (!(usage instanceof MyUsageInfo) || (reference2 = usage.getReference()) == null) continue;
                PsiFileSystemItem file2 = ((MyUsageInfo)usage).myFile;
                if (file2 instanceof PsiDirectory) {
                    file2 = (PsiFileSystemItem)newDirMapper.fun((Object)((PsiDirectory)file2));
                }
                reference2.bindToElement((PsiElement)file2);
            }
        }

        @Override
        public boolean move(PsiFile psiFile, PsiDirectory moveDestination, Map<PsiElement, PsiElement> oldToNewElementsMapping, List<PsiFile> movedFiles, RefactoringElementListener listener2) {
            if (moveDestination.equals(psiFile.getContainingDirectory())) {
                return false;
            }
            MoveFileHandler.forElement(psiFile).prepareMovedFile(psiFile, moveDestination, oldToNewElementsMapping);
            PsiFile moving = moveDestination.findFile(psiFile.getName());
            if (moving == null) {
                MoveFilesOrDirectoriesUtil.doMoveFile(psiFile, moveDestination);
            }
            moving = moveDestination.findFile(psiFile.getName());
            movedFiles.add(moving);
            listener2.elementMoved((PsiElement)psiFile);
            return true;
        }

        @Override
        public void beforeMove(PsiFile psiFile) {
        }

        @Override
        public void afterMove(PsiElement newElement) {
        }

        private static class MyUsageInfo
        extends UsageInfo {
            @NotNull
            private final PsiFileSystemItem myFile;

            MyUsageInfo(@NotNull PsiReference reference2, @NotNull PsiFileSystemItem file2) {
                if (reference2 == null) {
                    MyUsageInfo.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    MyUsageInfo.$$$reportNull$$$0(1);
                }
                super(reference2);
                this.myFile = file2;
            }

            @Nullable
            public PsiReference getReference() {
                PsiElement element = this.getElement();
                if (element == null) {
                    return null;
                }
                ProperTextRange rangeInElement = this.getRangeInElement();
                PsiReference reference2 = rangeInElement != null ? element.findReferenceAt(rangeInElement.getStartOffset()) : element.getReference();
                return reference2 != null && reference2.getRangeInElement().equals((Object)rangeInElement) ? reference2 : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "reference";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/refactoring/move/moveClassesOrPackages/MoveDirectoryWithClassesHelper$Default$MyUsageInfo";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

