/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.settings;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.SystemProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemExecutionSettings
implements Serializable,
UserDataHolder {
    public static final String REMOTE_PROCESS_IDLE_TTL_IN_MS_KEY = "external.system.remote.process.idle.ttl.ms";
    private static final int DEFAULT_REMOTE_PROCESS_TTL_MS = -1;
    private static final long serialVersionUID = 1L;
    private long myRemoteProcessIdleTtlInMs;
    private boolean myVerboseProcessing;
    @NotNull
    private final Set<String> myVmOptions;
    @NotNull
    private final List<String> myArguments;
    @NotNull
    private final Map<String, String> myEnv;
    private boolean myPassParentEnvs = true;
    @NotNull
    private final transient UserDataHolderBase myUserData = new UserDataHolderBase();

    public ExternalSystemExecutionSettings() {
        int ttl = SystemProperties.getIntProperty((String)REMOTE_PROCESS_IDLE_TTL_IN_MS_KEY, (int)-1);
        this.setRemoteProcessIdleTtlInMs(ttl);
        this.myVmOptions = new LinkedHashSet<String>();
        this.myArguments = new ArrayList<String>();
        this.myEnv = new LinkedHashMap<String, String>();
    }

    public long getRemoteProcessIdleTtlInMs() {
        return this.myRemoteProcessIdleTtlInMs;
    }

    public void setRemoteProcessIdleTtlInMs(long remoteProcessIdleTtlInMs) {
        this.myRemoteProcessIdleTtlInMs = remoteProcessIdleTtlInMs;
    }

    public boolean isVerboseProcessing() {
        return this.myVerboseProcessing;
    }

    public void setVerboseProcessing(boolean verboseProcessing) {
        this.myVerboseProcessing = verboseProcessing;
    }

    @NotNull
    public Set<String> getVmOptions() {
        Set<String> set = Collections.unmodifiableSet(this.myVmOptions);
        if (set == null) {
            ExternalSystemExecutionSettings.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public List<String> getArguments() {
        List<String> list = Collections.unmodifiableList(this.myArguments);
        if (list == null) {
            ExternalSystemExecutionSettings.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public Map<String, String> getEnv() {
        Map<String, String> map = Collections.unmodifiableMap(this.myEnv);
        if (map == null) {
            ExternalSystemExecutionSettings.$$$reportNull$$$0(2);
        }
        return map;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public ExternalSystemExecutionSettings withVmOptions(Collection<String> vmOptions) {
        this.myVmOptions.addAll(vmOptions);
        return this;
    }

    public ExternalSystemExecutionSettings withVmOptions(String ... vmOptions) {
        Collections.addAll(this.myVmOptions, vmOptions);
        return this;
    }

    public ExternalSystemExecutionSettings withVmOption(String vmOption) {
        this.myVmOptions.add(vmOption);
        return this;
    }

    public ExternalSystemExecutionSettings withArguments(Collection<String> arguments) {
        this.myArguments.addAll(arguments);
        return this;
    }

    public ExternalSystemExecutionSettings withArguments(String ... arguments) {
        Collections.addAll(this.myArguments, arguments);
        return this;
    }

    public ExternalSystemExecutionSettings withArgument(String argument) {
        this.myArguments.add(argument);
        return this;
    }

    public ExternalSystemExecutionSettings withEnvironmentVariables(Map<String, String> envs) {
        this.myEnv.putAll(envs);
        return this;
    }

    public ExternalSystemExecutionSettings passParentEnvs(boolean passParentEnvs) {
        this.myPassParentEnvs = passParentEnvs;
        return this;
    }

    @Nullable
    public <U> U getUserData(@NotNull Key<U> key) {
        if (key == null) {
            ExternalSystemExecutionSettings.$$$reportNull$$$0(3);
        }
        return (U)this.myUserData.getUserData(key);
    }

    public <U> void putUserData(@NotNull Key<U> key, U value) {
        if (key == null) {
            ExternalSystemExecutionSettings.$$$reportNull$$$0(4);
        }
        this.myUserData.putUserData(key, value);
    }

    public int hashCode() {
        int result2 = (int)(this.myRemoteProcessIdleTtlInMs ^ this.myRemoteProcessIdleTtlInMs >>> 32);
        result2 = 31 * result2 + (this.myVerboseProcessing ? 1 : 0);
        result2 = 31 * result2 + this.myVmOptions.hashCode();
        result2 = 31 * result2 + this.myArguments.hashCode();
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSystemExecutionSettings that = (ExternalSystemExecutionSettings)o;
        if (this.myRemoteProcessIdleTtlInMs != that.myRemoteProcessIdleTtlInMs) {
            return false;
        }
        if (this.myVerboseProcessing != that.myVerboseProcessing) {
            return false;
        }
        if (!this.myVmOptions.equals(that.myVmOptions)) {
            return false;
        }
        return this.myArguments.equals(that.myArguments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/settings/ExternalSystemExecutionSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnv";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/settings/ExternalSystemExecutionSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

