/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.exceptions.DBException;
import org.jetbrains.dekaf.exceptions.NoTableOrViewException;
import org.jetbrains.dekaf.jdbc.BaseExceptionRecognizer;

public class CHouseExceptionRecognizer
extends BaseExceptionRecognizer {
    public static final CHouseExceptionRecognizer INSTANCE = new CHouseExceptionRecognizer();
    private static final Map<String, Class<? extends DBException>> simpleExceptionMap = new HashMap<String, Class<? extends DBException>>();

    @Override
    @Nullable
    protected DBException recognizeSpecificException(@NotNull SQLException sqle, @Nullable String statementText) {
        String errCode = sqle.getSQLState();
        Class<? extends DBException> simpleExceptionClass = simpleExceptionMap.get(errCode);
        if (simpleExceptionClass != null) {
            return this.instantiateDBException(simpleExceptionClass, sqle, statementText);
        }
        return null;
    }

    static {
        simpleExceptionMap.put("42000", NoTableOrViewException.class);
    }
}

