/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.sql;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.sql.TextPointer;

final class TextWalker
implements Cloneable {
    @NotNull
    private final String myText;
    private final int myLength;
    private int myOffset = 0;
    private int myRow = 1;
    private int myPos = 1;
    private char myChar;

    TextWalker(@NotNull String text) {
        this.myText = text;
        this.myLength = this.myText.length();
        this.myChar = this.myLength > 0 ? this.myText.charAt(0) : (char)'\u0000';
    }

    @NotNull
    public TextPointer getPointer() {
        return new TextPointer(this.myOffset, this.myRow, this.myPos);
    }

    public void setPointer(@NotNull TextPointer pointer) {
        this.myOffset = pointer.offset;
        this.myRow = pointer.row;
        this.myPos = pointer.pos;
        this.myChar = this.myLength > 0 ? this.myText.charAt(0) : (char)'\u0000';
    }

    public void next() {
        if (this.myOffset >= this.myLength) {
            throw new IllegalStateException("End of Text");
        }
        if (this.myChar == '\n') {
            ++this.myRow;
            this.myPos = 1;
        } else {
            ++this.myPos;
        }
        ++this.myOffset;
        this.myChar = this.myOffset < this.myLength ? this.myText.charAt(this.myOffset) : (char)'\u0000';
    }

    public String popRow() {
        int offset1 = this.myOffset;
        int row1 = this.myRow;
        while (row1 == this.myRow && !this.isEOT()) {
            this.next();
        }
        return this.myText.substring(offset1, this.myOffset);
    }

    @Nullable
    public Matcher skipToPattern(@NotNull Pattern pattern) {
        Matcher m = pattern.matcher(this.myText);
        boolean found = m.find(this.myOffset);
        if (found) {
            int goal = m.start();
            while (this.myOffset < goal) {
                this.next();
            }
            return m;
        }
        while (this.myOffset < this.myLength) {
            this.next();
        }
        return null;
    }

    public void skipToOffset(int newOffset) {
        if (newOffset < this.myOffset) {
            throw new IllegalArgumentException("Attempted to skip back");
        }
        if (newOffset > this.myLength) {
            throw new IllegalArgumentException("Attempted to skip out of the end of text");
        }
        int distance = newOffset - this.myOffset;
        for (int i = 1; i <= distance; ++i) {
            this.next();
        }
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    public int getLength() {
        return this.myLength;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getRow() {
        return this.myRow;
    }

    public int getPos() {
        return this.myPos;
    }

    public char getChar() {
        return this.myChar;
    }

    public char getNextChar() {
        int k = this.myOffset + 1;
        return k < this.myLength ? this.myText.charAt(k) : (char)'\u0000';
    }

    public boolean isEOT() {
        return this.myOffset >= this.myLength;
    }

    public TextWalker clone() {
        TextWalker clone = new TextWalker(this.myText);
        clone.myOffset = this.myOffset;
        clone.myRow = this.myRow;
        clone.myPos = this.myPos;
        clone.myChar = this.myChar;
        return clone;
    }
}

