/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.fix;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.core.exec.CreateContainerCmdExec;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixedCreateContainerCmdExecWithAutoRemove
extends CreateContainerCmdExec {
    private WebTarget myUpgradedResource;
    private final WebTarget myRootResource;
    private final RemoteApiVersion myBaseApiVersion;

    public FixedCreateContainerCmdExecWithAutoRemove(WebTarget rootResource, WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
        this.myRootResource = rootResource;
        this.myBaseApiVersion = dockerClientConfig.getApiVersion();
    }

    @Nullable
    private static WebTarget upgradeBaseResource(WebTarget rootResource, RemoteApiVersion version) {
        if (version != null && !version.equals((Object)RemoteApiVersion.UNKNOWN_VERSION) && version.isGreaterOrEqual(RemoteApiVersion.VERSION_1_25)) {
            return null;
        }
        return rootResource.path(new String[]{RemoteApiVersion.VERSION_1_25.asWebPathPart()});
    }

    protected WebTarget getBaseResource() {
        return this.myUpgradedResource != null ? this.myUpgradedResource : super.getBaseResource();
    }

    protected CreateContainerResponse execute(CreateContainerCmd command) {
        if (FixedCreateContainerCmdExecWithAutoRemove.needsAutoRemove(command)) {
            this.myUpgradedResource = FixedCreateContainerCmdExecWithAutoRemove.upgradeBaseResource(this.myRootResource, this.myBaseApiVersion);
        }
        return super.execute(command);
    }

    private static boolean needsAutoRemove(@NotNull CreateContainerCmd command) {
        if (command == null) {
            FixedCreateContainerCmdExecWithAutoRemove.$$$reportNull$$$0(0);
        }
        return Optional.ofNullable(command.getHostConfig()).map(HostConfig::getAutoRemove).orElse(Boolean.FALSE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/docker/agent/fix/FixedCreateContainerCmdExecWithAutoRemove", "needsAutoRemove"));
    }
}

