/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.structureView.JSStructureViewElementBase;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStructureViewElement
extends JSStructureViewElementBase {
    private final Set<String> myParentReferencedNames;
    private final boolean myEcma;

    public JSStructureViewElement(PsiElement element, boolean ecma) {
        this(Collections.singletonList(element), null, ecma);
    }

    public JSStructureViewElement(PsiElement element, ItemPresentation presentation) {
        super(element, Collections.singletonList(element), presentation);
        this.myParentReferencedNames = Collections.emptySet();
        this.myEcma = false;
    }

    public JSStructureViewElement(List<PsiElement> elements, Set<String> parentReferencedNames, boolean ecma) {
        super((PsiElement)ContainerUtil.getFirstItem(elements, null), elements, null);
        this.myParentReferencedNames = parentReferencedNames != null ? parentReferencedNames : Collections.emptySet();
        this.myEcma = ecma;
    }

    @Override
    @NotNull
    public List<StructureViewTreeElement> getOwnChildren() {
        PsiElement element = this.getValue();
        if (!element.isValid()) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                JSStructureViewElement.$$$reportNull$$$0(0);
            }
            return list;
        }
        THashSet referencedNames = new THashSet(this.myParentReferencedNames);
        JSQualifiedName ns = this.getProvidedNamespaceByElement(element);
        List<StructureViewTreeElement> list = this.collectMyElements((Set<String>)referencedNames, ns, element.getContainingFile());
        if (list == null) {
            JSStructureViewElement.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<StructureViewTreeElement> getInherited() {
        PsiElement element = this.getValue();
        if (!element.isValid()) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                JSStructureViewElement.$$$reportNull$$$0(2);
            }
            return list;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 instanceof JSFile && ((JSFile)file2).isMinified()) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                JSStructureViewElement.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<StructureViewTreeElement> elementsFromSupers = null;
        THashSet referencedNames = new THashSet(this.myParentReferencedNames);
        JSQualifiedName ns = this.getProvidedNamespaceByElement(element);
        this.collectMyElements((Set<String>)referencedNames, ns, element.getContainingFile());
        JSQualifiedName namespace = this.getProvidedNamespaceByElement(element);
        if (element instanceof JSClass) {
            elementsFromSupers = this.getInheritedForClass((JSClass)element, (Function<PsiElement, JSStructureViewElementBase>)((Function)superClass -> this.createStructureViewElement((PsiElement)superClass, (Set<String>)referencedNames)));
        } else if (!this.myEcma) {
            JSQualifiedName parent;
            String typeName = namespace != null ? namespace.getQualifiedName() : null;
            JSQualifiedName jSQualifiedName = parent = namespace != null ? namespace.getParent() : null;
            if (parent != null && "Object".equals(parent.getQualifiedName())) {
                typeName = null;
            }
            if (element instanceof JSPsiElementBase && !JSSymbolUtil.isConstructorSymbol((JSPsiElementBase)element) && (!(element instanceof JSFunction) || element instanceof JSFunctionExpression) && (!(element instanceof JSVariable) || !JSSymbolUtil.isMeaningfulLocalVariableInitializer(((JSVariable)element).getInitializerOrStub()) || ((JSVariable)element).isLocal()) || !(element instanceof JSNamedElement) && !JSSymbolUtil.isConstructorName(typeName) || element instanceof JSProperty || element instanceof JSImplicitElement && !JSStructureViewElement.isClass((JSImplicitElement)element)) {
                typeName = null;
            }
            if (typeName != null) {
                final HashSet visitedTypes = new HashSet();
                JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(element, typeName, new JSTypeEvaluateManager.NamespaceProcessor(){

                    @Override
                    public boolean process(String serializedType, VirtualFile file2) {
                        visitedTypes.add(JSTypeUtils.getTypeMatchingNamespace(serializedType));
                        return true;
                    }
                });
                GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)file2);
                MultiMap result2 = MultiMap.createSmart();
                for (String type : visitedTypes) {
                    this.addElementsFromNamespace((MultiMap<String, PsiElement>)result2, scope, type);
                }
                List<StructureViewTreeElement> superElements = this.convertPsiToElements((MultiMap<String, PsiElement>)result2, (Set<String>)referencedNames);
                for (StructureViewTreeElement superElement : superElements) {
                    ((JSStructureViewElement)superElement).setInherited();
                }
                elementsFromSupers = !superElements.isEmpty() ? superElements : null;
            }
        }
        List<StructureViewTreeElement> list = elementsFromSupers != null ? elementsFromSupers : Collections.emptyList();
        if (list == null) {
            JSStructureViewElement.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static boolean isClass(JSImplicitElement element) {
        JSImplicitElement.Type type = element.getType();
        return type == JSImplicitElement.Type.Class || type == JSImplicitElement.Type.Interface;
    }

    @Nullable
    protected JSQualifiedName getProvidedNamespaceByElement(PsiElement element) {
        JSNamespace jsNamespace;
        if (element instanceof JSElementBase && (jsNamespace = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)element, true, null)) != null) {
            return jsNamespace.getQualifiedName();
        }
        return null;
    }

    protected JSStructureViewElement createStructureViewElement(PsiElement element, Set<String> parentReferencedNames) {
        return this.createStructureViewElement(Collections.singletonList(element), parentReferencedNames);
    }

    protected JSStructureViewElement createStructureViewElement(List<PsiElement> elements, Set<String> parentReferencedNames) {
        return new JSStructureViewElement(elements, parentReferencedNames, this.myEcma);
    }

    protected List<StructureViewTreeElement> collectMyElements(Set<String> referencedNames, JSQualifiedName ns, PsiFile contextFile) {
        return this.doCollectMyElements(referencedNames, ns, contextFile, this.getElement(), this.myElements, false);
    }

    protected List<StructureViewTreeElement> doCollectMyElements(Set<String> referencedNames, JSQualifiedName ns, PsiFile contextFile, PsiElement mainElement, List<PsiElement> mainElements, boolean oneElementOnly) {
        boolean shouldFindNsInDepth;
        boolean myElementIsFile = mainElement instanceof PsiFile;
        boolean bl = shouldFindNsInDepth = myElementIsFile && mainElement.getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4 || mainElement instanceof JSImplicitElement;
        if (mainElement instanceof JSDefinitionExpression && "prototype".equals(((JSDefinitionExpression)mainElement).getName())) {
            return Collections.emptyList();
        }
        HashSet<PsiFile> visitedFiles = new HashSet<PsiFile>();
        visitedFiles.add(contextFile);
        MultiMap children = MultiMap.createSmart();
        Function childrenProvider = el -> JSStructureViewElement.gatherChildElements(el, visitedFiles);
        JSStructureViewElementBase.ChildElementProcessor childProcessor = (el, name) -> this.addChildElement(el, name, ns, myElementIsFile, shouldFindNsInDepth, (MultiMap<String, PsiElement>)children);
        if (this.fillChildrenElement(mainElements, (MultiMap<String, PsiElement>)children, (Function<PsiElement, Collection<? extends PsiElement>>)childrenProvider, childProcessor, oneElementOnly)) {
            return this.convertPsiToElements((MultiMap<String, PsiElement>)children, referencedNames);
        }
        if (ns != null && !oneElementOnly) {
            GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)contextFile);
            this.addElementsFromNamespace((MultiMap<String, PsiElement>)children, scope, ns.getQualifiedName());
        }
        referencedNames.addAll(children.keySet());
        return this.convertPsiToElements((MultiMap<String, PsiElement>)children, referencedNames);
    }

    private boolean addChildElement(PsiElement element, String name, JSQualifiedName ns, boolean myElementIsFile, boolean shouldFindNsInDepth, MultiMap<String, PsiElement> children) {
        if (JSStructureViewElement.isElementInMyNamespace(element, ns, myElementIsFile, shouldFindNsInDepth)) {
            this.addElement(children, element, name);
            return true;
        }
        if (element instanceof JSPsiElementBase) {
            String childName;
            JSQualifiedName namespace = ((JSPsiElementBase)element).getJSNamespace().getQualifiedName();
            JSQualifiedName childNs = JSStructureViewElement.findFirstLevelChildNs(ns, namespace);
            childNs = childNs == null && JSStructureViewElement.shouldAddNamespaceFromDefinition(element, namespace, this.myParentReferencedNames) ? namespace : childNs;
            String string = childName = childNs != null ? childNs.getName() : null;
            if (childNs != null && this.myParentReferencedNames.contains(name) && Comparing.equal((Object)childNs, (Object)namespace)) {
                return true;
            }
            if (childNs != null && !childName.equals("Window")) {
                children.putValue((Object)childName, (Object)new JSStructureImplicitNamespace(childNs, (JSPsiElementBase)element));
                return true;
            }
        }
        return false;
    }

    private static boolean shouldAddNamespaceFromDefinition(PsiElement element, JSQualifiedName namespace, Set<String> parentReferencedNames) {
        return namespace != null && element instanceof JSDefinitionExpression && ((JSDefinitionExpression)element).getInitializerOrStub() instanceof JSFunctionItem && !parentReferencedNames.contains(namespace.getName());
    }

    private void addElementsFromNamespace(MultiMap<String, PsiElement> children, GlobalSearchScope scope, String namespace) {
        boolean isObject = "Object".equals(namespace);
        for (JSPsiElementBase namedElement : JSClassResolver.getInstance().findNamespaceMembers(namespace, scope, true)) {
            String name;
            if (isObject && namedElement.getJSContext() == JSContext.STATIC || (name = this.getName((PsiElement)namedElement, children.size())) == null) continue;
            this.addElement(children, (PsiElement)namedElement, name);
        }
    }

    @Override
    protected String getName(@NotNull PsiElement element, int count) {
        if (element == null) {
            JSStructureViewElement.$$$reportNull$$$0(5);
        }
        if (element instanceof JSPackageStatement) {
            return null;
        }
        if (element instanceof JSDefinitionExpression) {
            PsiFile file2;
            JSFunction function;
            JSClass clazz;
            JSDefinitionExpression definition = (JSDefinitionExpression)element;
            if ("prototype".equals(definition.getName()) && definition.getJSContext() != JSContext.INSTANCE) {
                return null;
            }
            if (this.myEcma && (clazz = (JSClass)PsiTreeUtil.getContextOfType((PsiElement)(function = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)definition, (Class[])new Class[]{JSFunction.class})), (Class[])new Class[]{JSClass.class})) != null) {
                return null;
            }
            if ("exports".equals(definition.getName()) && (file2 = definition.getContainingFile()) instanceof JSFile && ((JSFile)file2).isCommonJSModule()) {
                return null;
            }
            if (definition.getJSNamespace().getQualifiedName() == null && !(definition.getInitializerOrStub() instanceof JSFunctionItem) && !this.hasStructureElements(element)) {
                return null;
            }
        }
        return super.getName(element, count);
    }

    @Override
    protected boolean hasStructureElements(PsiElement element) {
        List<StructureViewTreeElement> elements = this.doCollectMyElements((Set<String>)new THashSet(), this.getProvidedNamespaceByElement(element), element.getContainingFile(), element, Collections.singletonList(element), true);
        return !elements.isEmpty();
    }

    private static Collection<? extends PsiElement> gatherChildElements(PsiElement element, Set<PsiFile> visitedFiles) {
        JSExpression value;
        if (element instanceof JSStructureImplicitNamespace) {
            return Collections.singleton(element.getParent());
        }
        if (element instanceof JSAssignmentExpression) {
            SmartList result2 = new SmartList();
            PsiElement value2 = element;
            while (value2 instanceof JSAssignmentExpression) {
                PsiElement definition = ((JSStubElementImpl)value2).getStubOrPsiChild((IStubElementType)JSStubElementTypes.DEFINITION_EXPRESSION);
                ContainerUtil.addIfNotNull((Collection)result2, (Object)definition);
                value2 = ((JSStubElementImpl)value2).getStubOrPsiChild((IStubElementType)JSStubElementTypes.ASSIGNMENT_EXPRESSION);
            }
            return result2;
        }
        if (element instanceof JSDefinitionExpression && (value = ((JSDefinitionExpression)element).getInitializerOrStub()) != null) {
            return Collections.singleton(value);
        }
        if (element instanceof JSIncludeDirective) {
            PsiFile file2 = ((JSIncludeDirective)element).resolveFile();
            element = file2 != null && !visitedFiles.contains(file2) ? file2 : element;
            visitedFiles.add(file2);
        }
        return JSStructureViewElement.getPsiOrStubChildren(element);
    }

    private List<StructureViewTreeElement> convertPsiToElements(MultiMap<String, PsiElement> children, final Set<String> parentReferencedNames) {
        return JBIterable.from((Iterable)children.entrySet()).flatMap((Function)new Function<Map.Entry<String, Collection<PsiElement>>, List<StructureViewTreeElement>>(){

            public List<StructureViewTreeElement> fun(Map.Entry<String, Collection<PsiElement>> entry) {
                List value = (List)entry.getValue();
                SmartList staticElements = new SmartList();
                boolean hasInstanceMember = false;
                for (PsiElement element : value) {
                    if (!(element instanceof JSPsiElementBase)) continue;
                    JSContext context = ((JSPsiElementBase)element).getJSContext();
                    if (context == JSContext.STATIC) {
                        staticElements.add((Object)element);
                        continue;
                    }
                    if (context != JSContext.INSTANCE) continue;
                    hasInstanceMember = true;
                }
                if (!staticElements.isEmpty() && hasInstanceMember) {
                    SmartList otherElements = new SmartList();
                    Iterator staticElementsIterator = staticElements.iterator();
                    PsiElement staticElement = (PsiElement)staticElementsIterator.next();
                    for (PsiElement element : value) {
                        if (staticElement == element) {
                            staticElement = staticElementsIterator.hasNext() ? (PsiElement)staticElementsIterator.next() : null;
                            continue;
                        }
                        otherElements.add((Object)element);
                    }
                    return ContainerUtil.newArrayList((Object[])new StructureViewTreeElement[]{this.sortAndCreate((List<PsiElement>)staticElements), this.sortAndCreate((List<PsiElement>)otherElements)});
                }
                return Collections.singletonList(this.sortAndCreate(value));
            }

            private StructureViewTreeElement sortAndCreate(List<PsiElement> value) {
                JSStructureViewElement.this.sortChildrenByImplicitElements(value);
                return JSStructureViewElement.this.createStructureViewElement(value, (Set<String>)parentReferencedNames);
            }
        }).toList();
    }

    private static boolean isElementInMyNamespace(PsiElement element, JSQualifiedName myNs, boolean myElementIsFile, boolean shouldFindNsInDepth) {
        if (!(element instanceof JSElementBase)) {
            return true;
        }
        JSQualifiedName namespace = ((JSElementBase)element).getJSNamespace().getQualifiedName();
        if (namespace == null) {
            return true;
        }
        if (namespace.equals(myNs)) {
            return true;
        }
        String name = namespace.getName();
        if (myElementIsFile) {
            if (Comparing.equal((Object)namespace.getParent(), (Object)myNs) && "Window".equals(name)) {
                return true;
            }
            if (!shouldFindNsInDepth && element instanceof JSClass && JSStructureViewElement.findFirstLevelChildNs(myNs, namespace) != null) {
                return true;
            }
        } else if (!StringUtil.isEmpty((String)name) && myNs != null && name.equals(myNs.getName()) && Comparing.equal((Object)JSStructureViewElement.getParentSkippingWindow(namespace), (Object)JSStructureViewElement.getParentSkippingWindow(myNs))) {
            return true;
        }
        return false;
    }

    private static JSQualifiedName getParentSkippingWindow(@Nullable JSQualifiedName namespace) {
        JSQualifiedName parent;
        JSQualifiedName jSQualifiedName = parent = namespace != null ? namespace.getParent() : null;
        if (parent != null && "Window".equals(parent.getName())) {
            return parent.getParent();
        }
        return parent;
    }

    private static JSQualifiedName findFirstLevelChildNs(JSQualifiedName parent, JSQualifiedName namespace) {
        while (namespace != null) {
            JSQualifiedName parentNs = namespace.getParent();
            if (Comparing.equal((Object)parentNs, (Object)parent)) {
                return namespace;
            }
            namespace = parentNs;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/structureView/JSStructureViewElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnChildren";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInherited";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/structureView/JSStructureViewElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSStructureImplicitNamespace
    extends JSImplicitElementImpl {
        private JSStructureImplicitNamespace(JSQualifiedName parent, JSPsiElementBase element) {
            super(new JSImplicitElementImpl.Builder(parent, (PsiElement)element).setType(JSStructureImplicitNamespace.isClassMemberDefinition((PsiElement)element) ? JSImplicitElement.Type.Class : JSImplicitElement.Type.Namespace));
        }

        private static boolean isClassMemberDefinition(PsiElement element) {
            return element instanceof JSDefinitionExpression && ((JSDefinitionExpression)element).getJSContext() == JSContext.INSTANCE;
        }
    }
}

