/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedItem;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.common.AbstractTimephasedWorkNormaliser;
import net.sf.mpxj.common.DateHelper;

public abstract class MPPAbstractTimephasedWorkNormaliser
extends AbstractTimephasedWorkNormaliser {
    private static final double EQUALITY_DELTA = 0.1;

    @Override
    public void normalise(ProjectCalendar projectCalendar, LinkedList<TimephasedWork> linkedList) {
        if (!linkedList.isEmpty()) {
            this.splitDays(projectCalendar, linkedList);
            this.mergeSameDay(projectCalendar, linkedList);
            this.mergeSameWork(linkedList);
            this.convertToHours(linkedList);
        }
    }

    private void splitDays(ProjectCalendar projectCalendar, LinkedList<TimephasedWork> linkedList) {
        LinkedList<TimephasedWork> linkedList2 = new LinkedList<TimephasedWork>();
        boolean bl = false;
        Calendar calendar = Calendar.getInstance();
        block0: for (TimephasedWork timephasedWork : linkedList) {
            if (bl) {
                calendar.setTime(timephasedWork.getStart());
                calendar.add(6, 1);
                timephasedWork.setStart(calendar.getTime());
                bl = false;
            }
            while (timephasedWork != null) {
                TimephasedWork[] timephasedWorkArray;
                Date date = DateHelper.getDayStartDate(timephasedWork.getStart());
                Date date2 = DateHelper.getDayStartDate(timephasedWork.getFinish());
                if (timephasedWork.getFinish().getTime() == date2.getTime()) {
                    calendar.setTime(date2);
                    calendar.add(6, -1);
                    date2 = calendar.getTime();
                }
                if (date.getTime() == date2.getTime()) {
                    timephasedWorkArray = (TimephasedWork[])timephasedWork.getTotalAmount();
                    Duration duration = this.getAssignmentWork(projectCalendar, timephasedWork);
                    if (timephasedWorkArray.getDuration() - duration.getDuration() > 0.1) {
                        timephasedWork.setTotalAmount(duration);
                        linkedList2.add(timephasedWork);
                        Duration duration2 = Duration.getInstance(timephasedWorkArray.getDuration() - duration.getDuration(), TimeUnit.MINUTES);
                        calendar.setTime(date2);
                        calendar.add(6, 1);
                        Date date3 = calendar.getTime();
                        calendar.add(6, 1);
                        Date date4 = calendar.getTime();
                        TimephasedWork timephasedWork2 = new TimephasedWork();
                        timephasedWork2.setStart(date3);
                        timephasedWork2.setFinish(date4);
                        timephasedWork2.setTotalAmount(duration2);
                        linkedList2.add(timephasedWork2);
                        bl = true;
                        continue block0;
                    }
                    linkedList2.add(timephasedWork);
                    continue block0;
                }
                timephasedWorkArray = this.splitFirstDay(projectCalendar, timephasedWork);
                if (timephasedWorkArray[0] != null) {
                    linkedList2.add(timephasedWorkArray[0]);
                }
                if (timephasedWork.equals(timephasedWorkArray[1])) continue block0;
                timephasedWork = timephasedWorkArray[1];
            }
        }
        linkedList.clear();
        linkedList.addAll(linkedList2);
    }

    private TimephasedWork[] splitFirstDay(ProjectCalendar projectCalendar, TimephasedWork timephasedWork) {
        TimephasedWork[] timephasedWorkArray = new TimephasedWork[2];
        Date date = timephasedWork.getStart();
        Date date2 = timephasedWork.getFinish();
        Duration duration = projectCalendar.getWork(date, date2, TimeUnit.MINUTES);
        Duration duration2 = (Duration)timephasedWork.getTotalAmount();
        if (duration.getDuration() != 0.0) {
            double d;
            Duration duration3;
            Date date3;
            Object object;
            Date date4;
            if (projectCalendar.isWorkingDate(date)) {
                Duration duration4;
                date4 = date;
                object = projectCalendar.getFinishTime(date4);
                date3 = DateHelper.setTime(date4, (Date)object);
                duration3 = projectCalendar.getWork(date4, date3, TimeUnit.MINUTES);
                Duration duration5 = projectCalendar.getWork(date4, TimeUnit.MINUTES);
                Duration duration6 = (Duration)timephasedWork.getAmountPerDay();
                if (duration3.durationComponentEquals(duration5)) {
                    if (duration3.durationComponentEquals(duration6)) {
                        duration4 = duration6;
                        d = duration4.getDuration();
                    } else {
                        d = duration6.getDuration();
                        d *= duration3.getDuration();
                        duration4 = Duration.getInstance(d /= 480.0, TimeUnit.MINUTES);
                    }
                } else {
                    d = duration6.getDuration();
                    d *= duration3.getDuration();
                    duration4 = Duration.getInstance(d /= 480.0, TimeUnit.MINUTES);
                }
                TimephasedWork timephasedWork2 = new TimephasedWork();
                timephasedWork2.setStart(date4);
                timephasedWork2.setFinish(date3);
                timephasedWork2.setTotalAmount(duration4);
                timephasedWorkArray[0] = timephasedWork2;
            } else {
                date3 = date;
                d = 0.0;
            }
            date4 = projectCalendar.getNextWorkStart(date3);
            date3 = date2;
            if (date4.getTime() > date3.getTime()) {
                object = null;
            } else {
                d = duration2.getDuration() - d;
                duration3 = Duration.getInstance(d, TimeUnit.MINUTES);
                object = new TimephasedWork();
                ((TimephasedItem)object).setStart(date4);
                ((TimephasedItem)object).setFinish(date3);
                ((TimephasedItem)object).setTotalAmount(duration3);
                ((TimephasedItem)object).setAmountPerDay(timephasedWork.getAmountPerDay());
            }
            timephasedWorkArray[1] = object;
        }
        return timephasedWorkArray;
    }

    protected abstract void mergeSameDay(ProjectCalendar var1, LinkedList<TimephasedWork> var2);

    private Duration getAssignmentWork(ProjectCalendar projectCalendar, TimephasedWork timephasedWork) {
        Date date;
        Date date2 = date = timephasedWork.getStart();
        Date date3 = projectCalendar.getFinishTime(date2);
        Date date4 = DateHelper.setTime(date2, date3);
        Duration duration = projectCalendar.getWork(date2, date4, TimeUnit.MINUTES);
        Duration duration2 = (Duration)timephasedWork.getAmountPerDay();
        double d = duration2.getDuration();
        d *= duration.getDuration();
        Duration duration3 = Duration.getInstance(d /= 480.0, TimeUnit.MINUTES);
        return duration3;
    }
}

