/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import com.digitprop.tonic.TonicUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class TabbedPaneUI
extends BasicTabbedPaneUI
implements SwingConstants {
    protected JTabbedPane tabPane;
    protected Color highlight;
    protected Color borderColor;
    private Color selectedColor;
    private boolean drawThickBorder = false;
    protected int textIconGap;
    protected int tabRunOverlay;
    protected Insets tabInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets contentBorderInsets;
    protected KeyStroke upKey;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected int[] tabRuns = new int[10];
    protected int runCount = 0;
    protected int selectedRun = -1;
    protected Rectangle[] rects = new Rectangle[0];
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected ChangeListener tabChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected FocusListener focusListener;
    private ContainerListener containerListener;
    private Insets currentPadInsets = new Insets(0, 0, 0, 0);
    private Insets currentTabAreaInsets = new Insets(0, 0, 0, 0);
    private Component visibleComponent;
    private Vector htmlViews;
    private Hashtable mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    private ScrollableTabSupport tabScroller;
    protected transient Rectangle calcRect = new Rectangle(0, 0, 0, 0);
    private int tabCount;
    private int[] xCropLen;
    private int[] yCropLen;
    private static final int CROP_SEGMENT = 12;

    public TabbedPaneUI() {
        int[] nArray = new int[8];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 2;
        this.xCropLen = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 3;
        nArray2[2] = 3;
        nArray2[3] = 6;
        nArray2[4] = 6;
        nArray2[5] = 9;
        nArray2[6] = 9;
        nArray2[7] = 12;
        this.yCropLen = nArray2;
        this.drawThickBorder = UIManager.getBoolean("TabbedPane.thickBorders");
    }

    public static ComponentUI createUI(JComponent c) {
        return new TabbedPaneUI();
    }

    public void installUI(JComponent c) {
        this.tabPane = (JTabbedPane)c;
        c.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        c.setLayout(null);
        this.tabPane = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout();
        }
        return new TabbedPaneLayout();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
            this.tabPane.add(this.tabScroller.scrollForwardButton);
            this.tabPane.add(this.tabScroller.scrollBackwardButton);
        }
    }

    protected void uninstallComponents() {
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabScroller = null;
        }
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.highlight = UIManager.getColor("TabbedPane.light");
        this.lightHighlight = UIManager.getColor("TabbedPane.highlight");
        this.shadow = UIManager.getColor("TabbedPane.shadow");
        this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
        this.focus = UIManager.getColor("TabbedPane.focus");
        this.selectedColor = UIManager.getColor("TabbedPane.selected");
        this.borderColor = UIManager.getColor("Button.borderColor");
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
        this.selectedTabPadInsets = UIManager.getInsets("TabbedPane.selectedTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        this.contentBorderInsets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        this.tabRunOverlay = UIManager.getInt("TabbedPane.tabRunOverlay");
    }

    protected void uninstallDefaults() {
        this.highlight = null;
        this.lightHighlight = null;
        this.shadow = null;
        this.darkShadow = null;
        this.focus = null;
        this.tabInsets = null;
        this.selectedTabPadInsets = null;
        this.tabAreaInsets = null;
        this.contentBorderInsets = null;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.addMouseListener(this.mouseListener);
            } else {
                this.tabPane.addMouseListener(this.mouseListener);
            }
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        if ((this.containerListener = new ContainerHandler()) != null) {
            this.tabPane.addContainerListener(this.containerListener);
            if (this.tabPane.getTabCount() > 0) {
                this.htmlViews = this.createHTMLVector();
            }
        }
    }

    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.removeMouseListener(this.mouseListener);
            } else {
                this.tabPane.removeMouseListener(this.mouseListener);
            }
            this.mouseListener = null;
        }
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.containerListener != null) {
            this.tabPane.removeContainerListener(this.containerListener);
            this.containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
        InputMap km = this.getMyInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, km);
        km = this.getMyInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, km);
        ActionMap am = this.getMyActionMap();
        SwingUtilities.replaceUIActionMap(this.tabPane, am);
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.scrollForwardButton.setAction(am.get("scrollTabsForwardAction"));
            this.tabScroller.scrollBackwardButton.setAction(am.get("scrollTabsBackwardAction"));
        }
    }

    InputMap getMyInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("TabbedPane.ancestorInputMap");
        }
        if (condition == 0) {
            return (InputMap)UIManager.get("TabbedPane.focusInputMap");
        }
        return null;
    }

    ActionMap getMyActionMap() {
        ActionMap map = (ActionMap)UIManager.get("TabbedPane.actionMap");
        if (map == null && (map = this.createMyActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("TabbedPane.actionMap", map);
        }
        return map;
    }

    ActionMap createMyActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("navigateNext", new NextAction());
        map.put("navigatePrevious", new PreviousAction());
        map.put("navigateRight", new RightAction());
        map.put("navigateLeft", new LeftAction());
        map.put("navigateUp", new UpAction());
        map.put("navigateDown", new DownAction());
        map.put("navigatePageUp", new PageUpAction());
        map.put("navigatePageDown", new PageDownAction());
        map.put("requestFocus", new RequestFocusAction());
        map.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        map.put("setSelectedIndex", new SetSelectedIndexAction());
        map.put("scrollTabsForwardAction", new ScrollTabsForwardAction());
        map.put("scrollTabsBackwardAction", new ScrollTabsBackwardAction());
        return map;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
    }

    private void updateMnemonics() {
        this.resetMnemonics();
        int counter = this.tabPane.getTabCount() - 1;
        while (counter >= 0) {
            int mnemonic = this.tabPane.getMnemonicAt(counter);
            if (mnemonic > 0) {
                this.addMnemonic(counter, mnemonic);
            }
            --counter;
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int index, int mnemonic) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(new Integer(mnemonic), new Integer(index));
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new InputMapUIResource();
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 1));
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, this.mnemonicInputMap);
    }

    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    public void paint(Graphics g, JComponent c) {
        int tc = this.tabPane.getTabCount();
        if (this.tabCount != tc) {
            this.tabCount = tc;
            this.updateMnemonics();
        }
        int selectedIndex = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(g, tabPlacement, selectedIndex);
        }
        this.paintContentBorder(g, tabPlacement, selectedIndex);
    }

    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        int tabCount = this.tabPane.getTabCount();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle clipRect = g.getClipBounds();
        int i = this.runCount - 1;
        while (i >= 0) {
            int start = this.tabRuns[i];
            int next = this.tabRuns[i == this.runCount - 1 ? 0 : i + 1];
            int end = next != 0 ? next - 1 : tabCount - 1;
            int j = start;
            while (j <= end) {
                if (this.rects[j].intersects(clipRect)) {
                    this.paintTab(g, tabPlacement, this.rects, j, iconRect, textRect);
                }
                ++j;
            }
            --i;
        }
        if (selectedIndex >= 0 && this.getRunForTab(tabCount, selectedIndex) == 0 && this.rects[selectedIndex].intersects(clipRect)) {
            this.paintTab(g, tabPlacement, this.rects, selectedIndex, iconRect, textRect);
        }
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        boolean isSelected = this.tabPane.getSelectedIndex() == tabIndex;
        Rectangle r = rects[tabIndex];
        this.paintTabBackground(g, tabPlacement, tabIndex, r.x, r.y, r.width + 2, r.height + 2, isSelected);
        g.setColor(UIManager.getColor("Button.borderColor"));
        if (tabPlacement != 4) {
            g.drawLine(r.x, r.y + r.height + 1, r.x, r.y);
            if (isSelected && this.drawThickBorder) {
                g.drawLine(r.x + 1, r.y + r.height + 1, r.x + 1, r.y);
            }
        }
        if (tabPlacement != 3) {
            g.drawLine(r.x, r.y, r.x + r.width, r.y);
            if (isSelected && this.drawThickBorder) {
                g.drawLine(r.x, r.y + 1, r.x + r.width, r.y + 1);
            }
        }
        if (tabPlacement != 2) {
            g.drawLine(r.x + r.width, r.y, r.x + r.width, r.y + r.height + 1);
            if (isSelected && this.drawThickBorder) {
                g.drawLine(r.x + r.width - 1, r.y, r.x + r.width - 1, r.y + r.height + 1);
            }
        }
        if (tabPlacement != 1) {
            g.drawLine(r.x, r.y + r.height, r.x + r.width, r.y + r.height);
            if (isSelected && this.drawThickBorder) {
                g.drawLine(r.x, r.y + r.height - 1, r.x + r.width, r.y + r.height - 1);
            }
        }
        String title = this.tabPane.getTitleAt(tabIndex);
        Font font = UIManager.getFont("TabbedPane.selectedFont");
        if (!isSelected || font == null) {
            font = this.tabPane.getFont();
        }
        FontMetrics metrics = g.getFontMetrics(font);
        Icon icon = this.getIconForTab(tabIndex);
        this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, r, iconRect, textRect, isSelected);
        this.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        this.paintFocusIndicator(g, tabPlacement, rects, tabIndex, iconRect, textRect, isSelected);
    }

    private Polygon createCroppedTabClip(int tabPlacement, Rectangle tabRect, int cropline) {
        int rlen = 0;
        int start = 0;
        int end = 0;
        int ostart = 0;
        switch (tabPlacement) {
            case 2: 
            case 4: {
                rlen = tabRect.width;
                start = tabRect.x;
                end = tabRect.x + tabRect.width;
                ostart = tabRect.y;
                break;
            }
            default: {
                rlen = tabRect.height;
                start = tabRect.y;
                end = tabRect.y + tabRect.height;
                ostart = tabRect.x;
            }
        }
        int rcnt = rlen / 12;
        if (rlen % 12 > 0) {
            ++rcnt;
        }
        int npts = 2 + rcnt * 8;
        int[] xp = new int[npts];
        int[] yp = new int[npts];
        int pcnt = 0;
        xp[pcnt] = ostart;
        yp[pcnt++] = end;
        xp[pcnt] = ostart;
        yp[pcnt++] = start;
        int i = 0;
        while (i < rcnt) {
            int j = 0;
            while (j < this.xCropLen.length) {
                xp[pcnt] = cropline - this.xCropLen[j];
                yp[pcnt] = start + i * 12 + this.yCropLen[j];
                if (yp[pcnt] >= end) {
                    yp[pcnt] = end;
                    ++pcnt;
                    break;
                }
                ++pcnt;
                ++j;
            }
            ++i;
        }
        if (tabPlacement == 1 || tabPlacement == 3) {
            return new Polygon(xp, yp, pcnt);
        }
        return new Polygon(yp, xp, pcnt);
    }

    private void paintCroppedTabEdge(Graphics g, int tabPlacement, int tabIndex, boolean isSelected, int x, int y) {
        switch (tabPlacement) {
            case 2: 
            case 4: {
                int xx = x;
                g.setColor(this.shadow);
                while (xx <= x + this.rects[tabIndex].width) {
                    int i = 0;
                    while (i < this.xCropLen.length) {
                        g.drawLine(xx + this.yCropLen[i], y - this.xCropLen[i], xx + this.yCropLen[i + 1] - 1, y - this.xCropLen[i + 1]);
                        i += 2;
                    }
                    xx += 12;
                }
                break;
            }
            default: {
                int yy = y;
                g.setColor(this.shadow);
                while (yy <= y + this.rects[tabIndex].height) {
                    int i = 0;
                    while (i < this.xCropLen.length) {
                        g.drawLine(x - this.xCropLen[i], yy + this.yCropLen[i], x - this.xCropLen[i + 1], yy + this.yCropLen[i + 1] - 1);
                        i += 2;
                    }
                    yy += 12;
                }
                break block0;
            }
        }
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        if (icon != null) {
            icon.paintIcon(this.tabPane, g, iconRect.x, iconRect.y);
        }
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                g.setColor(this.tabPane.getForegroundAt(tabIndex));
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = 0;
        return nudge;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = 0;
        return nudge;
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Rectangle tabRect = rects[tabIndex];
        if (this.tabPane.hasFocus() && isSelected) {
            int h;
            int w;
            int y;
            int x;
            g.setColor(this.focus);
            switch (tabPlacement) {
                case 2: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 3;
                    w = tabRect.width - 5;
                    h = tabRect.height - 6;
                    break;
                }
                case 4: {
                    x = tabRect.x + 2;
                    y = tabRect.y + 3;
                    w = tabRect.width - 5;
                    h = tabRect.height - 6;
                    break;
                }
                case 3: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 2;
                    w = tabRect.width - 6;
                    h = tabRect.height - 5;
                    break;
                }
                default: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 3;
                    w = tabRect.width - 6;
                    h = tabRect.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
        }
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(this.lightHighlight);
        switch (tabPlacement) {
            case 2: {
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.drawLine(x, y + 2, x, y + h - 3);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + 2, y, x + w - 1, y);
                g.setColor(this.shadow);
                g.drawLine(x + 2, y + h - 2, x + w - 1, y + h - 2);
                g.setColor(this.darkShadow);
                g.drawLine(x + 2, y + h - 1, x + w - 1, y + h - 1);
                break;
            }
            case 4: {
                g.drawLine(x, y, x + w - 3, y);
                g.setColor(this.shadow);
                g.drawLine(x, y + h - 2, x + w - 3, y + h - 2);
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 3);
                g.setColor(this.darkShadow);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
                g.drawLine(x, y + h - 1, x + w - 3, y + h - 1);
                break;
            }
            case 3: {
                g.drawLine(x, y, x, y + h - 3);
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.setColor(this.shadow);
                g.drawLine(x + 2, y + h - 2, x + w - 3, y + h - 2);
                g.drawLine(x + w - 2, y, x + w - 2, y + h - 3);
                g.setColor(this.darkShadow);
                g.drawLine(x + 2, y + h - 1, x + w - 3, y + h - 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 3);
            }
        }
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(!isSelected || this.selectedColor == null ? this.tabPane.getBackgroundAt(tabIndex) : this.selectedColor);
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x + 1, y + 1, w - 2, h - 3);
                break;
            }
            case 4: {
                g.fillRect(x, y + 1, w - 2, h - 3);
                break;
            }
            case 3: {
                g.fillRect(x + 1, y, w - 3, h - 1);
                break;
            }
            default: {
                g.fillRect(x + 1, y + 1, w - 3, h - 1);
            }
        }
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        if (this.selectedColor == null) {
            g.setColor(this.tabPane.getBackground());
        } else {
            g.setColor(this.selectedColor);
        }
        g.fillRect(x, y, w, h);
        this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.borderColor);
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x, y, x + w - 2, y);
            if (this.drawThickBorder) {
                g.drawLine(x, y + 1, x + w - 2, y + 1);
            }
        } else {
            int delta = this.drawThickBorder ? 1 : 0;
            g.drawLine(x, y, selRect.x + delta, y);
            if (this.drawThickBorder) {
                g.drawLine(x, y + 1, selRect.x + 1, y + 1);
            }
            if (selRect.x + selRect.width < x + w - 2) {
                g.drawLine(selRect.x + selRect.width - delta, y, x + w - 2, y);
                if (this.drawThickBorder) {
                    g.drawLine(selRect.x + selRect.width - 1, y + 1, x + w - 2, y + 1);
                }
            } else {
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, y, x + w - 2, y);
                if (this.drawThickBorder) {
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                }
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.borderColor);
        if (tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x, y, x, y + h - 2);
            if (this.drawThickBorder) {
                g.drawLine(x + 1, y, x + 1, y + h - 2);
            }
        } else {
            g.drawLine(x, y, x, selRect.y);
            if (this.drawThickBorder) {
                g.drawLine(x + 1, y, x + 1, selRect.y);
            }
            if (selRect.y + selRect.height < y + h - 2) {
                g.drawLine(x, selRect.y + selRect.height, x, y + h - 2);
                if (this.drawThickBorder) {
                    g.drawLine(x + 1, selRect.y + selRect.height, x + 1, y + h - 2);
                }
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.borderColor);
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            if (this.drawThickBorder) {
                g.drawLine(x, y + h - 2, x + w - 1, y + h - 2);
            }
        } else {
            g.drawLine(x, y + h - 1, selRect.x, y + h - 1);
            if (this.drawThickBorder) {
                g.drawLine(x, y + h - 2, selRect.x, y + h - 2);
            }
            if (selRect.x + selRect.width < x + w - 2) {
                g.setColor(this.borderColor);
                g.setColor(this.darkShadow);
                g.drawLine(selRect.x + selRect.width, y + h - 1, x + w - 1, y + h - 1);
                if (this.drawThickBorder) {
                    g.drawLine(selRect.x + selRect.width, y + h - 2, x + w - 1, y + h - 2);
                }
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.borderColor);
        if (tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            if (this.drawThickBorder) {
                g.drawLine(x + w - 2, y, x + w - 2, y + h - 1);
            }
        } else {
            g.drawLine(x + w - 1, y, x + w - 1, selRect.y);
            if (this.drawThickBorder) {
                g.drawLine(x + w - 2, y, x + w - 2, selRect.y);
            }
            if (selRect.y + selRect.height < y + h - 2) {
                g.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h - 2);
                if (this.drawThickBorder) {
                    g.drawLine(x + w - 2, selRect.y + selRect.height, x + w - 2, y + h - 2);
                }
            }
        }
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            TabbedPaneLayout layout = (TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        this.ensureCurrentLayout();
        Rectangle tabRect = new Rectangle();
        return this.getTabBounds(i, tabRect);
    }

    public int getTabRunCount(JTabbedPane pane) {
        this.ensureCurrentLayout();
        return this.runCount;
    }

    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        this.ensureCurrentLayout();
        Point p = new Point(x, y);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(x, y, p);
        }
        int tabCount = this.tabPane.getTabCount();
        int i = 0;
        while (i < tabCount) {
            if (this.rects[i].contains(p.x, p.y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        dest.width = this.rects[tabIndex].width;
        dest.height = this.rects[tabIndex].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point vpp = this.tabScroller.viewport.getLocation();
            Point viewp = this.tabScroller.viewport.getViewPosition();
            dest.x = this.rects[tabIndex].x - vpp.x - viewp.x;
            dest.y = this.rects[tabIndex].y - vpp.y - viewp.y;
        } else {
            dest.x = this.rects[tabIndex].x;
            dest.y = this.rects[tabIndex].y;
        }
        return dest;
    }

    private int getTabAtLocation(int x, int y) {
        this.ensureCurrentLayout();
        int tabCount = this.tabPane.getTabCount();
        int i = 0;
        while (i < tabCount) {
            if (this.rects[i].contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getClosestTab(int x, int y) {
        int tabCount;
        int min = 0;
        int max = tabCount = Math.min(this.rects.length, this.tabPane.getTabCount());
        int tabPlacement = this.tabPane.getTabPlacement();
        boolean useX = tabPlacement == 1 || tabPlacement == 3;
        int want = useX ? x : y;
        while (min != max) {
            int maxLoc;
            int minLoc;
            int current = (max + min) / 2;
            if (useX) {
                minLoc = this.rects[current].x;
                maxLoc = minLoc + this.rects[current].width;
            } else {
                minLoc = this.rects[current].y;
                maxLoc = minLoc + this.rects[current].height;
            }
            if (want < minLoc) {
                max = current;
                if (min != max) continue;
                return Math.max(0, current - 1);
            }
            if (want >= maxLoc) {
                min = current;
                if (max - min > 1) continue;
                return Math.max(current + 1, tabCount - 1);
            }
            return current;
        }
        return min;
    }

    private Point translatePointToTabPanel(int srcx, int srcy, Point dest) {
        Point vpp = this.tabScroller.viewport.getLocation();
        Point viewp = this.tabScroller.viewport.getViewPosition();
        dest.x = srcx + vpp.x + viewp.x;
        dest.y = srcy + vpp.y + viewp.y;
        return dest;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent == component) {
            return;
        }
        if (this.visibleComponent != null && this.visibleComponent.getParent() == this.tabPane) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected void assureRectsCreated(int tabCount) {
        int rectArrayLen = this.rects.length;
        if (tabCount != rectArrayLen) {
            Rectangle[] tempRectArray = new Rectangle[tabCount];
            System.arraycopy(this.rects, 0, tempRectArray, 0, Math.min(rectArrayLen, tabCount));
            this.rects = tempRectArray;
            int rectIndex = rectArrayLen;
            while (rectIndex < tabCount) {
                this.rects[rectIndex] = new Rectangle();
                ++rectIndex;
            }
        }
    }

    protected void expandTabRunsArray() {
        int rectLen = this.tabRuns.length;
        int[] newArray = new int[rectLen + 10];
        System.arraycopy(this.tabRuns, 0, newArray, 0, this.runCount);
        this.tabRuns = newArray;
    }

    protected int getRunForTab(int tabCount, int tabIndex) {
        int i = 0;
        while (i < this.runCount) {
            int first = this.tabRuns[i];
            int last = this.lastTabInRun(tabCount, i);
            if (tabIndex >= first && tabIndex <= last) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected int lastTabInRun(int tabCount, int run) {
        int nextRun;
        if (this.runCount == 1) {
            return tabCount - 1;
        }
        int n = nextRun = run == this.runCount - 1 ? 0 : run + 1;
        if (this.tabRuns[nextRun] == 0) {
            return tabCount - 1;
        }
        return this.tabRuns[nextRun] - 1;
    }

    protected int getTabRunOverlay(int tabPlacement) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int tabPlacement, int run) {
        return 0;
    }

    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return this.runCount > 1;
    }

    protected boolean shouldRotateTabRuns(int tabPlacement) {
        return true;
    }

    protected Icon getIconForTab(int tabIndex) {
        return !this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(tabIndex) ? this.tabPane.getDisabledIconAt(tabIndex) : this.tabPane.getIconAt(tabIndex);
    }

    protected View getTextViewForTab(int tabIndex) {
        if (this.htmlViews != null) {
            return (View)this.htmlViews.elementAt(tabIndex);
        }
        return null;
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        int height = 0;
        View v = this.getTextViewForTab(tabIndex);
        height = v != null ? (height += (int)v.getPreferredSpan(1)) : (height += fontHeight);
        Icon icon = this.getIconForTab(tabIndex);
        Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
        if (icon != null) {
            height = Math.max(height, icon.getIconHeight());
        }
        return height += tabInsets.top + tabInsets.bottom + 2;
    }

    protected int calculateMaxTabHeight(int tabPlacement) {
        FontMetrics metrics = this.getFontMetrics();
        int tabCount = this.tabPane.getTabCount();
        int result = 0;
        int fontHeight = metrics.getHeight();
        int i = 0;
        while (i < tabCount) {
            result = Math.max(this.calculateTabHeight(tabPlacement, i, fontHeight), result);
            ++i;
        }
        return result;
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        View v;
        Icon icon = this.getIconForTab(tabIndex);
        Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
        int width = tabInsets.left + tabInsets.right + 3;
        if (icon != null) {
            width += icon.getIconWidth() + this.textIconGap;
        }
        if ((v = this.getTextViewForTab(tabIndex)) != null) {
            width += (int)v.getPreferredSpan(0);
        } else {
            String title = this.tabPane.getTitleAt(tabIndex);
            width += SwingUtilities.computeStringWidth(metrics, title);
        }
        return width;
    }

    protected int calculateMaxTabWidth(int tabPlacement) {
        FontMetrics metrics = this.getFontMetrics();
        int tabCount = this.tabPane.getTabCount();
        int result = 0;
        int i = 0;
        while (i < tabCount) {
            result = Math.max(this.calculateTabWidth(tabPlacement, i, metrics), result);
            ++i;
        }
        return result;
    }

    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int tabRunOverlay = this.getTabRunOverlay(tabPlacement);
        return horizRunCount > 0 ? horizRunCount * (maxTabHeight - tabRunOverlay) + tabRunOverlay + tabAreaInsets.top + tabAreaInsets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int maxTabWidth) {
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int tabRunOverlay = this.getTabRunOverlay(tabPlacement);
        return vertRunCount > 0 ? vertRunCount * (maxTabWidth - tabRunOverlay) + tabRunOverlay + tabAreaInsets.left + tabAreaInsets.right : 0;
    }

    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        return this.tabInsets;
    }

    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        TabbedPaneUI.rotateInsets(this.selectedTabPadInsets, this.currentPadInsets, tabPlacement);
        return this.currentPadInsets;
    }

    protected Insets getTabAreaInsets(int tabPlacement) {
        TabbedPaneUI.rotateInsets(this.tabAreaInsets, this.currentTabAreaInsets, tabPlacement);
        return this.currentTabAreaInsets;
    }

    protected Insets getContentBorderInsets(int tabPlacement) {
        return this.contentBorderInsets;
    }

    protected FontMetrics getFontMetrics() {
        Font font = UIManager.getFont("TabbedPane.selectedFont");
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    protected void navigateSelectedTab(int direction) {
        int tabPlacement = this.tabPane.getTabPlacement();
        int current = this.tabPane.getSelectedIndex();
        int tabCount = this.tabPane.getTabCount();
        block0 : switch (tabPlacement) {
            case 12: {
                this.selectNextTab(current);
                break;
            }
            case 13: {
                this.selectPreviousTab(current);
                break;
            }
            case 2: 
            case 4: {
                switch (direction) {
                    case 1: {
                        this.selectPreviousTabInRun(current);
                        break;
                    }
                    case 5: {
                        this.selectNextTabInRun(current);
                        break;
                    }
                    case 7: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, false);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break;
                    }
                    case 3: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, true);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                    }
                }
                break;
            }
            default: {
                switch (direction) {
                    case 1: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, false);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 5: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, true);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 3: {
                        this.selectNextTabInRun(current);
                        break block0;
                    }
                    case 7: {
                        this.selectPreviousTabInRun(current);
                    }
                }
            }
        }
    }

    protected void selectNextTabInRun(int current) {
        int tabCount = this.tabPane.getTabCount();
        int tabIndex = this.getNextTabIndexInRun(tabCount, current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getNextTabIndexInRun(tabCount, tabIndex);
        }
        this.tabPane.setSelectedIndex(tabIndex);
    }

    protected void selectPreviousTabInRun(int current) {
        int tabCount = this.tabPane.getTabCount();
        int tabIndex = this.getPreviousTabIndexInRun(tabCount, current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getPreviousTabIndexInRun(tabCount, tabIndex);
        }
        this.tabPane.setSelectedIndex(tabIndex);
    }

    protected void selectNextTab(int current) {
        int tabIndex = this.getNextTabIndex(current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getNextTabIndex(tabIndex);
        }
        this.tabPane.setSelectedIndex(tabIndex);
    }

    protected void selectPreviousTab(int current) {
        int tabIndex = this.getPreviousTabIndex(current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getPreviousTabIndex(tabIndex);
        }
        this.tabPane.setSelectedIndex(tabIndex);
    }

    protected void selectAdjacentRunTab(int tabPlacement, int tabIndex, int offset) {
        int newIndex;
        if (this.runCount < 2) {
            return;
        }
        Rectangle r = this.rects[tabIndex];
        switch (tabPlacement) {
            case 2: 
            case 4: {
                newIndex = this.getTabAtLocation(r.x + r.width / 2 + offset, r.y + r.height / 2);
                break;
            }
            default: {
                newIndex = this.getTabAtLocation(r.x + r.width / 2, r.y + r.height / 2 + offset);
            }
        }
        if (newIndex != -1) {
            while (!this.tabPane.isEnabledAt(newIndex) && newIndex != tabIndex) {
                newIndex = this.getNextTabIndex(newIndex);
            }
            this.tabPane.setSelectedIndex(newIndex);
        }
    }

    protected int getTabRunOffset(int tabPlacement, int tabCount, int tabIndex, boolean forward) {
        int offset;
        int run = this.getRunForTab(tabCount, tabIndex);
        switch (tabPlacement) {
            case 2: {
                if (run == 0) {
                    offset = forward ? -(this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                if (run == this.runCount - 1) {
                    offset = forward ? this.maxTabWidth : this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                offset = forward ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 4: {
                if (run == 0) {
                    offset = forward ? this.maxTabWidth : this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                if (run == this.runCount - 1) {
                    offset = forward ? -(this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                offset = forward ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 3: {
                if (run == 0) {
                    offset = forward ? this.maxTabHeight : this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight;
                    break;
                }
                if (run == this.runCount - 1) {
                    offset = forward ? -(this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight;
                    break;
                }
                offset = forward ? this.maxTabHeight : -this.maxTabHeight;
                break;
            }
            default: {
                offset = run == 0 ? (forward ? -(this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight) : (run == this.runCount - 1 ? (forward ? this.maxTabHeight : this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight) : (forward ? this.maxTabHeight : -this.maxTabHeight));
            }
        }
        return offset;
    }

    protected int getPreviousTabIndex(int base) {
        int tabIndex = base - 1 >= 0 ? base - 1 : this.tabPane.getTabCount() - 1;
        return tabIndex >= 0 ? tabIndex : 0;
    }

    protected int getNextTabIndex(int base) {
        return (base + 1) % this.tabPane.getTabCount();
    }

    protected int getNextTabIndexInRun(int tabCount, int base) {
        if (this.runCount < 2) {
            return this.getNextTabIndex(base);
        }
        int currentRun = this.getRunForTab(tabCount, base);
        int next = this.getNextTabIndex(base);
        if (next == this.tabRuns[this.getNextTabRun(currentRun)]) {
            return this.tabRuns[currentRun];
        }
        return next;
    }

    protected int getPreviousTabIndexInRun(int tabCount, int base) {
        if (this.runCount < 2) {
            return this.getPreviousTabIndex(base);
        }
        int currentRun = this.getRunForTab(tabCount, base);
        if (base == this.tabRuns[currentRun]) {
            int previous = this.tabRuns[this.getNextTabRun(currentRun)] - 1;
            return previous != -1 ? previous : tabCount - 1;
        }
        return this.getPreviousTabIndex(base);
    }

    protected int getPreviousTabRun(int baseRun) {
        int runIndex = baseRun - 1 >= 0 ? baseRun - 1 : this.runCount - 1;
        return runIndex >= 0 ? runIndex : 0;
    }

    protected int getNextTabRun(int baseRun) {
        return (baseRun + 1) % this.runCount;
    }

    protected static void rotateInsets(Insets topInsets, Insets targetInsets, int targetPlacement) {
        switch (targetPlacement) {
            case 2: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.top;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.bottom;
                break;
            }
            case 3: {
                targetInsets.top = topInsets.bottom;
                targetInsets.left = topInsets.left;
                targetInsets.bottom = topInsets.top;
                targetInsets.right = topInsets.right;
                break;
            }
            case 4: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.bottom;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.top;
                break;
            }
            default: {
                targetInsets.top = topInsets.top;
                targetInsets.left = topInsets.left;
                targetInsets.bottom = topInsets.bottom;
                targetInsets.right = topInsets.right;
            }
        }
    }

    boolean requestMyFocusForVisibleComponent() {
        Component visibleComponent = this.getVisibleComponent();
        if (visibleComponent.isFocusTraversable()) {
            visibleComponent.requestFocus();
            return true;
        }
        return visibleComponent instanceof JComponent && ((JComponent)visibleComponent).requestDefaultFocus();
    }

    private Vector createHTMLVector() {
        Vector<View> htmlViews = new Vector<View>();
        int count = this.tabPane.getTabCount();
        if (count > 0) {
            int i = 0;
            while (i < count) {
                String title = this.tabPane.getTitleAt(i);
                if (BasicHTML.isHTMLString(title)) {
                    htmlViews.addElement(BasicHTML.createHTMLView(this.tabPane, title));
                } else {
                    htmlViews.addElement(null);
                }
                ++i;
            }
        }
        return htmlViews;
    }

    private static class RightAction
    extends AbstractAction {
        RightAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            TabbedPaneUI ui = (TabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(3);
        }
    }

    private static class LeftAction
    extends AbstractAction {
        LeftAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            TabbedPaneUI ui = (TabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(7);
        }
    }

    private static class UpAction
    extends AbstractAction {
        UpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            TabbedPaneUI ui = (TabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(1);
        }
    }

    private static class DownAction
    extends AbstractAction {
        DownAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            TabbedPaneUI ui = (TabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(5);
        }
    }

    private static class NextAction
    extends AbstractAction {
        NextAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            TabbedPaneUI ui = (TabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(12);
        }
    }

    private static class PreviousAction
    extends AbstractAction {
        PreviousAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            TabbedPaneUI ui = (TabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(13);
        }
    }

    private static class PageUpAction
    extends AbstractAction {
        PageUpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            TabbedPaneUI ui = (TabbedPaneUI)pane.getUI();
            int tabPlacement = pane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                ui.navigateSelectedTab(7);
            } else {
                ui.navigateSelectedTab(1);
            }
        }
    }

    private static class PageDownAction
    extends AbstractAction {
        PageDownAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            TabbedPaneUI ui = (TabbedPaneUI)pane.getUI();
            int tabPlacement = pane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                ui.navigateSelectedTab(3);
            } else {
                ui.navigateSelectedTab(5);
            }
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        RequestFocusAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            pane.requestFocus();
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        RequestFocusForVisibleAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            TabbedPaneUI ui = (TabbedPaneUI)pane.getUI();
            ui.requestMyFocusForVisibleComponent();
        }
    }

    private static class SetSelectedIndexAction
    extends AbstractAction {
        SetSelectedIndexAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            if (pane != null && pane.getUI() instanceof BasicTabbedPaneUI) {
                TabbedPaneUI ui = (TabbedPaneUI)pane.getUI();
                String command = e.getActionCommand();
                if (command != null && command.length() > 0) {
                    Integer index;
                    int mnemonic = e.getActionCommand().charAt(0);
                    if (mnemonic >= 97 && mnemonic <= 122) {
                        mnemonic -= 32;
                    }
                    if ((index = (Integer)ui.mnemonicToIndexMap.get(new Integer(mnemonic))) != null) {
                        pane.setSelectedIndex(index);
                    }
                }
            }
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        ScrollTabsForwardAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = null;
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                pane = (JTabbedPane)src;
            } else if (src instanceof ScrollableTabButton) {
                pane = (JTabbedPane)((ScrollableTabButton)src).getParent();
            } else {
                return;
            }
            TabbedPaneUI ui = (TabbedPaneUI)pane.getUI();
            if (ui.scrollableTabLayoutEnabled()) {
                ui.tabScroller.scrollForward(pane.getTabPlacement());
            }
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        ScrollTabsBackwardAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = null;
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                pane = (JTabbedPane)src;
            } else if (src instanceof ScrollableTabButton) {
                pane = (JTabbedPane)((ScrollableTabButton)src).getParent();
            } else {
                return;
            }
            TabbedPaneUI ui = (TabbedPaneUI)pane.getUI();
            if (ui.scrollableTabLayoutEnabled()) {
                ui.tabScroller.scrollBackward(pane.getTabPlacement());
            }
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.calculateSize(false);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.calculateSize(true);
        }

        protected Dimension calculateSize(boolean minimum) {
            int tabPlacement = TabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = TabbedPaneUI.this.tabPane.getInsets();
            Insets contentInsets = TabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            Insets tabAreaInsets = TabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Dimension zeroSize = new Dimension(0, 0);
            int height = contentInsets.top + contentInsets.bottom;
            int width = contentInsets.left + contentInsets.right;
            int cWidth = 0;
            int cHeight = 0;
            int i = 0;
            while (i < TabbedPaneUI.this.tabPane.getTabCount()) {
                Component component = TabbedPaneUI.this.tabPane.getComponentAt(i);
                if (component != null) {
                    Dimension size = zeroSize;
                    Dimension dimension = size = minimum ? component.getMinimumSize() : component.getPreferredSize();
                    if (size != null) {
                        cHeight = Math.max(size.height, cHeight);
                        cWidth = Math.max(size.width, cWidth);
                    }
                }
                ++i;
            }
            width += cWidth;
            height += cHeight;
            int tabExtent = 0;
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    height = Math.max(height, TabbedPaneUI.this.calculateMaxTabHeight(tabPlacement) + tabAreaInsets.top + tabAreaInsets.bottom);
                    tabExtent = this.preferredTabAreaWidth(tabPlacement, height);
                    width += tabExtent;
                    break;
                }
                default: {
                    width = Math.max(width, TabbedPaneUI.this.calculateMaxTabWidth(tabPlacement) + tabAreaInsets.left + tabAreaInsets.right);
                    tabExtent = this.preferredTabAreaHeight(tabPlacement, width);
                    height += tabExtent;
                }
            }
            return new Dimension(width + insets.left + insets.right, height + insets.bottom + insets.top);
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            FontMetrics metrics = TabbedPaneUI.this.getFontMetrics();
            int tabCount = TabbedPaneUI.this.tabPane.getTabCount();
            int total = 0;
            if (tabCount > 0) {
                int rows = 1;
                int x = 0;
                int maxTabHeight = TabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                int i = 0;
                while (i < tabCount) {
                    int tabWidth = TabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    if (x != 0 && x + tabWidth > width) {
                        ++rows;
                        x = 0;
                    }
                    x += tabWidth;
                    ++i;
                }
                total = TabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, rows, maxTabHeight);
            }
            return total;
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            FontMetrics metrics = TabbedPaneUI.this.getFontMetrics();
            int tabCount = TabbedPaneUI.this.tabPane.getTabCount();
            int total = 0;
            if (tabCount > 0) {
                int columns = 1;
                int y = 0;
                int fontHeight = metrics.getHeight();
                TabbedPaneUI.this.maxTabWidth = TabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                int i = 0;
                while (i < tabCount) {
                    int tabHeight = TabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    if (y != 0 && y + tabHeight > height) {
                        ++columns;
                        y = 0;
                    }
                    y += tabHeight;
                    ++i;
                }
                total = TabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, columns, TabbedPaneUI.this.maxTabWidth);
            }
            return total;
        }

        public void layoutContainer(Container parent) {
            int tabPlacement = TabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = TabbedPaneUI.this.tabPane.getInsets();
            int selectedIndex = TabbedPaneUI.this.tabPane.getSelectedIndex();
            Component visibleComponent = TabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    TabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                int totalTabWidth = 0;
                int totalTabHeight = 0;
                Insets contentInsets = TabbedPaneUI.this.getContentBorderInsets(tabPlacement);
                Component selectedComponent = TabbedPaneUI.this.tabPane.getComponentAt(selectedIndex);
                boolean shouldChangeFocus = false;
                if (selectedComponent != null && selectedComponent != visibleComponent) {
                    if (visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                        shouldChangeFocus = true;
                    }
                    TabbedPaneUI.this.setVisibleComponent(selectedComponent);
                }
                Rectangle bounds = TabbedPaneUI.this.tabPane.getBounds();
                int numChildren = TabbedPaneUI.this.tabPane.getComponentCount();
                if (numChildren > 0) {
                    int cy;
                    int cx;
                    switch (tabPlacement) {
                        case 2: {
                            totalTabWidth = TabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, TabbedPaneUI.this.runCount, TabbedPaneUI.this.maxTabWidth);
                            cx = insets.left + totalTabWidth + contentInsets.left;
                            cy = insets.top + contentInsets.top;
                            break;
                        }
                        case 4: {
                            totalTabWidth = TabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, TabbedPaneUI.this.runCount, TabbedPaneUI.this.maxTabWidth);
                            cx = insets.left + contentInsets.left;
                            cy = insets.top + contentInsets.top;
                            break;
                        }
                        case 3: {
                            totalTabHeight = TabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, TabbedPaneUI.this.runCount, TabbedPaneUI.this.maxTabHeight);
                            cx = insets.left + contentInsets.left;
                            cy = insets.top + contentInsets.top;
                            break;
                        }
                        default: {
                            totalTabHeight = TabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, TabbedPaneUI.this.runCount, TabbedPaneUI.this.maxTabHeight);
                            cx = insets.left + contentInsets.left;
                            cy = insets.top + totalTabHeight + contentInsets.top;
                        }
                    }
                    int cw = bounds.width - totalTabWidth - insets.left - insets.right - contentInsets.left - contentInsets.right;
                    int ch = bounds.height - totalTabHeight - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                    int i = 0;
                    while (i < numChildren) {
                        Component child = TabbedPaneUI.this.tabPane.getComponent(i);
                        child.setBounds(cx, cy, cw, ch);
                        ++i;
                    }
                }
                if (shouldChangeFocus && !TabbedPaneUI.this.requestMyFocusForVisibleComponent()) {
                    TabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        public void calculateLayoutInfo() {
            int tabCount = TabbedPaneUI.this.tabPane.getTabCount();
            TabbedPaneUI.this.assureRectsCreated(tabCount);
            this.calculateTabRects(TabbedPaneUI.this.tabPane.getTabPlacement(), tabCount);
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            Rectangle rect;
            int returnAt;
            int y;
            int x;
            FontMetrics metrics = TabbedPaneUI.this.getFontMetrics();
            Dimension size = TabbedPaneUI.this.tabPane.getSize();
            Insets insets = TabbedPaneUI.this.tabPane.getInsets();
            Insets tabAreaInsets = TabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            int fontHeight = metrics.getHeight();
            int selectedIndex = TabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = TonicUtils.isLeftToRight(TabbedPaneUI.this.tabPane);
            switch (tabPlacement) {
                case 2: {
                    TabbedPaneUI.this.maxTabWidth = TabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 4: {
                    TabbedPaneUI.this.maxTabWidth = TabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = size.width - insets.right - tabAreaInsets.right - TabbedPaneUI.this.maxTabWidth;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 3: {
                    TabbedPaneUI.this.maxTabHeight = TabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = size.height - insets.bottom - tabAreaInsets.bottom - TabbedPaneUI.this.maxTabHeight;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                    break;
                }
                default: {
                    TabbedPaneUI.this.maxTabHeight = TabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                }
            }
            int tabRunOverlay = TabbedPaneUI.this.getTabRunOverlay(tabPlacement);
            TabbedPaneUI.this.runCount = 0;
            TabbedPaneUI.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            int i = 0;
            while (i < tabCount) {
                rect = TabbedPaneUI.this.rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = TabbedPaneUI.this.rects[i - 1].x + TabbedPaneUI.this.rects[i - 1].width;
                    } else {
                        TabbedPaneUI.this.tabRuns[0] = 0;
                        TabbedPaneUI.this.runCount = 1;
                        TabbedPaneUI.this.maxTabWidth = 0;
                        rect.x = x;
                    }
                    rect.width = TabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    TabbedPaneUI.this.maxTabWidth = Math.max(TabbedPaneUI.this.maxTabWidth, rect.width);
                    if (rect.x != 2 + insets.left && rect.x + rect.width > returnAt) {
                        if (TabbedPaneUI.this.runCount > TabbedPaneUI.this.tabRuns.length - 1) {
                            TabbedPaneUI.this.expandTabRunsArray();
                        }
                        TabbedPaneUI.this.tabRuns[TabbedPaneUI.this.runCount] = i;
                        ++TabbedPaneUI.this.runCount;
                        rect.x = x;
                    }
                    rect.y = y;
                    rect.height = TabbedPaneUI.this.maxTabHeight;
                } else {
                    if (i > 0) {
                        rect.y = TabbedPaneUI.this.rects[i - 1].y + TabbedPaneUI.this.rects[i - 1].height;
                    } else {
                        TabbedPaneUI.this.tabRuns[0] = 0;
                        TabbedPaneUI.this.runCount = 1;
                        TabbedPaneUI.this.maxTabHeight = 0;
                        rect.y = y;
                    }
                    rect.height = TabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    TabbedPaneUI.this.maxTabHeight = Math.max(TabbedPaneUI.this.maxTabHeight, rect.height);
                    if (rect.y != 2 + insets.top && rect.y + rect.height > returnAt) {
                        if (TabbedPaneUI.this.runCount > TabbedPaneUI.this.tabRuns.length - 1) {
                            TabbedPaneUI.this.expandTabRunsArray();
                        }
                        TabbedPaneUI.this.tabRuns[TabbedPaneUI.this.runCount] = i;
                        ++TabbedPaneUI.this.runCount;
                        rect.y = y;
                    }
                    rect.x = x;
                    rect.width = TabbedPaneUI.this.maxTabWidth;
                }
                if (i == selectedIndex) {
                    TabbedPaneUI.this.selectedRun = TabbedPaneUI.this.runCount - 1;
                }
                ++i;
            }
            if (TabbedPaneUI.this.runCount > 1) {
                this.normalizeTabRuns(tabPlacement, tabCount, verticalTabRuns ? y : x, returnAt);
                TabbedPaneUI.this.selectedRun = TabbedPaneUI.this.getRunForTab(tabCount, selectedIndex);
                if (TabbedPaneUI.this.shouldRotateTabRuns(tabPlacement)) {
                    this.rotateTabRuns(tabPlacement, TabbedPaneUI.this.selectedRun);
                }
            }
            i = TabbedPaneUI.this.runCount - 1;
            while (i >= 0) {
                int j;
                int end;
                int start = TabbedPaneUI.this.tabRuns[i];
                int next = TabbedPaneUI.this.tabRuns[i == TabbedPaneUI.this.runCount - 1 ? 0 : i + 1];
                int n = end = next != 0 ? next - 1 : tabCount - 1;
                if (!verticalTabRuns) {
                    j = start;
                    while (j <= end) {
                        rect = TabbedPaneUI.this.rects[j];
                        rect.y = y;
                        rect.x += TabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                        ++j;
                    }
                    if (TabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                        this.padTabRun(tabPlacement, start, end, returnAt);
                    }
                    y = tabPlacement == 3 ? (y -= TabbedPaneUI.this.maxTabHeight - tabRunOverlay) : (y += TabbedPaneUI.this.maxTabHeight - tabRunOverlay);
                } else {
                    j = start;
                    while (j <= end) {
                        rect = TabbedPaneUI.this.rects[j];
                        rect.x = x;
                        rect.y += TabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                        ++j;
                    }
                    if (TabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                        this.padTabRun(tabPlacement, start, end, returnAt);
                    }
                    x = tabPlacement == 4 ? (x -= TabbedPaneUI.this.maxTabWidth - tabRunOverlay) : (x += TabbedPaneUI.this.maxTabWidth - tabRunOverlay);
                }
                --i;
            }
            this.padSelectedTab(tabPlacement, selectedIndex);
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                i = 0;
                while (i < tabCount) {
                    TabbedPaneUI.this.rects[i].x = rightMargin - TabbedPaneUI.this.rects[i].x - TabbedPaneUI.this.rects[i].width;
                    ++i;
                }
            }
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
            int i = 0;
            while (i < selectedRun) {
                int save = TabbedPaneUI.this.tabRuns[0];
                int j = 1;
                while (j < TabbedPaneUI.this.runCount) {
                    TabbedPaneUI.this.tabRuns[j - 1] = TabbedPaneUI.this.tabRuns[j];
                    ++j;
                }
                TabbedPaneUI.this.tabRuns[TabbedPaneUI.this.runCount - 1] = save;
                ++i;
            }
        }

        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            int run = TabbedPaneUI.this.runCount - 1;
            boolean keepAdjusting = true;
            double weight = 1.25;
            while (keepAdjusting) {
                int prevLastLen;
                int end;
                int last = TabbedPaneUI.this.lastTabInRun(tabCount, run);
                int prevLast = TabbedPaneUI.this.lastTabInRun(tabCount, run - 1);
                if (!verticalTabRuns) {
                    end = TabbedPaneUI.this.rects[last].x + TabbedPaneUI.this.rects[last].width;
                    prevLastLen = (int)((double)TabbedPaneUI.this.maxTabWidth * weight);
                } else {
                    end = TabbedPaneUI.this.rects[last].y + TabbedPaneUI.this.rects[last].height;
                    prevLastLen = (int)((double)TabbedPaneUI.this.maxTabHeight * weight * 2.0);
                }
                if (max - end > prevLastLen) {
                    TabbedPaneUI.this.tabRuns[run] = prevLast;
                    if (!verticalTabRuns) {
                        TabbedPaneUI.this.rects[prevLast].x = start;
                    } else {
                        TabbedPaneUI.this.rects[prevLast].y = start;
                    }
                    int i = prevLast + 1;
                    while (i <= last) {
                        if (!verticalTabRuns) {
                            TabbedPaneUI.this.rects[i].x = TabbedPaneUI.this.rects[i - 1].x + TabbedPaneUI.this.rects[i - 1].width;
                        } else {
                            TabbedPaneUI.this.rects[i].y = TabbedPaneUI.this.rects[i - 1].y + TabbedPaneUI.this.rects[i - 1].height;
                        }
                        ++i;
                    }
                } else if (run == TabbedPaneUI.this.runCount - 1) {
                    keepAdjusting = false;
                }
                if (run - 1 > 0) {
                    --run;
                    continue;
                }
                run = TabbedPaneUI.this.runCount - 1;
                weight += 0.25;
            }
        }

        protected void padTabRun(int tabPlacement, int start, int end, int max) {
            Rectangle lastRect = TabbedPaneUI.this.rects[end];
            if (tabPlacement == 1 || tabPlacement == 3) {
                int runWidth = lastRect.x + lastRect.width - TabbedPaneUI.this.rects[start].x;
                int deltaWidth = max - (lastRect.x + lastRect.width);
                float factor = (float)deltaWidth / (float)runWidth;
                int j = start;
                while (j <= end) {
                    Rectangle pastRect = TabbedPaneUI.this.rects[j];
                    if (j > start) {
                        pastRect.x = TabbedPaneUI.this.rects[j - 1].x + TabbedPaneUI.this.rects[j - 1].width;
                    }
                    pastRect.width += Math.round((float)pastRect.width * factor);
                    ++j;
                }
                lastRect.width = max - lastRect.x;
            } else {
                int runHeight = lastRect.y + lastRect.height - TabbedPaneUI.this.rects[start].y;
                int deltaHeight = max - (lastRect.y + lastRect.height);
                float factor = (float)deltaHeight / (float)runHeight;
                int j = start;
                while (j <= end) {
                    Rectangle pastRect = TabbedPaneUI.this.rects[j];
                    if (j > start) {
                        pastRect.y = TabbedPaneUI.this.rects[j - 1].y + TabbedPaneUI.this.rects[j - 1].height;
                    }
                    pastRect.height += Math.round((float)pastRect.height * factor);
                    ++j;
                }
                lastRect.height = max - lastRect.y;
            }
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
            if (selectedIndex >= 0) {
                Rectangle selRect = TabbedPaneUI.this.rects[selectedIndex];
                Insets padInsets = TabbedPaneUI.this.getSelectedTabPadInsets(tabPlacement);
                selRect.x -= padInsets.left;
                selRect.width += padInsets.left + padInsets.right;
                selRect.y -= padInsets.top;
                selRect.height += padInsets.top + padInsets.bottom;
            }
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        TabbedPaneScrollLayout() {
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            return TabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            return TabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
        }

        public void layoutContainer(Container parent) {
            int tabPlacement = TabbedPaneUI.this.tabPane.getTabPlacement();
            int tabCount = TabbedPaneUI.this.tabPane.getTabCount();
            Insets insets = TabbedPaneUI.this.tabPane.getInsets();
            int selectedIndex = TabbedPaneUI.this.tabPane.getSelectedIndex();
            Component visibleComponent = TabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    TabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component selectedComponent = TabbedPaneUI.this.tabPane.getComponentAt(selectedIndex);
                boolean shouldChangeFocus = false;
                if (selectedComponent != null && selectedComponent != visibleComponent) {
                    if (visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                        shouldChangeFocus = true;
                    }
                    TabbedPaneUI.this.setVisibleComponent(selectedComponent);
                }
                Insets contentInsets = TabbedPaneUI.this.getContentBorderInsets(tabPlacement);
                Rectangle bounds = TabbedPaneUI.this.tabPane.getBounds();
                int numChildren = TabbedPaneUI.this.tabPane.getComponentCount();
                if (numChildren > 0) {
                    int ch;
                    int cw;
                    int cy;
                    int cx;
                    int ty;
                    int tx;
                    int th;
                    int tw;
                    switch (tabPlacement) {
                        case 2: {
                            tw = TabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, TabbedPaneUI.this.runCount, TabbedPaneUI.this.maxTabWidth);
                            th = bounds.height - insets.top - insets.bottom;
                            tx = insets.left;
                            ty = insets.top;
                            cx = tx + tw + contentInsets.left;
                            cy = ty + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                            break;
                        }
                        case 4: {
                            tw = TabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, TabbedPaneUI.this.runCount, TabbedPaneUI.this.maxTabWidth);
                            th = bounds.height - insets.top - insets.bottom;
                            tx = bounds.width - insets.right - tw;
                            ty = insets.top;
                            cx = insets.left + contentInsets.left;
                            cy = insets.top + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                            break;
                        }
                        case 3: {
                            tw = bounds.width - insets.left - insets.right;
                            th = TabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, TabbedPaneUI.this.runCount, TabbedPaneUI.this.maxTabHeight);
                            tx = insets.left;
                            ty = bounds.height - insets.bottom - th;
                            cx = insets.left + contentInsets.left;
                            cy = insets.top + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                            break;
                        }
                        default: {
                            tw = bounds.width - insets.left - insets.right;
                            th = TabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, TabbedPaneUI.this.runCount, TabbedPaneUI.this.maxTabHeight);
                            tx = insets.left;
                            ty = insets.top;
                            cx = tx + contentInsets.left;
                            cy = ty + th + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                        }
                    }
                    int i = 0;
                    while (i < numChildren) {
                        Component child = TabbedPaneUI.this.tabPane.getComponent(i);
                        if (child instanceof ScrollableTabViewport) {
                            JViewport viewport = (JViewport)child;
                            Rectangle viewRect = viewport.getViewRect();
                            int vw = tw;
                            int vh = th;
                            switch (tabPlacement) {
                                case 2: 
                                case 4: {
                                    int totalTabHeight = TabbedPaneUI.this.rects[tabCount - 1].y + TabbedPaneUI.this.rects[tabCount - 1].height;
                                    if (totalTabHeight <= th || totalTabHeight - viewRect.y > (vh = Math.max(th - 36, 36))) break;
                                    vh = totalTabHeight - viewRect.y;
                                    break;
                                }
                                default: {
                                    int totalTabWidth = TabbedPaneUI.this.rects[tabCount - 1].x + TabbedPaneUI.this.rects[tabCount - 1].width;
                                    if (totalTabWidth <= tw || totalTabWidth - viewRect.x > (vw = Math.max(tw - 36, 36))) break;
                                    vw = totalTabWidth - viewRect.x;
                                }
                            }
                            child.setBounds(tx, ty, vw, vh);
                        } else if (child instanceof ScrollableTabButton) {
                            ScrollableTabButton scrollbutton = (ScrollableTabButton)child;
                            Dimension bsize = scrollbutton.getPreferredSize();
                            int bx = 0;
                            int by = 0;
                            int bw = bsize.width;
                            int bh = bsize.height;
                            boolean visible = false;
                            switch (tabPlacement) {
                                case 2: 
                                case 4: {
                                    int totalTabHeight = TabbedPaneUI.this.rects[tabCount - 1].y + TabbedPaneUI.this.rects[tabCount - 1].height;
                                    if (totalTabHeight <= th) break;
                                    int dir = scrollbutton.scrollsForward() ? 5 : 1;
                                    scrollbutton.setDirection(dir);
                                    visible = true;
                                    bx = tabPlacement == 2 ? tx + tw - bsize.width : tx;
                                    by = dir == 5 ? bounds.height - insets.bottom - bsize.height : bounds.height - insets.bottom - 2 * bsize.height;
                                    break;
                                }
                                default: {
                                    int totalTabWidth = TabbedPaneUI.this.rects[tabCount - 1].x + TabbedPaneUI.this.rects[tabCount - 1].width;
                                    if (totalTabWidth <= tw) break;
                                    int dir = scrollbutton.scrollsForward() ? 3 : 7;
                                    scrollbutton.setDirection(dir);
                                    visible = true;
                                    bx = dir == 3 ? bounds.width - insets.left - bsize.width : bounds.width - insets.left - 2 * bsize.width;
                                    by = tabPlacement == 1 ? ty + th - bsize.height : ty;
                                }
                            }
                            child.setVisible(visible);
                            if (visible) {
                                child.setBounds(bx, by, bw, bh);
                            }
                        } else {
                            child.setBounds(cx, cy, cw, ch);
                        }
                        ++i;
                    }
                    if (shouldChangeFocus && !TabbedPaneUI.this.requestMyFocusForVisibleComponent()) {
                        TabbedPaneUI.this.tabPane.requestFocus();
                    }
                }
            }
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            FontMetrics metrics = TabbedPaneUI.this.getFontMetrics();
            Dimension size = TabbedPaneUI.this.tabPane.getSize();
            Insets insets = TabbedPaneUI.this.tabPane.getInsets();
            Insets tabAreaInsets = TabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            int fontHeight = metrics.getHeight();
            int selectedIndex = TabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = TonicUtils.isLeftToRight(TabbedPaneUI.this.tabPane);
            int x = tabAreaInsets.left;
            int y = tabAreaInsets.top;
            int totalWidth = 0;
            int totalHeight = 0;
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    TabbedPaneUI.this.maxTabWidth = TabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    break;
                }
                default: {
                    TabbedPaneUI.this.maxTabHeight = TabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                }
            }
            TabbedPaneUI.this.runCount = 0;
            TabbedPaneUI.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            TabbedPaneUI.this.selectedRun = 0;
            TabbedPaneUI.this.runCount = 1;
            int i = 0;
            while (i < tabCount) {
                Rectangle rect = TabbedPaneUI.this.rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = TabbedPaneUI.this.rects[i - 1].x + TabbedPaneUI.this.rects[i - 1].width;
                    } else {
                        TabbedPaneUI.this.tabRuns[0] = 0;
                        TabbedPaneUI.this.maxTabWidth = 0;
                        totalHeight += TabbedPaneUI.this.maxTabHeight;
                        rect.x = x;
                    }
                    rect.width = TabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    totalWidth = rect.x + rect.width;
                    TabbedPaneUI.this.maxTabWidth = Math.max(TabbedPaneUI.this.maxTabWidth, rect.width);
                    rect.y = y;
                    rect.height = TabbedPaneUI.this.maxTabHeight;
                } else {
                    if (i > 0) {
                        rect.y = TabbedPaneUI.this.rects[i - 1].y + TabbedPaneUI.this.rects[i - 1].height;
                    } else {
                        TabbedPaneUI.this.tabRuns[0] = 0;
                        TabbedPaneUI.this.maxTabHeight = 0;
                        totalWidth = TabbedPaneUI.this.maxTabWidth;
                        rect.y = y;
                    }
                    rect.height = TabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    totalHeight = rect.y + rect.height;
                    TabbedPaneUI.this.maxTabHeight = Math.max(TabbedPaneUI.this.maxTabHeight, rect.height);
                    rect.x = x;
                    rect.width = TabbedPaneUI.this.maxTabWidth;
                }
                ++i;
            }
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                i = 0;
                while (i < tabCount) {
                    TabbedPaneUI.this.rects[i].x = rightMargin - TabbedPaneUI.this.rects[i].x - TabbedPaneUI.this.rects[i].width;
                    ++i;
                }
            }
            ((TabbedPaneUI)TabbedPaneUI.this).tabScroller.tabPanel.setPreferredSize(new Dimension(totalWidth, totalHeight));
        }
    }

    private class ScrollableTabSupport
    implements ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public ScrollableTabButton scrollForwardButton;
        public ScrollableTabButton scrollBackwardButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int tabPlacement) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            if (tabPlacement == 1 || tabPlacement == 3) {
                this.scrollForwardButton = new ScrollableTabButton(3);
                this.scrollBackwardButton = new ScrollableTabButton(7);
            } else {
                this.scrollForwardButton = new ScrollableTabButton(5);
                this.scrollBackwardButton = new ScrollableTabButton(1);
            }
        }

        public void scrollForward(int tabPlacement) {
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            if (tabPlacement == 1 || tabPlacement == 3 ? viewRect.width >= viewSize.width - viewRect.x : viewRect.height >= viewSize.height - viewRect.y) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int tabPlacement) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex - 1);
        }

        public void setLeadingTabIndex(int tabPlacement, int index) {
            this.leadingTabIndex = index;
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            switch (tabPlacement) {
                case 1: 
                case 3: {
                    int n = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : TabbedPaneUI.this.rects[this.leadingTabIndex].x;
                    if (viewSize.width - this.tabViewPosition.x >= viewRect.width) break;
                    Dimension extentSize = new Dimension(viewSize.width - this.tabViewPosition.x, viewRect.height);
                    this.viewport.setExtentSize(extentSize);
                    break;
                }
                case 2: 
                case 4: {
                    int n = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : TabbedPaneUI.this.rects[this.leadingTabIndex].y;
                    if (viewSize.height - this.tabViewPosition.y >= viewRect.height) break;
                    Dimension extentSize = new Dimension(viewRect.width, viewSize.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(extentSize);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        public void stateChanged(ChangeEvent e) {
            JViewport viewport = (JViewport)e.getSource();
            int tabPlacement = TabbedPaneUI.this.tabPane.getTabPlacement();
            int tabCount = TabbedPaneUI.this.tabPane.getTabCount();
            Rectangle vpRect = viewport.getBounds();
            Dimension viewSize = viewport.getViewSize();
            Rectangle viewRect = viewport.getViewRect();
            this.leadingTabIndex = TabbedPaneUI.this.getClosestTab(viewRect.x, viewRect.y);
            if (this.leadingTabIndex + 1 < tabCount) {
                switch (tabPlacement) {
                    case 1: 
                    case 3: {
                        if (TabbedPaneUI.this.rects[this.leadingTabIndex].x >= viewRect.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (TabbedPaneUI.this.rects[this.leadingTabIndex].y >= viewRect.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets contentInsets = TabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            switch (tabPlacement) {
                case 2: {
                    TabbedPaneUI.this.tabPane.repaint(vpRect.x + vpRect.width, vpRect.y, contentInsets.left, vpRect.height);
                    this.scrollBackwardButton.setEnabled(viewRect.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.height - viewRect.y > viewRect.height);
                    break;
                }
                case 4: {
                    TabbedPaneUI.this.tabPane.repaint(vpRect.x - contentInsets.right, vpRect.y, contentInsets.right, vpRect.height);
                    this.scrollBackwardButton.setEnabled(viewRect.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.height - viewRect.y > viewRect.height);
                    break;
                }
                case 3: {
                    TabbedPaneUI.this.tabPane.repaint(vpRect.x, vpRect.y - contentInsets.bottom, vpRect.width, contentInsets.bottom);
                    this.scrollBackwardButton.setEnabled(viewRect.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
                    break;
                }
                default: {
                    TabbedPaneUI.this.tabPane.repaint(vpRect.x, vpRect.y + vpRect.height, vpRect.width, contentInsets.top);
                    this.scrollBackwardButton.setEnabled(viewRect.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
                }
            }
        }

        public String toString() {
            return new String("viewport.viewSize=" + this.viewport.getViewSize() + "\n" + "viewport.viewRectangle=" + this.viewport.getViewRect() + "\n" + "leadingTabIndex=" + this.leadingTabIndex + "\n" + "tabViewPosition=" + this.tabViewPosition);
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setScrollMode(0);
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            this.setLayout(null);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            TabbedPaneUI.this.paintTabArea(g, TabbedPaneUI.this.tabPane.getTabPlacement(), TabbedPaneUI.this.tabPane.getSelectedIndex());
        }
    }

    private class ScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int direction) {
            super(direction, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
        }

        public boolean scrollsForward() {
            return this.direction == 3 || this.direction == 5;
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            String name = e.getPropertyName();
            if ("mnemonicAt".equals(name)) {
                TabbedPaneUI.this.updateMnemonics();
                pane.repaint();
            } else if ("displayedMnemonicIndexAt".equals(name)) {
                pane.repaint();
            } else if (name.equals("indexForTitle")) {
                int index = (Integer)e.getNewValue();
                String title = TabbedPaneUI.this.tabPane.getTitleAt(index);
                if (BasicHTML.isHTMLString(title)) {
                    if (TabbedPaneUI.this.htmlViews == null) {
                        TabbedPaneUI.this.htmlViews = TabbedPaneUI.this.createHTMLVector();
                    } else {
                        View v = BasicHTML.createHTMLView(TabbedPaneUI.this.tabPane, title);
                        TabbedPaneUI.this.htmlViews.setElementAt(v, index);
                    }
                } else if (TabbedPaneUI.this.htmlViews != null && TabbedPaneUI.this.htmlViews.elementAt(index) != null) {
                    TabbedPaneUI.this.htmlViews.setElementAt(null, index);
                }
                TabbedPaneUI.this.updateMnemonics();
            } else if (name.equals("tabLayoutPolicy")) {
                TabbedPaneUI.this.uninstallUI(pane);
                TabbedPaneUI.this.installUI(pane);
            }
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            tabPane.revalidate();
            tabPane.repaint();
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (!TabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = TabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY());
            if (tabIndex >= 0 && TabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex == TabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (TabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                        TabbedPaneUI.this.tabPane.requestFocus();
                        TabbedPaneUI.this.tabPane.repaint(TabbedPaneUI.this.rects[tabIndex]);
                    }
                } else {
                    TabbedPaneUI.this.tabPane.setSelectedIndex(tabIndex);
                }
            }
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        public void focusGained(FocusEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            int tabCount = tabPane.getTabCount();
            if (tabCount > 0 && tabCount == TabbedPaneUI.this.rects.length) {
                tabPane.repaint(TabbedPaneUI.this.rects[tabPane.getSelectedIndex()]);
            }
        }

        public void focusLost(FocusEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            int tabCount = tabPane.getTabCount();
            if (tabCount > 0 && tabCount == TabbedPaneUI.this.rects.length) {
                tabPane.repaint(TabbedPaneUI.this.rects[tabPane.getSelectedIndex()]);
            }
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        ContainerHandler() {
        }

        public void componentAdded(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            int index = tp.indexOfComponent(child);
            String title = tp.getTitleAt(index);
            boolean isHTML = BasicHTML.isHTMLString(title);
            if (isHTML) {
                if (TabbedPaneUI.this.htmlViews == null) {
                    TabbedPaneUI.this.htmlViews = TabbedPaneUI.this.createHTMLVector();
                } else {
                    View v = BasicHTML.createHTMLView(tp, title);
                    TabbedPaneUI.this.htmlViews.insertElementAt(v, index);
                }
            } else if (TabbedPaneUI.this.htmlViews != null) {
                TabbedPaneUI.this.htmlViews.insertElementAt(null, index);
            }
        }

        public void componentRemoved(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            int index = tp.indexOfComponent(child);
            if (TabbedPaneUI.this.htmlViews != null && TabbedPaneUI.this.htmlViews.size() >= index) {
                TabbedPaneUI.this.htmlViews.removeElementAt(index);
            }
        }
    }
}

