/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.fw.gui.ErrorDialog;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class MemoryPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MemoryPanel.class);
    private JProgressBar _bar;
    private JButton _btnGarbage;
    private JButton _btnSessionGCStatus;
    private transient IApplication _app;
    private HashMap<IIdentifier, MemorySessionInfo> _sessionInfosBySessionIDs = new HashMap();

    public MemoryPanel(IApplication app) {
        this._app = app;
        this._bar = new JProgressBar();
        this._bar.setStringPainted(true);
        this._btnGarbage = new JButton();
        this._btnGarbage.setToolTipText(s_stringMgr.getString("MemoryPanel.runGC"));
        this._btnGarbage.setBorder(null);
        ImageIcon trashIcon = this._app.getResources().getIcon("trash");
        this._btnGarbage.setIcon(trashIcon);
        Dimension prefButtonSize = new Dimension(3 * trashIcon.getIconWidth() / 2, trashIcon.getIconHeight());
        this._btnGarbage.setPreferredSize(prefButtonSize);
        this._btnGarbage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Utilities.garbageCollect();
            }
        });
        this._btnSessionGCStatus = new JButton(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
            }
        };
        this._btnSessionGCStatus.setBorder(null);
        this.updateGcStatus();
        this._btnSessionGCStatus.setBorder(null);
        this._btnSessionGCStatus.setPreferredSize(prefButtonSize);
        this._btnSessionGCStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryPanel.this.showSessionGCStatus();
            }
        });
        JPanel pnlButtons = new JPanel(new GridLayout(1, 2, 3, 0));
        pnlButtons.add(this._btnSessionGCStatus);
        pnlButtons.add(this._btnGarbage);
        this.setLayout(new BorderLayout(5, 0));
        this.add((Component)pnlButtons, "East");
        this.add((Component)this._bar, "Center");
        this.setBorder(null);
        this._app.getSessionManager().addSessionListener(new SessionAdapter(){

            @Override
            public void sessionClosed(SessionEvent evt) {
                IIdentifier id = evt.getSession().getIdentifier();
                MemorySessionInfo msi = (MemorySessionInfo)MemoryPanel.this._sessionInfosBySessionIDs.get(id);
                if (null == msi) {
                    throw new IllegalStateException("A session with ID " + id + " has not been created");
                }
                msi.closed = new Date();
                MemoryPanel.this.updateGcStatus();
            }

            @Override
            public void sessionConnected(SessionEvent evt) {
                IIdentifier id = evt.getSession().getIdentifier();
                if (null != MemoryPanel.this._sessionInfosBySessionIDs.get(id)) {
                    throw new IllegalStateException("A session with ID " + id + " has already been created");
                }
                MemorySessionInfo msi = new MemorySessionInfo(id, evt.getSession().getAlias().getName());
                MemoryPanel.this._sessionInfosBySessionIDs.put(id, msi);
            }

            @Override
            public void sessionFinalized(IIdentifier sessionId) {
                MemorySessionInfo msi = (MemorySessionInfo)MemoryPanel.this._sessionInfosBySessionIDs.get(sessionId);
                if (null == msi) {
                    throw new IllegalStateException("A session with ID " + sessionId + " has not been created");
                }
                msi.finalized = new Date();
                MemoryPanel.this.updateGcStatus();
            }
        });
        Timer t = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryPanel.this.updateLabel();
            }
        });
        t.start();
    }

    private void updateGcStatus() {
        SessionGCStatus gcStat = this.getSessionGCStatus();
        this._btnSessionGCStatus.setToolTipText(gcStat.tooltip);
        this._btnSessionGCStatus.setBackground(gcStat.color);
        this._btnSessionGCStatus.setText(gcStat.numSessAwaitingGC);
    }

    private SessionGCStatus getSessionGCStatus() {
        SessionGCStatus ret = new SessionGCStatus();
        int numSessAwaitingGC = 0;
        for (MemorySessionInfo msi : this._sessionInfosBySessionIDs.values()) {
            if (null == msi.closed || null != msi.finalized) continue;
            ++numSessAwaitingGC;
        }
        ret.numSessAwaitingGC = "" + numSessAwaitingGC;
        ret.tooltip = s_stringMgr.getString("MemoryPanel.gcStatusToolTip", new Integer(ret.numSessAwaitingGC));
        ret.color = Color.yellow;
        if (numSessAwaitingGC < 2) {
            ret.color = Color.green;
        } else if (numSessAwaitingGC > 4) {
            ret.color = Color.red;
        }
        return ret;
    }

    private void updateLabel() {
        long total = Runtime.getRuntime().totalMemory() >> 10 >> 10;
        long free = Runtime.getRuntime().freeMemory() >> 10 >> 10;
        long just = total - free;
        this._bar.setMinimum(0);
        this._bar.setMaximum((int)total);
        this._bar.setValue((int)just);
        Object[] params = new Long[]{just, total};
        String msg = s_stringMgr.getString("MemoryPanel.memSize", params);
        this._bar.setString(msg);
    }

    private void showSessionGCStatus() {
        StringBuffer[] params = new StringBuffer[]{new StringBuffer(this.getSessionGCStatus().tooltip), new StringBuffer(), new StringBuffer(), new StringBuffer()};
        Object[] msis = this._sessionInfosBySessionIDs.values().toArray(new MemorySessionInfo[0]);
        Arrays.sort(msis);
        for (int i = 0; i < msis.length; ++i) {
            if (null != ((MemorySessionInfo)msis[i]).closed && null == ((MemorySessionInfo)msis[i]).finalized) {
                params[1].append(((MemorySessionInfo)msis[i]).toString()).append('\n');
                continue;
            }
            if (null == ((MemorySessionInfo)msis[i]).closed) {
                params[2].append(((MemorySessionInfo)msis[i]).toString()).append('\n');
                continue;
            }
            if (null == ((MemorySessionInfo)msis[i]).finalized) continue;
            params[3].append(((MemorySessionInfo)msis[i]).toString()).append('\n');
        }
        String msg = s_stringMgr.getString("MemoryPanel.gcStatus", params);
        ErrorDialog errorDialog = new ErrorDialog((Frame)this._app.getMainFrame(), msg);
        errorDialog.setTitle(s_stringMgr.getString("MemoryPanel.statusDialogTitle"));
        errorDialog.setVisible(true);
    }

    private static class SessionGCStatus {
        String tooltip;
        Color color;
        String numSessAwaitingGC;

        private SessionGCStatus() {
        }
    }

    private static class MemorySessionInfo
    implements Comparable<MemorySessionInfo> {
        IIdentifier sessionId;
        String aliasName;
        Date created = new Date();
        Date closed;
        Date finalized;

        MemorySessionInfo(IIdentifier sessionId, String aliasName) {
            this.sessionId = sessionId;
            this.aliasName = aliasName;
        }

        public String toString() {
            DateFormat df = DateFormat.getInstance();
            Object[] params = new Object[]{this.sessionId, this.aliasName, df.format(this.created), null == this.closed ? "" : df.format(this.closed), null == this.finalized ? "" : df.format(this.finalized)};
            if (null != this.closed && null == this.finalized) {
                return s_stringMgr.getString("MemoryPanel.sessionInfo.toString1", params);
            }
            if (null == this.closed) {
                return s_stringMgr.getString("MemoryPanel.sessionInfo.toString2", params);
            }
            if (null != this.finalized) {
                return s_stringMgr.getString("MemoryPanel.sessionInfo.toString3", params);
            }
            throw new IllegalStateException("Unknown Session state");
        }

        @Override
        public int compareTo(MemorySessionInfo other) {
            return Integer.valueOf(((Object)this.sessionId).toString()).compareTo(Integer.valueOf(((Object)other.sessionId).toString()));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.sessionId == null ? 0 : ((Object)this.sessionId).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MemorySessionInfo other = (MemorySessionInfo)obj;
            return !(this.sessionId == null ? other.sessionId != null : !((Object)this.sessionId).equals(other.sessionId));
        }
    }
}

