/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListDataListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryItem;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLHistoryComboBoxModel
extends DefaultComboBoxModel {
    private static final ILogger s_log = LoggerController.createLogger(SQLHistoryComboBoxModel.class);
    private static MutableComboBoxModel s_sharedDataModel;
    private MutableComboBoxModel _dataModel;
    private Object _selectedObject;

    public SQLHistoryComboBoxModel(boolean useSharedModel) {
        if (useSharedModel && s_sharedDataModel == null) {
            throw new IllegalStateException("Shared instance has not been initialized");
        }
        this._dataModel = useSharedModel ? s_sharedDataModel : new DefaultComboBoxModel();
    }

    public static synchronized void initializeSharedInstance(Object[] data) {
        if (s_sharedDataModel != null) {
            s_log.error("Shared data model has already been initialized");
        } else {
            s_sharedDataModel = new DefaultComboBoxModel<Object>(data);
        }
    }

    public boolean isUsingSharedDataModel() {
        return this._dataModel == s_sharedDataModel;
    }

    public synchronized void setUseSharedModel(boolean use) {
        if (this.isUsingSharedDataModel() != use) {
            this._dataModel = use ? s_sharedDataModel : this.duplicateSharedDataModel();
        }
    }

    @Override
    public void addElement(Object object) {
        this._dataModel.addElement(object);
    }

    @Override
    public void insertElementAt(Object object, int index) {
        this._dataModel.insertElementAt(object, index);
    }

    @Override
    public void removeElement(Object object) {
        this._dataModel.removeElement(object);
    }

    @Override
    public void removeElementAt(int index) {
        this._dataModel.removeElementAt(index);
    }

    @Override
    public Object getSelectedItem() {
        return this._selectedObject;
    }

    @Override
    public void setSelectedItem(Object object) {
        this._selectedObject = object;
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public void addListDataListener(ListDataListener arg0) {
        this._dataModel.addListDataListener(arg0);
    }

    @Override
    public Object getElementAt(int arg0) {
        return this._dataModel.getElementAt(arg0);
    }

    @Override
    public int getSize() {
        return this._dataModel.getSize();
    }

    @Override
    public void removeListDataListener(ListDataListener arg0) {
        this._dataModel.removeListDataListener(arg0);
    }

    protected synchronized MutableComboBoxModel duplicateSharedDataModel() {
        DefaultComboBoxModel<Object> newModel = new DefaultComboBoxModel<Object>();
        int limit = s_sharedDataModel.getSize();
        for (int i = 0; i < limit; ++i) {
            SQLHistoryItem obj = (SQLHistoryItem)s_sharedDataModel.getElementAt(i);
            newModel.addElement(obj.clone());
        }
        return newModel;
    }

    public ArrayList<SQLHistoryItem> getItems() {
        ArrayList<SQLHistoryItem> ret = new ArrayList<SQLHistoryItem>();
        for (int i = 0; i < this._dataModel.getSize(); ++i) {
            ret.add((SQLHistoryItem)this._dataModel.getElementAt(i));
        }
        return ret;
    }
}

