/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.sql.SQLException;
import java.util.TreeMap;
import javax.swing.JComboBox;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SQLCatalogsComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLCatalogsComboBox.class);

    public void setCatalogs(String[] catalogs, String selectedCatalog) {
        super.removeAllItems();
        if (catalogs != null) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (String catalog : catalogs) {
                if (this.isEmptyCatalog(catalog)) continue;
                map.put(catalog, catalog);
            }
            if (this.isEmptyCatalog(selectedCatalog)) {
                this.addItem(new NoCatalogPlaceHolder());
            }
            for (String catalog : map.values()) {
                this.addItem(catalog);
            }
            if (!this.isEmptyCatalog(selectedCatalog)) {
                this.setSelectedCatalog(selectedCatalog);
            }
        }
        this.setMaximumSize(this.getPreferredSize());
    }

    private boolean isEmptyCatalog(String catalog) {
        return catalog == null || "".equals(catalog);
    }

    public void setConnection(ISQLConnection conn) throws SQLException {
        String[] catalogs;
        if (conn == null) {
            throw new IllegalArgumentException("SQLConnection == null");
        }
        SQLDatabaseMetaData md = conn.getSQLMetaData();
        if (md.supportsCatalogs() && (catalogs = md.getCatalogs()) != null) {
            this.setCatalogs(catalogs, conn.getCatalog());
        }
    }

    public String getSelectedCatalog() {
        return this.getSelectedItem().toString();
    }

    public void setSelectedCatalog(String selectedCatalog) {
        if (selectedCatalog != null) {
            this.getModel().setSelectedItem(selectedCatalog);
        }
    }

    @Override
    public void setSelectedItem(Object o) {
        super.setSelectedItem(o);
        if (super.getItemAt(0) instanceof NoCatalogPlaceHolder) {
            super.removeItemAt(0);
            this.validate();
        }
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private class NoCatalogPlaceHolder {
        private NoCatalogPlaceHolder() {
        }

        public String toString() {
            return i18n.NONE_LABEL;
        }
    }

    private static interface i18n {
        public static final String NONE_LABEL = SQLCatalogsComboBox.access$000().getString("SQLCatalogsComboBox.noneLabel");
    }
}

