/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.math.ed25519;

import java.util.Arrays;
import net.i2p.crypto.eddsa.Utils;
import net.i2p.crypto.eddsa.math.Field;
import net.i2p.crypto.eddsa.math.FieldElement;

public class Ed25519FieldElement
extends FieldElement {
    final int[] t;
    private static final byte[] ZERO = new byte[32];

    public Ed25519FieldElement(Field field, int[] nArray) {
        super(field);
        if (nArray.length != 10) {
            throw new IllegalArgumentException("Invalid radix-2^51 representation");
        }
        this.t = nArray;
    }

    @Override
    public boolean isNonZero() {
        byte[] byArray = this.toByteArray();
        return Utils.equal(byArray, ZERO) == 0;
    }

    @Override
    public FieldElement add(FieldElement fieldElement) {
        int[] nArray = ((Ed25519FieldElement)fieldElement).t;
        int[] nArray2 = new int[10];
        for (int i = 0; i < 10; ++i) {
            nArray2[i] = this.t[i] + nArray[i];
        }
        return new Ed25519FieldElement(this.f, nArray2);
    }

    @Override
    public FieldElement subtract(FieldElement fieldElement) {
        int[] nArray = ((Ed25519FieldElement)fieldElement).t;
        int[] nArray2 = new int[10];
        for (int i = 0; i < 10; ++i) {
            nArray2[i] = this.t[i] - nArray[i];
        }
        return new Ed25519FieldElement(this.f, nArray2);
    }

    @Override
    public FieldElement negate() {
        int[] nArray = new int[10];
        for (int i = 0; i < 10; ++i) {
            nArray[i] = -this.t[i];
        }
        return new Ed25519FieldElement(this.f, nArray);
    }

    @Override
    public FieldElement multiply(FieldElement fieldElement) {
        int[] nArray = ((Ed25519FieldElement)fieldElement).t;
        int n = 19 * nArray[1];
        int n2 = 19 * nArray[2];
        int n3 = 19 * nArray[3];
        int n4 = 19 * nArray[4];
        int n5 = 19 * nArray[5];
        int n6 = 19 * nArray[6];
        int n7 = 19 * nArray[7];
        int n8 = 19 * nArray[8];
        int n9 = 19 * nArray[9];
        int n10 = 2 * this.t[1];
        int n11 = 2 * this.t[3];
        int n12 = 2 * this.t[5];
        int n13 = 2 * this.t[7];
        int n14 = 2 * this.t[9];
        long l = (long)this.t[0] * (long)nArray[0];
        long l2 = (long)this.t[0] * (long)nArray[1];
        long l3 = (long)this.t[0] * (long)nArray[2];
        long l4 = (long)this.t[0] * (long)nArray[3];
        long l5 = (long)this.t[0] * (long)nArray[4];
        long l6 = (long)this.t[0] * (long)nArray[5];
        long l7 = (long)this.t[0] * (long)nArray[6];
        long l8 = (long)this.t[0] * (long)nArray[7];
        long l9 = (long)this.t[0] * (long)nArray[8];
        long l10 = (long)this.t[0] * (long)nArray[9];
        long l11 = (long)this.t[1] * (long)nArray[0];
        long l12 = (long)n10 * (long)nArray[1];
        long l13 = (long)this.t[1] * (long)nArray[2];
        long l14 = (long)n10 * (long)nArray[3];
        long l15 = (long)this.t[1] * (long)nArray[4];
        long l16 = (long)n10 * (long)nArray[5];
        long l17 = (long)this.t[1] * (long)nArray[6];
        long l18 = (long)n10 * (long)nArray[7];
        long l19 = (long)this.t[1] * (long)nArray[8];
        long l20 = (long)n10 * (long)n9;
        long l21 = (long)this.t[2] * (long)nArray[0];
        long l22 = (long)this.t[2] * (long)nArray[1];
        long l23 = (long)this.t[2] * (long)nArray[2];
        long l24 = (long)this.t[2] * (long)nArray[3];
        long l25 = (long)this.t[2] * (long)nArray[4];
        long l26 = (long)this.t[2] * (long)nArray[5];
        long l27 = (long)this.t[2] * (long)nArray[6];
        long l28 = (long)this.t[2] * (long)nArray[7];
        long l29 = (long)this.t[2] * (long)n8;
        long l30 = (long)this.t[2] * (long)n9;
        long l31 = (long)this.t[3] * (long)nArray[0];
        long l32 = (long)n11 * (long)nArray[1];
        long l33 = (long)this.t[3] * (long)nArray[2];
        long l34 = (long)n11 * (long)nArray[3];
        long l35 = (long)this.t[3] * (long)nArray[4];
        long l36 = (long)n11 * (long)nArray[5];
        long l37 = (long)this.t[3] * (long)nArray[6];
        long l38 = (long)n11 * (long)n7;
        long l39 = (long)this.t[3] * (long)n8;
        long l40 = (long)n11 * (long)n9;
        long l41 = (long)this.t[4] * (long)nArray[0];
        long l42 = (long)this.t[4] * (long)nArray[1];
        long l43 = (long)this.t[4] * (long)nArray[2];
        long l44 = (long)this.t[4] * (long)nArray[3];
        long l45 = (long)this.t[4] * (long)nArray[4];
        long l46 = (long)this.t[4] * (long)nArray[5];
        long l47 = (long)this.t[4] * (long)n6;
        long l48 = (long)this.t[4] * (long)n7;
        long l49 = (long)this.t[4] * (long)n8;
        long l50 = (long)this.t[4] * (long)n9;
        long l51 = (long)this.t[5] * (long)nArray[0];
        long l52 = (long)n12 * (long)nArray[1];
        long l53 = (long)this.t[5] * (long)nArray[2];
        long l54 = (long)n12 * (long)nArray[3];
        long l55 = (long)this.t[5] * (long)nArray[4];
        long l56 = (long)n12 * (long)n5;
        long l57 = (long)this.t[5] * (long)n6;
        long l58 = (long)n12 * (long)n7;
        long l59 = (long)this.t[5] * (long)n8;
        long l60 = (long)n12 * (long)n9;
        long l61 = (long)this.t[6] * (long)nArray[0];
        long l62 = (long)this.t[6] * (long)nArray[1];
        long l63 = (long)this.t[6] * (long)nArray[2];
        long l64 = (long)this.t[6] * (long)nArray[3];
        long l65 = (long)this.t[6] * (long)n4;
        long l66 = (long)this.t[6] * (long)n5;
        long l67 = (long)this.t[6] * (long)n6;
        long l68 = (long)this.t[6] * (long)n7;
        long l69 = (long)this.t[6] * (long)n8;
        long l70 = (long)this.t[6] * (long)n9;
        long l71 = (long)this.t[7] * (long)nArray[0];
        long l72 = (long)n13 * (long)nArray[1];
        long l73 = (long)this.t[7] * (long)nArray[2];
        long l74 = (long)n13 * (long)n3;
        long l75 = (long)this.t[7] * (long)n4;
        long l76 = (long)n13 * (long)n5;
        long l77 = (long)this.t[7] * (long)n6;
        long l78 = (long)n13 * (long)n7;
        long l79 = (long)this.t[7] * (long)n8;
        long l80 = (long)n13 * (long)n9;
        long l81 = (long)this.t[8] * (long)nArray[0];
        long l82 = (long)this.t[8] * (long)nArray[1];
        long l83 = (long)this.t[8] * (long)n2;
        long l84 = (long)this.t[8] * (long)n3;
        long l85 = (long)this.t[8] * (long)n4;
        long l86 = (long)this.t[8] * (long)n5;
        long l87 = (long)this.t[8] * (long)n6;
        long l88 = (long)this.t[8] * (long)n7;
        long l89 = (long)this.t[8] * (long)n8;
        long l90 = (long)this.t[8] * (long)n9;
        long l91 = (long)this.t[9] * (long)nArray[0];
        long l92 = (long)n14 * (long)n;
        long l93 = (long)this.t[9] * (long)n2;
        long l94 = (long)n14 * (long)n3;
        long l95 = (long)this.t[9] * (long)n4;
        long l96 = (long)n14 * (long)n5;
        long l97 = (long)this.t[9] * (long)n6;
        long l98 = (long)n14 * (long)n7;
        long l99 = (long)this.t[9] * (long)n8;
        long l100 = (long)n14 * (long)n9;
        long l101 = l + l20 + l29 + l38 + l47 + l56 + l65 + l74 + l83 + l92;
        long l102 = l2 + l11 + l30 + l39 + l48 + l57 + l66 + l75 + l84 + l93;
        long l103 = l3 + l12 + l21 + l40 + l49 + l58 + l67 + l76 + l85 + l94;
        long l104 = l4 + l13 + l22 + l31 + l50 + l59 + l68 + l77 + l86 + l95;
        long l105 = l5 + l14 + l23 + l32 + l41 + l60 + l69 + l78 + l87 + l96;
        long l106 = l6 + l15 + l24 + l33 + l42 + l51 + l70 + l79 + l88 + l97;
        long l107 = l7 + l16 + l25 + l34 + l43 + l52 + l61 + l80 + l89 + l98;
        long l108 = l8 + l17 + l26 + l35 + l44 + l53 + l62 + l71 + l90 + l99;
        long l109 = l9 + l18 + l27 + l36 + l45 + l54 + l63 + l72 + l81 + l100;
        long l110 = l10 + l19 + l28 + l37 + l46 + l55 + l64 + l73 + l82 + l91;
        long l111 = l101 + 0x2000000L >> 26;
        l101 -= l111 << 26;
        long l112 = l105 + 0x2000000L >> 26;
        l105 -= l112 << 26;
        long l113 = (l102 += l111) + 0x1000000L >> 25;
        l102 -= l113 << 25;
        long l114 = (l106 += l112) + 0x1000000L >> 25;
        l106 -= l114 << 25;
        long l115 = (l103 += l113) + 0x2000000L >> 26;
        l103 -= l115 << 26;
        long l116 = (l107 += l114) + 0x2000000L >> 26;
        l107 -= l116 << 26;
        long l117 = (l104 += l115) + 0x1000000L >> 25;
        l104 -= l117 << 25;
        long l118 = (l108 += l116) + 0x1000000L >> 25;
        l112 = (l105 += l117) + 0x2000000L >> 26;
        long l119 = (l109 += l118) + 0x2000000L >> 26;
        long l120 = (l110 += l119) + 0x1000000L >> 25;
        l111 = (l101 += l120 * 19L) + 0x2000000L >> 26;
        int[] nArray2 = new int[]{(int)(l101 -= l111 << 26), (int)(l102 += l111), (int)l103, (int)l104, (int)(l105 -= l112 << 26), (int)(l106 += l112), (int)l107, (int)(l108 -= l118 << 25), (int)(l109 -= l119 << 26), (int)(l110 -= l120 << 25)};
        return new Ed25519FieldElement(this.f, nArray2);
    }

    @Override
    public FieldElement square() {
        int n = this.t[0];
        int n2 = this.t[1];
        int n3 = this.t[2];
        int n4 = this.t[3];
        int n5 = this.t[4];
        int n6 = this.t[5];
        int n7 = this.t[6];
        int n8 = this.t[7];
        int n9 = this.t[8];
        int n10 = this.t[9];
        int n11 = 2 * n;
        int n12 = 2 * n2;
        int n13 = 2 * n3;
        int n14 = 2 * n4;
        int n15 = 2 * n5;
        int n16 = 2 * n6;
        int n17 = 2 * n7;
        int n18 = 2 * n8;
        int n19 = 38 * n6;
        int n20 = 19 * n7;
        int n21 = 38 * n8;
        int n22 = 19 * n9;
        int n23 = 38 * n10;
        long l = (long)n * (long)n;
        long l2 = (long)n11 * (long)n2;
        long l3 = (long)n11 * (long)n3;
        long l4 = (long)n11 * (long)n4;
        long l5 = (long)n11 * (long)n5;
        long l6 = (long)n11 * (long)n6;
        long l7 = (long)n11 * (long)n7;
        long l8 = (long)n11 * (long)n8;
        long l9 = (long)n11 * (long)n9;
        long l10 = (long)n11 * (long)n10;
        long l11 = (long)n12 * (long)n2;
        long l12 = (long)n12 * (long)n3;
        long l13 = (long)n12 * (long)n14;
        long l14 = (long)n12 * (long)n5;
        long l15 = (long)n12 * (long)n16;
        long l16 = (long)n12 * (long)n7;
        long l17 = (long)n12 * (long)n18;
        long l18 = (long)n12 * (long)n9;
        long l19 = (long)n12 * (long)n23;
        long l20 = (long)n3 * (long)n3;
        long l21 = (long)n13 * (long)n4;
        long l22 = (long)n13 * (long)n5;
        long l23 = (long)n13 * (long)n6;
        long l24 = (long)n13 * (long)n7;
        long l25 = (long)n13 * (long)n8;
        long l26 = (long)n13 * (long)n22;
        long l27 = (long)n3 * (long)n23;
        long l28 = (long)n14 * (long)n4;
        long l29 = (long)n14 * (long)n5;
        long l30 = (long)n14 * (long)n16;
        long l31 = (long)n14 * (long)n7;
        long l32 = (long)n14 * (long)n21;
        long l33 = (long)n14 * (long)n22;
        long l34 = (long)n14 * (long)n23;
        long l35 = (long)n5 * (long)n5;
        long l36 = (long)n15 * (long)n6;
        long l37 = (long)n15 * (long)n20;
        long l38 = (long)n5 * (long)n21;
        long l39 = (long)n15 * (long)n22;
        long l40 = (long)n5 * (long)n23;
        long l41 = (long)n6 * (long)n19;
        long l42 = (long)n16 * (long)n20;
        long l43 = (long)n16 * (long)n21;
        long l44 = (long)n16 * (long)n22;
        long l45 = (long)n16 * (long)n23;
        long l46 = (long)n7 * (long)n20;
        long l47 = (long)n7 * (long)n21;
        long l48 = (long)n17 * (long)n22;
        long l49 = (long)n7 * (long)n23;
        long l50 = (long)n8 * (long)n21;
        long l51 = (long)n18 * (long)n22;
        long l52 = (long)n18 * (long)n23;
        long l53 = (long)n9 * (long)n22;
        long l54 = (long)n9 * (long)n23;
        long l55 = (long)n10 * (long)n23;
        long l56 = l + l19 + l26 + l32 + l37 + l41;
        long l57 = l2 + l27 + l33 + l38 + l42;
        long l58 = l3 + l11 + l34 + l39 + l43 + l46;
        long l59 = l4 + l12 + l40 + l44 + l47;
        long l60 = l5 + l13 + l20 + l45 + l48 + l50;
        long l61 = l6 + l14 + l21 + l49 + l51;
        long l62 = l7 + l15 + l22 + l28 + l52 + l53;
        long l63 = l8 + l16 + l23 + l29 + l54;
        long l64 = l9 + l17 + l24 + l30 + l35 + l55;
        long l65 = l10 + l18 + l25 + l31 + l36;
        long l66 = l56 + 0x2000000L >> 26;
        l56 -= l66 << 26;
        long l67 = l60 + 0x2000000L >> 26;
        l60 -= l67 << 26;
        long l68 = (l57 += l66) + 0x1000000L >> 25;
        l57 -= l68 << 25;
        long l69 = (l61 += l67) + 0x1000000L >> 25;
        l61 -= l69 << 25;
        long l70 = (l58 += l68) + 0x2000000L >> 26;
        l58 -= l70 << 26;
        long l71 = (l62 += l69) + 0x2000000L >> 26;
        l62 -= l71 << 26;
        long l72 = (l59 += l70) + 0x1000000L >> 25;
        l59 -= l72 << 25;
        long l73 = (l63 += l71) + 0x1000000L >> 25;
        l67 = (l60 += l72) + 0x2000000L >> 26;
        long l74 = (l64 += l73) + 0x2000000L >> 26;
        long l75 = (l65 += l74) + 0x1000000L >> 25;
        l66 = (l56 += l75 * 19L) + 0x2000000L >> 26;
        int[] nArray = new int[]{(int)(l56 -= l66 << 26), (int)(l57 += l66), (int)l58, (int)l59, (int)(l60 -= l67 << 26), (int)(l61 += l67), (int)l62, (int)(l63 -= l73 << 25), (int)(l64 -= l74 << 26), (int)(l65 -= l75 << 25)};
        return new Ed25519FieldElement(this.f, nArray);
    }

    @Override
    public FieldElement squareAndDouble() {
        int n = this.t[0];
        int n2 = this.t[1];
        int n3 = this.t[2];
        int n4 = this.t[3];
        int n5 = this.t[4];
        int n6 = this.t[5];
        int n7 = this.t[6];
        int n8 = this.t[7];
        int n9 = this.t[8];
        int n10 = this.t[9];
        int n11 = 2 * n;
        int n12 = 2 * n2;
        int n13 = 2 * n3;
        int n14 = 2 * n4;
        int n15 = 2 * n5;
        int n16 = 2 * n6;
        int n17 = 2 * n7;
        int n18 = 2 * n8;
        int n19 = 38 * n6;
        int n20 = 19 * n7;
        int n21 = 38 * n8;
        int n22 = 19 * n9;
        int n23 = 38 * n10;
        long l = (long)n * (long)n;
        long l2 = (long)n11 * (long)n2;
        long l3 = (long)n11 * (long)n3;
        long l4 = (long)n11 * (long)n4;
        long l5 = (long)n11 * (long)n5;
        long l6 = (long)n11 * (long)n6;
        long l7 = (long)n11 * (long)n7;
        long l8 = (long)n11 * (long)n8;
        long l9 = (long)n11 * (long)n9;
        long l10 = (long)n11 * (long)n10;
        long l11 = (long)n12 * (long)n2;
        long l12 = (long)n12 * (long)n3;
        long l13 = (long)n12 * (long)n14;
        long l14 = (long)n12 * (long)n5;
        long l15 = (long)n12 * (long)n16;
        long l16 = (long)n12 * (long)n7;
        long l17 = (long)n12 * (long)n18;
        long l18 = (long)n12 * (long)n9;
        long l19 = (long)n12 * (long)n23;
        long l20 = (long)n3 * (long)n3;
        long l21 = (long)n13 * (long)n4;
        long l22 = (long)n13 * (long)n5;
        long l23 = (long)n13 * (long)n6;
        long l24 = (long)n13 * (long)n7;
        long l25 = (long)n13 * (long)n8;
        long l26 = (long)n13 * (long)n22;
        long l27 = (long)n3 * (long)n23;
        long l28 = (long)n14 * (long)n4;
        long l29 = (long)n14 * (long)n5;
        long l30 = (long)n14 * (long)n16;
        long l31 = (long)n14 * (long)n7;
        long l32 = (long)n14 * (long)n21;
        long l33 = (long)n14 * (long)n22;
        long l34 = (long)n14 * (long)n23;
        long l35 = (long)n5 * (long)n5;
        long l36 = (long)n15 * (long)n6;
        long l37 = (long)n15 * (long)n20;
        long l38 = (long)n5 * (long)n21;
        long l39 = (long)n15 * (long)n22;
        long l40 = (long)n5 * (long)n23;
        long l41 = (long)n6 * (long)n19;
        long l42 = (long)n16 * (long)n20;
        long l43 = (long)n16 * (long)n21;
        long l44 = (long)n16 * (long)n22;
        long l45 = (long)n16 * (long)n23;
        long l46 = (long)n7 * (long)n20;
        long l47 = (long)n7 * (long)n21;
        long l48 = (long)n17 * (long)n22;
        long l49 = (long)n7 * (long)n23;
        long l50 = (long)n8 * (long)n21;
        long l51 = (long)n18 * (long)n22;
        long l52 = (long)n18 * (long)n23;
        long l53 = (long)n9 * (long)n22;
        long l54 = (long)n9 * (long)n23;
        long l55 = (long)n10 * (long)n23;
        long l56 = l + l19 + l26 + l32 + l37 + l41;
        long l57 = l2 + l27 + l33 + l38 + l42;
        long l58 = l3 + l11 + l34 + l39 + l43 + l46;
        long l59 = l4 + l12 + l40 + l44 + l47;
        long l60 = l5 + l13 + l20 + l45 + l48 + l50;
        long l61 = l6 + l14 + l21 + l49 + l51;
        long l62 = l7 + l15 + l22 + l28 + l52 + l53;
        long l63 = l8 + l16 + l23 + l29 + l54;
        long l64 = l9 + l17 + l24 + l30 + l35 + l55;
        long l65 = l10 + l18 + l25 + l31 + l36;
        l56 += l56;
        l57 += l57;
        l58 += l58;
        l59 += l59;
        l60 += l60;
        l61 += l61;
        l62 += l62;
        l63 += l63;
        l64 += l64;
        l65 += l65;
        long l66 = l56 + 0x2000000L >> 26;
        l56 -= l66 << 26;
        long l67 = l60 + 0x2000000L >> 26;
        l60 -= l67 << 26;
        long l68 = (l57 += l66) + 0x1000000L >> 25;
        l57 -= l68 << 25;
        long l69 = (l61 += l67) + 0x1000000L >> 25;
        l61 -= l69 << 25;
        long l70 = (l58 += l68) + 0x2000000L >> 26;
        l58 -= l70 << 26;
        long l71 = (l62 += l69) + 0x2000000L >> 26;
        l62 -= l71 << 26;
        long l72 = (l59 += l70) + 0x1000000L >> 25;
        l59 -= l72 << 25;
        long l73 = (l63 += l71) + 0x1000000L >> 25;
        l67 = (l60 += l72) + 0x2000000L >> 26;
        long l74 = (l64 += l73) + 0x2000000L >> 26;
        long l75 = (l65 += l74) + 0x1000000L >> 25;
        l66 = (l56 += l75 * 19L) + 0x2000000L >> 26;
        int[] nArray = new int[]{(int)(l56 -= l66 << 26), (int)(l57 += l66), (int)l58, (int)l59, (int)(l60 -= l67 << 26), (int)(l61 += l67), (int)l62, (int)(l63 -= l73 << 25), (int)(l64 -= l74 << 26), (int)(l65 -= l75 << 25)};
        return new Ed25519FieldElement(this.f, nArray);
    }

    @Override
    public FieldElement invert() {
        int n;
        FieldElement fieldElement = this.square();
        FieldElement fieldElement2 = fieldElement.square();
        fieldElement2 = fieldElement2.square();
        fieldElement2 = this.multiply(fieldElement2);
        fieldElement = fieldElement.multiply(fieldElement2);
        FieldElement fieldElement3 = fieldElement.square();
        fieldElement2 = fieldElement2.multiply(fieldElement3);
        fieldElement3 = fieldElement2.square();
        for (n = 1; n < 5; ++n) {
            fieldElement3 = fieldElement3.square();
        }
        fieldElement2 = fieldElement3.multiply(fieldElement2);
        fieldElement3 = fieldElement2.square();
        for (n = 1; n < 10; ++n) {
            fieldElement3 = fieldElement3.square();
        }
        fieldElement3 = fieldElement3.multiply(fieldElement2);
        FieldElement fieldElement4 = fieldElement3.square();
        for (n = 1; n < 20; ++n) {
            fieldElement4 = fieldElement4.square();
        }
        fieldElement3 = fieldElement4.multiply(fieldElement3);
        fieldElement3 = fieldElement3.square();
        for (n = 1; n < 10; ++n) {
            fieldElement3 = fieldElement3.square();
        }
        fieldElement2 = fieldElement3.multiply(fieldElement2);
        fieldElement3 = fieldElement2.square();
        for (n = 1; n < 50; ++n) {
            fieldElement3 = fieldElement3.square();
        }
        fieldElement3 = fieldElement3.multiply(fieldElement2);
        fieldElement4 = fieldElement3.square();
        for (n = 1; n < 100; ++n) {
            fieldElement4 = fieldElement4.square();
        }
        fieldElement3 = fieldElement4.multiply(fieldElement3);
        fieldElement3 = fieldElement3.square();
        for (n = 1; n < 50; ++n) {
            fieldElement3 = fieldElement3.square();
        }
        fieldElement2 = fieldElement3.multiply(fieldElement2);
        fieldElement2 = fieldElement2.square();
        for (n = 1; n < 5; ++n) {
            fieldElement2 = fieldElement2.square();
        }
        return fieldElement2.multiply(fieldElement);
    }

    @Override
    public FieldElement pow22523() {
        int n;
        FieldElement fieldElement = this.square();
        FieldElement fieldElement2 = fieldElement.square();
        fieldElement2 = fieldElement2.square();
        fieldElement2 = this.multiply(fieldElement2);
        fieldElement = fieldElement.multiply(fieldElement2);
        fieldElement = fieldElement.square();
        fieldElement = fieldElement2.multiply(fieldElement);
        fieldElement2 = fieldElement.square();
        for (n = 1; n < 5; ++n) {
            fieldElement2 = fieldElement2.square();
        }
        fieldElement = fieldElement2.multiply(fieldElement);
        fieldElement2 = fieldElement.square();
        for (n = 1; n < 10; ++n) {
            fieldElement2 = fieldElement2.square();
        }
        fieldElement2 = fieldElement2.multiply(fieldElement);
        FieldElement fieldElement3 = fieldElement2.square();
        for (n = 1; n < 20; ++n) {
            fieldElement3 = fieldElement3.square();
        }
        fieldElement2 = fieldElement3.multiply(fieldElement2);
        fieldElement2 = fieldElement2.square();
        for (n = 1; n < 10; ++n) {
            fieldElement2 = fieldElement2.square();
        }
        fieldElement = fieldElement2.multiply(fieldElement);
        fieldElement2 = fieldElement.square();
        for (n = 1; n < 50; ++n) {
            fieldElement2 = fieldElement2.square();
        }
        fieldElement2 = fieldElement2.multiply(fieldElement);
        fieldElement3 = fieldElement2.square();
        for (n = 1; n < 100; ++n) {
            fieldElement3 = fieldElement3.square();
        }
        fieldElement2 = fieldElement3.multiply(fieldElement2);
        fieldElement2 = fieldElement2.square();
        for (n = 1; n < 50; ++n) {
            fieldElement2 = fieldElement2.square();
        }
        fieldElement = fieldElement2.multiply(fieldElement);
        fieldElement = fieldElement.square();
        fieldElement = fieldElement.square();
        return this.multiply(fieldElement);
    }

    @Override
    public FieldElement cmov(FieldElement fieldElement, int n) {
        Ed25519FieldElement ed25519FieldElement = (Ed25519FieldElement)fieldElement;
        n = -n;
        int[] nArray = new int[10];
        int n2 = 0;
        while (n2 < 10) {
            nArray[n2] = this.t[n2];
            int n3 = this.t[n2] ^ ed25519FieldElement.t[n2];
            int n4 = n2++;
            nArray[n4] = nArray[n4] ^ (n3 &= n);
        }
        return new Ed25519FieldElement(this.f, nArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this.t);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Ed25519FieldElement)) {
            return false;
        }
        Ed25519FieldElement ed25519FieldElement = (Ed25519FieldElement)object;
        return 1 == Utils.equal(this.toByteArray(), ed25519FieldElement.toByteArray());
    }

    public String toString() {
        return "[Ed25519FieldElement val=" + Utils.bytesToHex(this.toByteArray()) + "]";
    }
}

