package TDS::Admin::Authorize;
# $Id: Authorize.pm,v 1.26 2001/01/03 08:20:49 tom Exp $
################################################################

=head1 NAME

TDS::Admin::Authorize - Authorization

=cut


################################################################

use strict;
use vars qw(@ISA @EXPORT
	    $EnablePassword_wo_AuthorizedID);
#use Exporter;

use ObjectTemplate;
use CGI::CookieTool;
use CGI::QueryString;
use Crypt;

use TDS;
use TDS::System;
use TDS::DirInfo;
use TDS::Admin::AuthorID;
use TDS::Cookie;

@ISA = qw(ObjectTemplate);
#@EXPORT = qw(attributes);

# if authorization by ID is failed, try again by password
$EnablePassword_wo_AuthorizedID = 0 unless defined $EnablePassword_wo_AuthorizedID;

attributes qw(passwd_file legal_crypted_passwd);

################################################################
sub initialize($)
{
    my $self = shift;

    $self->passwd_file(GetConfFilename('.passwd')) unless $self->passwd_file;
    
    if (open(F, $self->passwd_file)){
	my $first_line = <F>;
	chomp $first_line;
	$self->legal_crypted_passwd($first_line);
	close F;
    }
    $self->SUPER::initialize;
}

=head1 MEMBER FUNCTIONS

=cut

################################################################

=head2 $a->CheckAuthorized;

check authorized.
if OK, return true,
else show error message and die.

=cut

sub CheckAuthorized ($;$)
{
    my ($self, $action) = @_;

    my $status = $TDS::Status;
    
    $action ||= $ENV{'SCRIPT_NAME'};
    
    unless ($status->is_author){
	unless ($EnablePassword_wo_AuthorizedID){       # try no more
	    my $diary_dir = GetDiaryDir();
	    print "<h1>Authorizing Error</h1>
<p>your browser is <strong>NOT</strong> authorized,
if you are author of this diary,
please add the following ID to $diary_dir/conf/author_id.txt.</p>
<blockquote>",
    $status->id->GetID(),
    "</blockquote>";
	    print_footer();
	    exit;
	} else {                        # try checking by password
	    unless (param('password')){
		print "<html><head><title>Password Check</title></head><body>\n";
		print "<h1>Password Check</h1>\n";
		printf("<p>your ID(%s) is not authorized.
			   but you can pass it by password.</p>",
		       $status->id->GetID());
		print qq(<form method="post" action="$action">\n);
		for (param()){
#		    next if $_ !~ /^[a-z_]+$/ || $_ eq 'password';
		    next if $_ eq 'password';
		    
		    # ummm, it may be security hole...
		    printf(qq(<input type="hidden" name="%s" value="%s">\n),
			   $_, param($_));
		}
		print qq(<p>Input Password: <input name="password" type="password">\n);
		print qq(<input type="checkbox" name="add_to_author">);
		print qq(add to author_id.txt<br>);
		print qq(<input type="submit" value=" OK "> <input type="reset">\n);
		print "</form>";
		print qq(<hr><p><a href="./">admin</a></body></html>\n);
		exit;
	    } else {
		$self->CheckPassword(param('password'));
		if (param('add_to_author')){
		    my $author_id = new TDS::Admin::AuthorID;
		    $author_id->Add($TDS::Status->id->GetID);
		}
		
	    }
	}
    }
}

=head2 $a->CheckPassword($checked_passwd);

check password.
if wrong password is given, 
show error message and die.

=cut

sub CheckPassword($$)
{
    my ($self, $checked_passwd) = @_;

    my $msg;
    unless ($self->legal_crypted_passwd){
	$msg = "legal password is not set. in " . $self->passwd_file;
    }
    unless (IsLegalPassword($checked_passwd, $self->legal_crypted_passwd)){
	$msg = "illegal passwd"; #: $checked_passwd,
    }
    if ($msg){
	print "<html><head><title>Password Check Failed</title></head><body>\n";
	print "<h1>Password Check Failed</h1>";
	print $msg;
	print_footer();
	exit;
    }
}
sub PrintHTTPHeader
{
    my $status = $TDS::Status;

    print "content-type: text/html\n";
    print TDS::Cookie->AsCookieHeaders()
	if $status->id->is_first_visit;
#	if $status->id->GetTimes() <= 1;     # in first visit, give a cookie
    print "\n";
}

################################################################
# static functions
sub print_footer
{
    print qq(<hr><a href="./">admin</a>
	     - powered by
	     <a href="$TDS::TDSHomePage">TomsoftDiarySystem</a>
	     ver $TDS::Version
	     </body></html>);
}

    
1;
