/*****
 NAME
 	ptext.h - protocols for text operation classes
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(PTEXT_H_INCLUDED)
#define PTEXT_H_INCLUDED

#include <coconut/pset.h>
#include <coconut/pstring.h>
#include <coconut/pstream.h>
#include <coconut/perror.h>

/* similar interface is used in PList in "plist.h" */
@protocol PWordList <PObject>
  /* return the number of elements */
  - (u_int) setStr: (id <PString>) str keepSpaces: (boolean) dokeep ;
  - (u_int) setPtr: (const utf8_char *) str length: (u_int) len 
      keepSpaces: (boolean) dokeep ;
  - (u_int) setWithoutSpaces: (const utf8_char *) str length: (u_int) len ;
  - (u_int) setWithSpaces: (const utf8_char *) str length: (u_int) len ;
  - (id <PString>) item: (u_int) no ;
  - clear ;
@end

@protocol PIndent <PObject>
  - (const utf8_char *) ptr ;
  - (const utf8_char *) unitPtr ;
  - (u_int) level ;
  - incLevel ;
  - decLevel ;
@end

@protocol PIndentStream <PStream, PIndent>
@end

/* similar interface is used in PList in "plist.h" */
/******
  PROTOCOL:
  	PText
  DESCRIPTION:
    the "PText" protocols operates the list of strings. 
    Each strings in the list is a text line which DOES NOT contain newline
    code.
 */
@protocol PText <PDebug>

   /* this method returns the last added string */
 - (id <PString>) appendStr: (id <PBasicStr>) str ;
 - (id <PString>) appendPtr: (const utf8_char *) text length: (u_int) len ;

   /* the "text" and "str" must not contain the newline code. If you can 
      not probe it, use "appendPtr" or "appendStr" method. */
 - (id <PString>) appendLine: (const utf8_char *) text length: (u_int) len ;
 - (id <PString>) appendLineStr: (id <PString>) str ;

   /* this method returns the last added string */
 - (id <PString>) prependPtr: (const utf8_char *) text length: (u_int) len ;

   /* the "text" and "str" must not contain the newline code. If you can 
      not probe it, use "prependPtr" or "prependStr" method. */
 - (id <PString>) prependLine: (const utf8_char *) text length: (u_int) len ;
 - (id <PString>) prependLineStr: (id <PString>) str ;

 - (id <PString>) add: (id <PString>) str ;
 - (id <PString>) addPtr: (const utf8_char *) text length: (u_int) len ;
   /* if you know the string "text" never include newline code,
      use thid method instead of "addPtr" */
 - (id <PString>) addLine: (const utf8_char *) text length: (u_int) len ;

 - (id <PString>) currentItem ;
 - (id <PString>) concatenate ;

 - (id <PString>) moveNext ;
 - (id <PString>) movePrev ;
 - (id <PString>) moveToHead ;
 - (id <PString>) moveToTail ;

   /* remove the spaces on the head of first line. And remove the same
      spaces from following lines.  */
 - removeLeftSpaces: (u_int) spaces tab: (u_int) tablen ;

   /* remove the empty lines on the top or bottom of text */
 - removeBothEmptyLines ;
   /* remove heading spaces and insert indent for all lines
      the indent of first line is "unitptr", the rest of line's indent 
      is "indent". */
 - pretty: (const utf8_char *) unitptr indent: (id <PIndent>) indent ;

 - foreach: (SEL) msg with: p1 with: p2 ;

 - clear ;

   /* if the flag is true, each lines are printouted with newline code when
      print the text */
 - doPrintWithNewline: (boolean) flag ;
@end

#endif /* !defined(PTEXT_H_INCLUDED) */

