/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;

public class BasicToolTipUI
extends ToolTipUI {
    private static BasicToolTipUI shared;
    private String text;

    public static ComponentUI createUI(JComponent c) {
        if (shared == null) {
            shared = new BasicToolTipUI();
        }
        return shared;
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        JToolTip tip = (JToolTip)c;
        Toolkit g = tip.getToolkit();
        this.text = tip.getTipText();
        Rectangle vr = new Rectangle();
        Rectangle ir = new Rectangle();
        Rectangle tr = new Rectangle();
        Insets insets = tip.getInsets();
        FontMetrics fm = g.getFontMetrics(tip.getFont());
        SwingUtilities.layoutCompoundLabel(tip, fm, this.text, null, 0, 0, 0, 0, vr, ir, tr, 0);
        return new Dimension(insets.left + tr.width + insets.right, insets.top + tr.height + insets.bottom);
    }

    protected void installDefaults(JComponent c) {
        LookAndFeel.installColorsAndFont(c, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(c, "ToolTip.border");
    }

    protected void installListeners(JComponent c) {
    }

    public void installUI(JComponent c) {
        c.setOpaque(true);
        this.installDefaults(c);
        this.installListeners(c);
    }

    public void paint(Graphics g, JComponent c) {
        JToolTip tip = (JToolTip)c;
        String text = tip.getTipText();
        Toolkit t = tip.getToolkit();
        if (text == null) {
            return;
        }
        Rectangle vr = new Rectangle();
        vr = SwingUtilities.calculateInnerArea(tip, vr);
        Rectangle ir = new Rectangle();
        Rectangle tr = new Rectangle();
        FontMetrics fm = t.getFontMetrics(tip.getFont());
        int ascent = fm.getAscent();
        SwingUtilities.layoutCompoundLabel(tip, fm, text, null, 0, 0, 0, 0, vr, ir, tr, 0);
        Color saved = g.getColor();
        g.setColor(Color.BLACK);
        g.drawString(text, vr.x, vr.y + ascent);
        g.setColor(saved);
    }

    protected void uninstallDefaults(JComponent c) {
        c.setForeground(null);
        c.setBackground(null);
        c.setFont(null);
        c.setBorder(null);
    }

    protected void uninstallListeners(JComponent c) {
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults(c);
        this.uninstallListeners(c);
    }
}

