/**
 * Request actions.
 *
 * @module     tool_dataprivacy/data_registry
 * @copyright  2018 David Monllao
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_dataprivacy/data_registry",["jquery","core/str","core/ajax","core/notification","core/templates","core/fragment","tool_dataprivacy/add_purpose","tool_dataprivacy/add_category"],(function($,Str,Ajax,Notification,Templates,Fragment,AddPurpose,AddCategory){var SELECTORS_TREE_NODES="[data-context-tree-node=1]",SELECTORS_FORM_CONTAINER="#context-form-container",DataRegistry=function(systemContextId,initContextLevel,initContextId){this.systemContextId=systemContextId,this.currentContextLevel=initContextLevel,this.currentContextId=initContextId,this.init()};return DataRegistry.prototype.systemContextId=0,DataRegistry.prototype.currentContextLevel=0,DataRegistry.prototype.currentContextId=0,DataRegistry.prototype.addpurpose=null,DataRegistry.prototype.addcategory=null,DataRegistry.prototype.init=function(){this.addpurpose=AddPurpose.getInstance(this.systemContextId),this.addcategory=AddCategory.getInstance(this.systemContextId);this.strings=Str.get_strings([{key:"changessaved",component:"moodle"},{key:"contextpurposecategorysaved",component:"tool_dataprivacy"},{key:"noblockstoload",component:"tool_dataprivacy"},{key:"noactivitiestoload",component:"tool_dataprivacy"},{key:"nocoursestoload",component:"tool_dataprivacy"}]),this.registerEventListeners(),this.currentContextId?this.loadForm("context_form",[this.currentContextId],this.submitContextFormAjax.bind(this)):this.loadForm("contextlevel_form",[this.currentContextLevel],this.submitContextLevelFormAjax.bind(this))},DataRegistry.prototype.registerEventListeners=function(){$(SELECTORS_TREE_NODES).on("click",function(ev){ev.preventDefault();var trigger=$(ev.currentTarget);$(SELECTORS_TREE_NODES).removeClass("active"),trigger.addClass("active");var contextLevel=trigger.data("contextlevel"),contextId=trigger.data("contextid");if(contextLevel)window.history.pushState({},null,"?contextlevel="+contextLevel),this.addpurpose.removeListeners(),this.addcategory.removeListeners(),this.currentContextLevel=contextLevel,this.loadForm("contextlevel_form",[this.currentContextLevel],this.submitContextLevelFormAjax.bind(this));else if(contextId)window.history.pushState({},null,"?contextid="+contextId),this.addpurpose.removeListeners(),this.addcategory.removeListeners(),this.currentContextId=contextId,this.loadForm("context_form",[this.currentContextId],this.submitContextFormAjax.bind(this));else{var expandContextId=trigger.data("expandcontextid"),expandElement=trigger.data("expandelement"),expanded=trigger.data("expanded");expandElement&&(expanded?this.collapse(trigger):!trigger.data("loaded")&&expandContextId&&expandElement?(trigger.find("> i").removeClass("fa-plus"),trigger.find("> i").addClass("fa-circle-o-notch fa-spin"),this.loadExtra(trigger,expandContextId,expandElement)):this.expand(trigger))}}.bind(this))},DataRegistry.prototype.removeListeners=function(){$(SELECTORS_TREE_NODES).off("click")},DataRegistry.prototype.loadForm=function(fragmentName,fragmentArgs,formSubmitCallback){this.clearForm(),Fragment.loadFragment("tool_dataprivacy",fragmentName,this.systemContextId,fragmentArgs).done(function(html,js){$(SELECTORS_FORM_CONTAINER).html(html),Templates.runTemplateJS(js),this.addpurpose.registerEventListeners(),this.addcategory.registerEventListeners(),$(SELECTORS_FORM_CONTAINER).on("submit","form",formSubmitCallback)}.bind(this)).fail(Notification.exception)},DataRegistry.prototype.clearForm=function(){$(SELECTORS_FORM_CONTAINER).off("submit","form")},DataRegistry.prototype.submitForm=function(e){e.preventDefault(),$(SELECTORS_FORM_CONTAINER).find("form").submit()},DataRegistry.prototype.submitContextLevelFormAjax=function(e){this.submitFormAjax(e,"tool_dataprivacy_set_contextlevel_form")},DataRegistry.prototype.submitContextFormAjax=function(e){this.submitFormAjax(e,"tool_dataprivacy_set_context_form")},DataRegistry.prototype.submitFormAjax=function(e,saveMethodName){e.preventDefault();var formData=$(SELECTORS_FORM_CONTAINER).find("form").serialize();return this.strings.then((function(strings){Ajax.call([{methodname:saveMethodName,args:{jsonformdata:JSON.stringify(formData)},done:function(){Notification.alert(strings[0],strings[1])},fail:Notification.exception}])})).catch(Notification.exception)},DataRegistry.prototype.loadExtra=function(parentNode,expandContextId,expandElement){Ajax.call([{methodname:"tool_dataprivacy_tree_extra_branches",args:{contextid:expandContextId,element:expandElement},done:function(data){0!=data.branches.length?Templates.render("tool_dataprivacy/context_tree_branches",data).then(function(html){parentNode.after(html),this.removeListeners(),this.registerEventListeners(),this.expand(parentNode),parentNode.data("loaded",1)}.bind(this)).fail(Notification.exception):this.noElements(parentNode,expandElement)}.bind(this),fail:Notification.exception}])},DataRegistry.prototype.noElements=function(node,expandElement){node.data("expandcontextid",""),node.data("expandelement",""),this.strings.then((function(strings){var key=2;"module"==expandElement?key=3:"course"==expandElement&&(key=4),node.text(strings[key])})).fail(Notification.exception)},DataRegistry.prototype.collapse=function(node){node.data("expanded",0),node.siblings("nav").addClass("hidden"),node.find("> i").removeClass("fa-minus"),node.find("> i").addClass("fa-plus")},DataRegistry.prototype.expand=function(node){node.data("expanded",1),node.siblings("nav").removeClass("hidden"),node.find("> i").removeClass("fa-plus"),node.find("> i").removeClass("fa-circle-o-notch fa-spin"),node.find("> i").addClass("fa-minus")},{init:function(systemContextId,initContextLevel,initContextId){return new DataRegistry(systemContextId,initContextLevel,initContextId)}}}));

//# sourceMappingURL=data_registry.min.js.map