# GET METHOD
require "error.pl";
require "listdir.pl";
require "http1.pl";

sub isCode
{
	if (!$code_enable) { return 0; }
	foreach $i (@code_ext)
	{
		if ("$ENV{FILETYPE}" eq "$code_ext[$i]")
		{
			return 1;
		}
	}
	return 0;
}

sub isXSLT
{
	if (!$xslt_enable) { return 0; }
	if (mimeType($ENV{FILETYPE}) eq "text/xml")
		{ return 1; }
	else 	{ return 0; }
}

sub isX
{
	($file)=@_;
	if (!$x_enable) { return 0; }
	if ($ENV{FILETYPE} eq "x")
	{
	if (! -x $file ) 
		{ 
		print "Cannot exec $ENV{FILE}\n"; 
		return 0; 
		}
	} else { return 0; }
	return 1;
}

sub printBuffer
{
	my ($buf,$head)=@_;
	my $buflen=0;

	$buflen=length($buf);
	if ($head==1)
	{
		$buflen-=index($buf,"\r\n\r\n");
		$buflen-=4; # 666
		if ($buflen<0) { $buflen=0; }
	}

	if ($buf=~/Status: (.*)\r\n/) # XXX check that is in header section
	{
		$code=$1;
	}
	if (! ($buf=~/Content-type: /))
		{ $head=0; }

	if ("$ENV{HTTP}"=~/1\../)
		{ printHeader($code,$buflen,$head); }

	if ($head == 0)
		{ print "\r\n"; }

	print $buf;
}

sub readFile
{
	my $file;
	my $buf="";
	my $head=0; # no headers by default
	($file)=@_;
	# Sanitize
	$file=~s/\|/\\\|/g;
	$file=~s/`//g;
	$file=~s/\/\//\//g;
	# Print File
	if ( $hsml_enable == 1 && (
		"$ENV{FILETYPE}" eq "hsml" ||
		"$ENV{FILETYPE}" eq "html" )) # XXX This could make slowly the process.
	{
		$hsml=~s/\n//; # whereis output cleaner! 
		if ( -e "$hsml" )
		{
			$head=1;
			$buf=`$hsml $hsml_flags "$file"`;
		} else {
			$buf="Program '$hsml' not found.\n";
		}
	} elsif ( $php_enable == 1 &&
			"$ENV{FILETYPE}" eq "php") {
		# Parse arguments
		foreach $key (keys %ENV)
		{
			if ($key=~/^ARG_/)
			{
				$tmp=$key;
				$tmp=~s/^ARG_//g;
				$ENV{$tmp}=$ENV{$key};
			}
		}
		$buf=`$php "$file"`;
		if ("$buf" eq "")
			{ $buf="Internal error: Cannot find php bin '$php'."; }
	} elsif (isCode()) {
		$head=1;
		$buf="Content-type: text/html; charset=iso-8859-1\r\n\r\n";
		$buf.=`$code_prg $file`;
		if ("$buf" eq "")
			{ $buf="Internal error: Cannot find code highlighting bin: '$code_prg'"; }
	} elsif (isXSLT()) {
		$buf=`$xslt_prg $file`;
		if ("$buf" eq "")
		   { $buf="Internal error: Cannot find xsltproc: '$xslt_prg'"; }
	} elsif (isX($file)) {
		$head=1;
		$buf=`$file`;
		if ( ! ($buf=~/Content-type: /i) )
		{
			$buf="Content-type: text/html\r\n\r\n".$buf;
		}
	} else {
		# USE NonBuffered printing
		$BUFSIZE=8192; ## MUST BE TCPWINSIZE
		open F, $file || return 0;
		binmode F;
		seek F,0,2;
		$fsize=tell(F);
		seek F,0,0; ## XXX THIS IS UGLY CODE! SOLVE!!
		printHeader($code,$fsize,0);
		print "\r\n";
		for($i=0;$i<$fsize;$i+=$BUFSIZE)
		{
			read F,$buf,$BUFSIZE;
			print $buf;
		}
		close F;
		return;
	}
	printBuffer($buf,$head);
}

sub fileCode
{
	$file="$htdocs";
	if ( -d "$file/$ENV{FILE}" ) 
	   {  
		$found=0;
		foreach $i (@indexes)
		{
			if ( -e "$file/$ENV{FILE}/$i" )
			{
			$file.="$ENV{FILE}/$i";
			$file=~/.*\.(.*)$/;
			$ENV{FILETYPE}=$1;
			$found=1;
			last;
			}
		}
		if (!$found)
			{
			return "DIR";
			}
	   }
	else { $file.="$ENV{FILE}"; }
	if ( -e "$file" )
	{
		foreach $exp (@forbidden)
		{
			if ($ENV{FILE}=~/$exp/)
			{
			return "403";
			}
		}
		return "200";
	} else {
		$ENV{FILETYPE}="text/html";
		return "404";
	}
}

sub method_get
{
	$code=fileCode();
	
	if ($code eq "200") # file found
	{
		readFile("$file");
	} elsif ($code eq "DIR") { # directory listing
		$dir="$file/$ENV{FILE}";
		$dir=~s/\/\//\//g;
		listDirectory($dir);
	} elsif ($code eq "403") {
		readFile(getError("403",1));
	} else {  # file not found
		readFile(getError("404",1));
	}
}

return 1;
