/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");
XPCOMUtils.defineLazyModuleGetter(this, "Services", "resource://gre/modules/Services.jsm");

this.EXPORTED_SYMBOLS = ["AppConstants"];

// Immutable for export.
this.AppConstants = Object.freeze({
  // See this wiki page for more details about channel specific build
  // defines: https://wiki.mozilla.org/Platform/Channel-specific_build_defines
  NIGHTLY_BUILD:
//@line 22 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 24 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  RELEASE_OR_BETA:
//@line 27 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  true,
//@line 31 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  ACCESSIBILITY:
//@line 34 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  true,
//@line 38 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  // Official corresponds, roughly, to whether this build is performed
  // on Mozilla's continuous integration infrastructure. You should
  // disable developer-only functionality when this flag is set.
  MOZILLA_OFFICIAL:
//@line 46 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 48 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_OFFICIAL_BRANDING:
//@line 53 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 55 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_DEV_EDITION:
//@line 60 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 62 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_HEALTHREPORT:
//@line 65 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  true,
//@line 69 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_DATA_REPORTING:
//@line 72 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  true,
//@line 76 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_SANDBOX:
//@line 81 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 83 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_CONTENT_SANDBOX:
//@line 88 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 90 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_REPORTING:
//@line 95 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 97 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_ON_BY_DEFAULT:
//@line 102 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 104 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_CLOUDSYNC:
//@line 107 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  true,
//@line 111 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_UPDATER:
//@line 116 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 118 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_SWITCHBOARD:
//@line 123 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 125 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_WEBRTC:
//@line 130 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 132 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_WIDGET_GTK:
//@line 135 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  true,
//@line 139 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

//@line 141 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  MOZ_B2G:
//@line 145 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 147 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  XP_UNIX:
//@line 150 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  true,
//@line 154 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

//@line 157 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  platform:
//@line 159 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  "linux",
//@line 173 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  isPlatformAndVersionAtLeast(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) >= 0;
  },

  isPlatformAndVersionAtMost(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) <= 0;
  },

  MOZ_CRASHREPORTER:
//@line 190 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 192 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_VERIFY_MAR_SIGNATURE:
//@line 197 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 199 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_MAINTENANCE_SERVICE:
//@line 204 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 206 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  E10S_TESTING_ONLY:
//@line 211 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 213 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  DEBUG:
//@line 218 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 220 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  ASAN:
//@line 225 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 227 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_B2G_RIL:
//@line 232 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 234 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_GRAPHENE:
//@line 239 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 241 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_SYSTEM_NSS:
//@line 244 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  true,
//@line 248 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_PLACES:
//@line 251 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  true,
//@line 255 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_REQUIRE_SIGNING:
//@line 260 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 262 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MENUBAR_CAN_AUTOHIDE:
//@line 265 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  true,
//@line 269 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  CAN_DRAW_IN_TITLEBAR:
//@line 274 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 276 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_ANDROID_HISTORY:
//@line 281 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 283 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_TOOLKIT_SEARCH:
//@line 286 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  true,
//@line 290 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_ENABLE_PROFILER_SPS:
//@line 295 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 297 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_ANDROID_ACTIVITY_STREAM:
//@line 302 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 304 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  DLL_PREFIX: "lib",
  DLL_SUFFIX: ".so",

  MOZ_APP_NAME: "firefox",
  MOZ_APP_VERSION: "52.9.0",
  MOZ_APP_VERSION_DISPLAY: "52.9.0",
  MOZ_BUILD_APP: "browser",
  MOZ_MACBUNDLE_NAME: "Nightly.app",
  MOZ_UPDATE_CHANNEL: "default",
  INSTALL_LOCALE: "en-US",
  MOZ_WIDGET_TOOLKIT: "gtk3",
  ANDROID_PACKAGE_NAME: "org.mozilla.firefox",
  MOZ_B2G_VERSION: "1.0.0",
  MOZ_B2G_OS_NAME: "",

  DEBUG_JS_MODULES: "",

  // URL to the hg revision this was built from (e.g.
  // "https://hg.mozilla.org/mozilla-central/rev/6256ec9113c1")
  // On unofficial builds, this is an empty string.
//@line 328 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
  SOURCE_REVISION_URL: "",

  HAVE_USR_LIB64_DIR:
//@line 334 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
    false,
//@line 336 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"

  HAVE_SHELL_SERVICE:
//@line 339 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
    true,
//@line 343 "/tmp/pkgbuild/www/firefox52/work.alpha/firefox-52.9.0esr/toolkit/modules/AppConstants.jsm"
});
