require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_PMAP_MACHINE_)) {
    eval 'sub _PMAP_MACHINE_ () {1;}' unless defined(&_PMAP_MACHINE_);
    if(defined(&_KERNEL_OPT)) {
	require './alpha/opt_multiprocessor.ph';
    }
    require 'sys/param.ph';
    require 'sys/types.ph';
    require 'sys/mutex.ph';
    require 'sys/queue.ph';
    require 'machine/pte.ph';
    eval 'sub PMAP_SIZEOF {
        my($x) = @_;
	    eval q(( &ALIGN( &offsetof(\'struct pmap\',  $pm_percpu[($x)]))));
    }' unless defined(&PMAP_SIZEOF);
    eval 'sub PMAP_ASN_KERNEL () {0;}' unless defined(&PMAP_ASN_KERNEL);
    eval 'sub PMAP_ASN_FIRST_USER () {1;}' unless defined(&PMAP_ASN_FIRST_USER);
    eval 'sub PMAP_ASNGEN_INVALID () {0;}' unless defined(&PMAP_ASNGEN_INVALID);
    eval 'sub PMAP_ASNGEN_INITIAL () {1;}' unless defined(&PMAP_ASNGEN_INITIAL);
    eval 'sub PGA_MODIFIED () {0x1;}' unless defined(&PGA_MODIFIED);
    eval 'sub PGA_REFERENCED () {0x2;}' unless defined(&PGA_REFERENCED);
    eval 'sub PGA_ATTRS () {( &PGA_MODIFIED |  &PGA_REFERENCED);}' unless defined(&PGA_ATTRS);
    eval 'sub PGU_NORMAL () {0;}' unless defined(&PGU_NORMAL);
    eval 'sub PGU_PVENT () {1;}' unless defined(&PGU_PVENT);
    eval 'sub PGU_L1PT () {2;}' unless defined(&PGU_L1PT);
    eval 'sub PGU_L2PT () {3;}' unless defined(&PGU_L2PT);
    eval 'sub PGU_L3PT () {4;}' unless defined(&PGU_L3PT);
    if(defined(&_KERNEL)) {
	require 'sys/atomic.ph';
	if(defined(&MULTIPROCESSOR)) {
	}
	eval 'sub pmap_resident_count {
	    my($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{resident_count})));
	}' unless defined(&pmap_resident_count);
	eval 'sub pmap_wired_count {
	    my($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{wired_count})));
	}' unless defined(&pmap_wired_count);
	eval 'sub pmap_copy {
	    my($dp, $sp, $da, $l, $sa) = @_;
    	    eval q();
	}' unless defined(&pmap_copy);
	eval 'sub pmap_update {
	    my($pmap) = @_;
    	    eval q();
	}' unless defined(&pmap_update);
	eval 'sub pmap_is_referenced {
	    my($pg) = @_;
    	    eval q(((($pg)-> ($mdpage->{pvh_listx}) &  &PGA_REFERENCED) != 0));
	}' unless defined(&pmap_is_referenced);
	eval 'sub pmap_is_modified {
	    my($pg) = @_;
    	    eval q(((($pg)-> ($mdpage->{pvh_listx}) &  &PGA_MODIFIED) != 0));
	}' unless defined(&pmap_is_modified);
	eval 'sub PMAP_STEAL_MEMORY () {1;}' unless defined(&PMAP_STEAL_MEMORY);
	eval 'sub PMAP_GROWKERNEL () {1;}' unless defined(&PMAP_GROWKERNEL);
	eval 'sub PMAP_DIRECT () {1;}' unless defined(&PMAP_DIRECT);
	eval 'sub PMAP_DIRECT_MAP {
	    my($pa) = @_;
    	    eval q( &ALPHA_PHYS_TO_K0SEG(($pa)));
	}' unless defined(&PMAP_DIRECT_MAP);
	eval 'sub PMAP_DIRECT_UNMAP {
	    my($va) = @_;
    	    eval q( &ALPHA_K0SEG_TO_PHYS(($va)));
	}' unless defined(&PMAP_DIRECT_UNMAP);
	eval 'sub pmap_direct_process () {
	    eval q(( &paddr_t  &pa,  &voff_t  &pgoff, \'size_t\'  &len,  &int (* &process)( &void *, \'size_t\',  &void *),  &void * &arg) {  &vaddr_t  &va =  &PMAP_DIRECT_MAP( &pa);  &process(( &void *)( &va +  &pgoff),  &len,  &arg); });
	}' unless defined(&pmap_direct_process);
	eval 'sub PMAP_MAP_POOLPAGE {
	    my($pa) = @_;
    	    eval q( &PMAP_DIRECT_MAP($pa));
	}' unless defined(&PMAP_MAP_POOLPAGE);
	eval 'sub PMAP_UNMAP_POOLPAGE {
	    my($va) = @_;
    	    eval q( &PMAP_DIRECT_UNMAP($va));
	}' unless defined(&PMAP_UNMAP_POOLPAGE);
	eval 'sub POOL_VTOPHYS {
	    my($va) = @_;
    	    eval q( &ALPHA_K0SEG_TO_PHYS(( &vaddr_t) ($va)));
	}' unless defined(&POOL_VTOPHYS);
	eval 'sub PMAP_PAGEIDLEZERO {
	    my($pa) = @_;
    	    eval q( &pmap_pageidlezero(($pa)));
	}' unless defined(&PMAP_PAGEIDLEZERO);
	eval 'sub pmap_pte_pa {
	    my($pte) = @_;
    	    eval q(( &PG_PFNUM(*($pte)) <<  &PGSHIFT));
	}' unless defined(&pmap_pte_pa);
	eval 'sub pmap_pte_prot {
	    my($pte) = @_;
    	    eval q((*($pte) &  &PG_PROT));
	}' unless defined(&pmap_pte_prot);
	eval 'sub pmap_pte_w {
	    my($pte) = @_;
    	    eval q((*($pte) &  &PG_WIRED));
	}' unless defined(&pmap_pte_w);
	eval 'sub pmap_pte_v {
	    my($pte) = @_;
    	    eval q((*($pte) &  &PG_V));
	}' unless defined(&pmap_pte_v);
	eval 'sub pmap_pte_pv {
	    my($pte) = @_;
    	    eval q((*($pte) &  &PG_PVLIST));
	}' unless defined(&pmap_pte_pv);
	eval 'sub pmap_pte_asm {
	    my($pte) = @_;
    	    eval q((*($pte) &  &PG_ASM));
	}' unless defined(&pmap_pte_asm);
	eval 'sub pmap_pte_exec {
	    my($pte) = @_;
    	    eval q((*($pte) &  &PG_EXEC));
	}' unless defined(&pmap_pte_exec);
	eval 'sub pmap_pte_set_w {
	    my($pte, $v) = @_;
    	    eval q( &do {  &if ($v) *($pte) |=  &PG_WIRED;  &else *($pte) &= ~ &PG_WIRED; }  &while (0));
	}' unless defined(&pmap_pte_set_w);
	eval 'sub pmap_pte_w_chg {
	    my($pte, $nw) = @_;
    	    eval q((($nw) ^  &pmap_pte_w($pte)));
	}' unless defined(&pmap_pte_w_chg);
	eval 'sub pmap_pte_set_prot {
	    my($pte, $np) = @_;
    	    eval q( &do { *($pte) &= ~ &PG_PROT; *($pte) |= ($np); }  &while (0));
	}' unless defined(&pmap_pte_set_prot);
	eval 'sub pmap_pte_prot_chg {
	    my($pte, $np) = @_;
    	    eval q((($np) ^  &pmap_pte_prot($pte)));
	}' unless defined(&pmap_pte_prot_chg);
	eval 'sub pmap_lev1map {
	    my($pmap) = @_;
    	    eval q({  &if ( &__predict_false($pmap ==  &pmap_kernel())) {  &kernel_lev1map; }  ($pmap->{pm_percpu[&cpu_number()]}->{pmc_lev1map}); });
	}' unless defined(&pmap_lev1map);
	eval 'sub pmap_l1pte {
	    my($lev1map,$v) = @_;
    	    eval q({  &KASSERT($lev1map !=  &NULL); $lev1map->[ &l1pte_index($v)]; });
	}' unless defined(&pmap_l1pte);
	eval 'sub pmap_l2pte {
	    my($lev1map,$v,$l1pte) = @_;
    	    eval q({  &pt_entry_t * &lev2map;  &if ($l1pte ==  &NULL) { $l1pte =  &pmap_l1pte($lev1map, $v);  &if ( &pmap_pte_v($l1pte) == 0)  &NULL; }  &lev2map = ( &pt_entry_t *) &ALPHA_PHYS_TO_K0SEG( &pmap_pte_pa($l1pte));  $lev2map[ &l2pte_index($v)]; });
	}' unless defined(&pmap_l2pte);
	eval 'sub pmap_l3pte {
	    my($lev1map,$v,$l2pte) = @_;
    	    eval q({  &pt_entry_t * &l1pte, * &lev2map, * &lev3map;  &if ($l2pte ==  &NULL) {  &l1pte =  &pmap_l1pte($lev1map, $v);  &if ( &pmap_pte_v( &l1pte) == 0)  &NULL;  &lev2map = ( &pt_entry_t *) &ALPHA_PHYS_TO_K0SEG( &pmap_pte_pa( &l1pte)); $l2pte =  $lev2map[ &l2pte_index($v)];  &if ( &pmap_pte_v($l2pte) == 0)  &NULL; }  &lev3map = ( &pt_entry_t *) &ALPHA_PHYS_TO_K0SEG( &pmap_pte_pa($l2pte));  $lev3map[ &l3pte_index($v)]; });
	}' unless defined(&pmap_l3pte);
	eval 'sub PMAP_USERRET {
	    my($pmap) = @_;
    	    eval q( &do {  &const \'unsigned long cpu_id\' =  &cpu_number();  &if (($pmap)-> ($pm_percpu[&cpu_id]->{pmc_needisync})) { ($pmap)-> ($pm_percpu[&cpu_id]->{pmc_needisync}) = 0;  &alpha_pal_imb(); } }  &while (0));
	}' unless defined(&PMAP_USERRET);
	eval 'sub __HAVE_VM_PAGE_MD () {1;}' unless defined(&__HAVE_VM_PAGE_MD);
	eval 'sub PHYSPAGE_REFCNT {
	    my($pg) = @_;
    	    eval q( &atomic_load_relaxed(($pg)-> ($mdpage->{pvh_physpgrefs})));
	}' unless defined(&PHYSPAGE_REFCNT);
	eval 'sub PHYSPAGE_REFCNT_SET {
	    my($pg, $v) = @_;
    	    eval q( &atomic_store_relaxed(($pg)-> ($mdpage->{p$vh_physpgrefs}), ($v)));
	}' unless defined(&PHYSPAGE_REFCNT_SET);
	eval 'sub PHYSPAGE_REFCNT_INC {
	    my($pg) = @_;
    	    eval q( &atomic_inc_uint_nv(($pg)-> ($mdpage->{pvh_physpgrefs})));
	}' unless defined(&PHYSPAGE_REFCNT_INC);
	eval 'sub PHYSPAGE_REFCNT_DEC {
	    my($pg) = @_;
    	    eval q( &atomic_dec_uint_nv(($pg)-> ($mdpage->{pvh_physpgrefs})));
	}' unless defined(&PHYSPAGE_REFCNT_DEC);
	eval 'sub VM_MDPAGE_PVS {
	    my($pg) = @_;
    	    eval q(((($pg)-> ($mdpage->{pvh_listx}) & ~3)));
	}' unless defined(&VM_MDPAGE_PVS);
	eval 'sub VM_MDPAGE_INIT {
	    my($pg) = @_;
    	    eval q( &do { ($pg)-> ($mdpage->{pvh_listx}) = 0; }  &while ( 0));
	}' unless defined(&VM_MDPAGE_INIT);
    }
}
1;
