/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.javascript;

import com.sun.star.document.XScriptInvocationContext;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.reflection.InvocationTargetException;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ClassLoaderFactory;
import com.sun.star.script.framework.provider.ScriptContext;
import com.sun.star.script.provider.ScriptExceptionRaisedException;
import com.sun.star.script.provider.ScriptFrameworkErrorException;
import com.sun.star.script.provider.XScript;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.XComponentContext;
import java.net.MalformedURLException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

class ScriptImpl
implements XScript {
    private final ScriptMetaData metaData;
    private final XComponentContext m_xContext;
    private XMultiComponentFactory m_xMultiComponentFactory;
    private final XModel m_xModel;
    private final XScriptInvocationContext m_xInvocContext;

    ScriptImpl(XComponentContext xComponentContext, ScriptMetaData scriptMetaData, XModel xModel, XScriptInvocationContext xScriptInvocationContext) throws RuntimeException {
        this.metaData = scriptMetaData;
        this.m_xContext = xComponentContext;
        this.m_xModel = xModel;
        this.m_xInvocContext = xScriptInvocationContext;
        try {
            this.m_xMultiComponentFactory = this.m_xContext.getServiceManager();
        }
        catch (Exception exception) {
            throw new RuntimeException((Throwable)exception);
        }
        LogUtils.DEBUG("ScriptImpl [javascript] script data = " + scriptMetaData);
    }

    public Object invoke(Object[] objectArray, short[][] sArray, Object[][] objectArray2) throws ScriptFrameworkErrorException, InvocationTargetException {
        sArray[0] = new short[0];
        objectArray2[0] = new Object[0];
        ClassLoader classLoader = null;
        try {
            classLoader = ClassLoaderFactory.getURLClassLoader(this.metaData);
            this.metaData.getSourceURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new ScriptFrameworkErrorException(malformedURLException.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 3);
        }
        Context context = null;
        try {
            Object object = null;
            this.metaData.loadSource();
            String string = this.metaData.getSource();
            if (string == null || string.length() == 0) {
                throw new ScriptFrameworkErrorException("Failed to read source data for script", null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
            }
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            context = Context.enter();
            ImporterTopLevel importerTopLevel = new ImporterTopLevel(context);
            Scriptable scriptable = Context.toObject(ScriptContext.createContext(this.m_xModel, this.m_xInvocContext, this.m_xContext, this.m_xMultiComponentFactory), importerTopLevel);
            importerTopLevel.put("XSCRIPTCONTEXT", (Scriptable)importerTopLevel, (Object)scriptable);
            Scriptable scriptable2 = Context.toObject(objectArray, importerTopLevel);
            importerTopLevel.put("ARGUMENTS", (Scriptable)importerTopLevel, (Object)scriptable2);
            object = context.evaluateString(importerTopLevel, string, "<stdin>", 1, null);
            Object object2 = object = Context.toString(object);
            return object2;
        }
        catch (JavaScriptException javaScriptException) {
            LogUtils.DEBUG("Caught JavaScriptException exception for JavaScript type = " + javaScriptException.getClass());
            String string = javaScriptException.getMessage();
            Object object = javaScriptException.getValue();
            LogUtils.DEBUG("\t message  " + string);
            LogUtils.DEBUG("\t wrapped type " + object.getClass());
            LogUtils.DEBUG("\t wrapped toString  " + object.toString());
            ScriptExceptionRaisedException scriptExceptionRaisedException = new ScriptExceptionRaisedException(string);
            scriptExceptionRaisedException.lineNum = -1;
            scriptExceptionRaisedException.language = "JavaScript";
            scriptExceptionRaisedException.scriptName = this.metaData.getLanguageName();
            scriptExceptionRaisedException.exceptionType = object.getClass().getName();
            scriptExceptionRaisedException.language = this.metaData.getLanguage();
            LogUtils.DEBUG("ExceptionRaised exception  ");
            LogUtils.DEBUG("\t message  " + scriptExceptionRaisedException.getMessage());
            LogUtils.DEBUG("\t lineNum  " + scriptExceptionRaisedException.lineNum);
            LogUtils.DEBUG("\t language  " + scriptExceptionRaisedException.language);
            LogUtils.DEBUG("\t scriptName  " + scriptExceptionRaisedException.scriptName);
            throw new InvocationTargetException("JavaScript uncaught exception" + this.metaData.getLanguageName(), null, (Object)scriptExceptionRaisedException);
        }
        catch (Exception exception) {
            LogUtils.DEBUG("Caught Exception " + exception);
            LogUtils.DEBUG("rethrowing as ScriptFramework error");
            throw new ScriptFrameworkErrorException(exception.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
        }
        finally {
            if (context != null) {
                Context.exit();
            }
        }
    }
}

