/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.modules.java.hints.introduce.Flow;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class UnusedAssignmentOrBranch {
    private static final String UNUSED_ASSIGNMENT_ID = "org.netbeans.modules.java.hints.bugs.UnusedAssignmentOrBranch.unusedAssignment";
    private static final String DEAD_BRANCH_ID = "org.netbeans.modules.java.hints.bugs.UnusedAssignmentOrBranch.deadBranch";
    private static final Object KEY_COMPUTED_ASSIGNMENTS = new Object();
    private static final Set<ElementKind> LOCAL_VARIABLES = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);

    private static Pair<Set<Tree>, Set<Element>> computeUsedAssignments(final HintContext ctx) {
        final CompilationInfo info = ctx.getInfo();
        Pair result = (Pair)info.getCachedValue(KEY_COMPUTED_ASSIGNMENTS);
        if (result != null) {
            return result;
        }
        Flow.FlowResult flow = Flow.assignmentsForUse(ctx);
        if (flow == null) {
            return null;
        }
        final HashSet<Tree> usedAssignments = new HashSet<Tree>();
        for (Iterable<? extends TreePath> i : flow.getAssignmentsForUse().values()) {
            for (TreePath treePath : i) {
                if (treePath == null) continue;
                usedAssignments.add(treePath.getLeaf());
            }
        }
        final HashSet usedVariables = new HashSet();
        new CancellableTreePathScanner<Void, Void>(){

            public Void visitAssignment(AssignmentTree node, Void p) {
                Element var = info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
                if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind()) && !usedAssignments.contains(node.getExpression())) {
                    this.scan(node.getExpression(), null);
                    return null;
                }
                return (Void)super.visitAssignment(node, (Object)p);
            }

            public Void visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
                Element var = info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
                if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind()) && !usedAssignments.contains(node.getExpression())) {
                    this.scan(node.getExpression(), null);
                    return null;
                }
                return (Void)super.visitCompoundAssignment(node, (Object)p);
            }

            public Void visitIdentifier(IdentifierTree node, Void p) {
                Element var = info.getTrees().getElement(this.getCurrentPath());
                if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind())) {
                    usedVariables.add(var);
                }
                return (Void)super.visitIdentifier(node, (Object)p);
            }

            protected boolean isCanceled() {
                return ctx.isCanceled();
            }
        }.scan((Tree)info.getCompilationUnit(), null);
        result = Pair.of(usedAssignments, usedVariables);
        info.putCachedValue(KEY_COMPUTED_ASSIGNMENTS, (Object)result, CompilationInfo.CacheClearPolicy.ON_TASK_END);
        return result;
    }

    public static ErrorDescription unusedAssignment(HintContext ctx) {
        String unusedAssignmentLabel = NbBundle.getMessage(UnusedAssignmentOrBranch.class, (String)"LBL_UNUSED_ASSIGNMENT_LABEL");
        Pair<Set<Tree>, Set<Element>> computedAssignments = UnusedAssignmentOrBranch.computeUsedAssignments(ctx);
        if (ctx.isCanceled() || computedAssignments == null) {
            return null;
        }
        CompilationInfo info = ctx.getInfo();
        Set usedAssignments = (Set)computedAssignments.first();
        Set usedVariables = (Set)computedAssignments.second();
        Element var = info.getTrees().getElement((TreePath)ctx.getVariables().get("$var"));
        Tree value = ((TreePath)ctx.getVariables().get("$value")).getLeaf();
        if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind()) && !usedAssignments.contains(value) && usedVariables.contains(var)) {
            return ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)value, (String)unusedAssignmentLabel, (Fix[])new Fix[0]);
        }
        return null;
    }

    public static List<ErrorDescription> deadBranch(HintContext ctx) {
        StatementTree t;
        IfTree it;
        String deadBranchLabel = NbBundle.getMessage(UnusedAssignmentOrBranch.class, (String)"LBL_DEAD_BRANCH");
        Flow.FlowResult flow = Flow.assignmentsForUse(ctx);
        if (flow == null) {
            return null;
        }
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        Set<? extends Tree> flowResult = flow.getDeadBranches();
        if (flowResult.contains((it = (IfTree)ctx.getPath().getLeaf()).getThenStatement())) {
            result.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)it.getThenStatement(), (String)deadBranchLabel, (Fix[])new Fix[0]));
        }
        if (flowResult.contains(t = it.getElseStatement())) {
            result.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)t, (String)deadBranchLabel, (Fix[])new Fix[0]));
            while (t != null && t.getKind() == Tree.Kind.IF) {
                it = (IfTree)t;
                t = it.getElseStatement();
                result.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)t, (String)deadBranchLabel, (Fix[])new Fix[0]));
            }
        }
        return result;
    }
}

