/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.ChangeMethodReturnType;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class MissingReturnStatement
implements ErrorRule<Void> {
    private static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.err.missing.ret.stmt", "compiler.err.prob.found.req/compiler.misc.incompatible.ret.type.in.lambda/compiler.misc.missing.ret.val", "compiler.err.prob.found.req/compiler.misc.incompatible.ret.type.in.lambda/compiler.misc.inconvertible.types"));

    public Set<String> getCodes() {
        return CODES;
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        TreePath tp;
        TreePath method = null;
        if (diagnosticKey != null && diagnosticKey.contains("/compiler.misc.incompatible.ret.type.in.lambda/")) {
            ++offset;
        }
        for (tp = compilationInfo.getTreeUtilities().pathFor(offset); tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()); tp = tp.getParentPath()) {
            Tree.Kind kind = tp.getLeaf().getKind();
            if (kind != Tree.Kind.METHOD && kind != Tree.Kind.LAMBDA_EXPRESSION) continue;
            method = tp;
            break;
        }
        if (method == null) {
            return null;
        }
        if (method.getLeaf().getKind() == Tree.Kind.METHOD) {
            MethodTree mt = (MethodTree)tp.getLeaf();
            if (mt.getReturnType() == null) {
                return null;
            }
        } else if (method.getLeaf().getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
            LambdaExpressionTree let = (LambdaExpressionTree)method.getLeaf();
            TreePath bodyPath = new TreePath(method, let.getBody());
            if (let.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                TypeMirror m = compilationInfo.getTrees().getTypeMirror(bodyPath);
                if (m == null) {
                    return null;
                }
                if (m.getKind() == TypeKind.ERROR) {
                    m = compilationInfo.getTrees().getOriginalType((ErrorType)m);
                }
                if (m.getKind() != TypeKind.VOID) {
                    return null;
                }
            } else if (Utilities.exitsFromAllBranchers(compilationInfo, bodyPath)) {
                return null;
            }
        }
        ArrayList<Fix> result = new ArrayList<Fix>(2);
        result.add(new FixImpl(compilationInfo.getSnapshot().getSource(), TreePathHandle.create((TreePath)tp, (CompilationInfo)compilationInfo)));
        if (method.getLeaf().getKind() == Tree.Kind.METHOD) {
            result.add(new ChangeMethodReturnType.FixImpl(compilationInfo, tp, TypeMirrorHandle.create((TypeMirror)compilationInfo.getTypes().getNoType(TypeKind.VOID)), "void").toEditorFix());
        }
        return result;
    }

    public String getId() {
        return MissingReturnStatement.class.getCanonicalName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(MissingReturnStatement.class, (String)"DN_MissingReturnStatement");
    }

    public void cancel() {
    }

    private static final class FixImpl
    implements Fix {
        private final Source source;
        private final TreePathHandle methodHandle;

        public FixImpl(Source source, TreePathHandle methodHandle) {
            this.source = source;
            this.methodHandle = methodHandle;
        }

        public String getText() {
            return NbBundle.getMessage(MissingReturnStatement.class, (String)"FIX_AddReturnStatement");
        }

        public ChangeInfo implement() throws Exception {
            ModificationResult mr = ModificationResult.runModificationTask(Collections.singleton(this.source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    TypeMirror type;
                    BlockTree body;
                    WorkingCopy wc = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath method = methodHandle.resolve((CompilationInfo)wc);
                    TreeMaker make = wc.getTreeMaker();
                    if (method.getLeaf().getKind() == Tree.Kind.METHOD) {
                        Element methodEl;
                        Element element = methodEl = method != null ? wc.getTrees().getElement(method) : null;
                        if (methodEl == null || methodEl.getKind() != ElementKind.METHOD) {
                            return;
                        }
                        assert (method.getLeaf().getKind() == Tree.Kind.METHOD);
                        body = ((MethodTree)method.getLeaf()).getBody();
                        if (body == null) {
                            return;
                        }
                        type = ((ExecutableElement)methodEl).getReturnType();
                    } else if (method.getLeaf().getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
                        LambdaExpressionTree let = (LambdaExpressionTree)method.getLeaf();
                        if (let.getBody() == null) {
                            return;
                        }
                        if (let.getBody().getKind() == Tree.Kind.BLOCK) {
                            body = (BlockTree)let.getBody();
                        } else if (let.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                            body = make.Block(Collections.singletonList(make.ExpressionStatement((ExpressionTree)let.getBody())), false);
                            wc.rewrite(let.getBody(), (Tree)body);
                        } else {
                            body = make.Block(Collections.singletonList((StatementTree)let.getBody()), false);
                            wc.rewrite(let.getBody(), (Tree)body);
                        }
                        TypeMirror t = wc.getTrees().getTypeMirror(method);
                        if (t == null || t.getKind() != TypeKind.DECLARED) {
                            return;
                        }
                        ExecutableType et = wc.getTypeUtilities().getDescriptorType((DeclaredType)t);
                        if (!Utilities.isValidType(et)) {
                            return;
                        }
                        type = et.getReturnType();
                    } else {
                        return;
                    }
                    TypeKind kind = type.getKind();
                    Comparable<Boolean> value = kind.isPrimitive() ? (kind == TypeKind.BOOLEAN ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0)) : null;
                    LiteralTree nullValue = make.Literal(value);
                    wc.tag((Tree)nullValue, (Object)"select");
                    wc.rewrite((Tree)body, (Tree)make.addBlockStatement(body, (StatementTree)make.Return((ExpressionTree)nullValue)));
                }
            });
            return Utilities.commitAndComputeChangeInfo(this.source.getFileObject(), mr);
        }
    }
}

