/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.GitRef;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.Utils;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.TransportCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class ListRemoteBranchesCommand
extends TransportCommand {
    private LinkedHashMap<String, GitBranch> remoteBranches;
    private final String remoteUrl;
    private Collection<GitRef> refs;
    private final ProgressMonitor monitor;

    public ListRemoteBranchesCommand(JGitRepository repository, GitClassFactory gitFactory, String remoteRepositoryUrl, ProgressMonitor monitor) {
        super(repository, gitFactory, remoteRepositoryUrl, monitor);
        this.remoteUrl = remoteRepositoryUrl;
        this.monitor = monitor;
    }

    public Map<String, GitBranch> getBranches() {
        return this.remoteBranches;
    }

    private void processRefs() {
        this.remoteBranches = new LinkedHashMap();
        this.remoteBranches.putAll(Utils.refsToBranches(this.refs, "refs/heads/", this.getClassFactory()));
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "ls-remote");
        this.addArgument(0, "--heads");
        this.addArgument(0, this.remoteUrl);
    }

    @Override
    protected final void runTransportCommand() throws GitException {
        block4: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                this.refs = new ArrayList<GitRef>();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        ListRemoteBranchesCommand.this.parseListBranchesOutput(output);
                    }
                }.runCLI();
                this.processRefs();
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block4;
                throw new GitException(t);
            }
        }
    }

    private void parseListBranchesOutput(String output) {
        for (String line : output.split("\n")) {
            String[] s = line.split("\\s");
            if (s.length < 2) continue;
            String revision = s[0];
            String name = s[1];
            this.refs.add(new GitRef(name, revision));
        }
    }
}

