/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.HashSet;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.Utils;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.FileListener;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class RemoveCommand
extends GitCommand {
    public static final boolean KIT = false;
    private final VCSFileProxy[] roots;
    private final FileListener listener;
    private final ProgressMonitor monitor;
    private final boolean cached;

    public RemoveCommand(JGitRepository repository, GitClassFactory gitFactory, VCSFileProxy[] roots, boolean cached, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.listener = listener;
        this.monitor = monitor;
        this.cached = cached;
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean retval = super.prepareCommand();
        if (retval && this.roots.length == 0) {
            retval = false;
            this.monitor.notifyWarning(EMPTY_ROOTS);
        }
        return retval;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "rm");
        this.addArgument(0, "--ignore-unmatch");
        this.addArgument(0, "-r");
        if (this.cached) {
            this.addArgument(0, "--cached");
        } else {
            this.addArgument(0, "--force");
        }
        this.addArgument(0, "--");
        this.addFiles(0, this.roots);
    }

    @Override
    protected void run() throws GitException {
        block6: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        RemoveCommand.this.parseRemoveOutput(output);
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        super.errorParser(error);
                    }
                }.runCLI();
                if (!this.cached) {
                    for (VCSFileProxy root : this.roots) {
                        VCSFileProxySupport.delete((VCSFileProxy)root);
                    }
                }
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block6;
                throw new GitException(t);
            }
        }
    }

    private void parseRemoveOutput(String output) {
        HashSet<VCSFileProxy> parents = new HashSet<VCSFileProxy>();
        for (String line : output.split("\n")) {
            if (!(line = line.trim()).startsWith("rm '") || !line.endsWith("'")) continue;
            String file = line.substring(4, line.length() - 1);
            VCSFileProxy path = VCSFileProxy.createFileProxy((VCSFileProxy)this.getRepository().getLocation(), (String)file);
            if (file.indexOf(47) > 0) {
                parents.add(path.getParentFile());
            }
            this.listener.notifyFile(path, file);
        }
        for (VCSFileProxy parent : parents) {
            if (parent.exists()) continue;
            this.listener.notifyFile(parent, Utils.getRelativePath(this.getRepository().getLocation(), parent));
        }
    }
}

