/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.ExportNode;
import com.oracle.js.parser.ir.ImportNode;
import java.util.List;

public final class Module {
    public static final String DEFAULT_EXPORT_BINDING_NAME = "*default*";
    public static final String DEFAULT_NAME = "default";
    public static final String STAR_NAME = "*";
    private final List<String> requestedModules;
    private final List<ImportEntry> importEntries;
    private final List<ExportEntry> localExportEntries;
    private final List<ExportEntry> indirectExportEntries;
    private final List<ExportEntry> starExportEntries;
    private final List<ImportNode> imports;
    private final List<ExportNode> exports;

    public Module(List<String> requestedModules, List<ImportEntry> importEntries, List<ExportEntry> localExportEntries, List<ExportEntry> indirectExportEntries, List<ExportEntry> starExportEntries, List<ImportNode> imports, List<ExportNode> exports) {
        this.requestedModules = requestedModules;
        this.importEntries = importEntries;
        this.localExportEntries = localExportEntries;
        this.indirectExportEntries = indirectExportEntries;
        this.starExportEntries = starExportEntries;
        this.imports = imports;
        this.exports = exports;
    }

    public List<String> getRequestedModules() {
        return this.requestedModules;
    }

    public List<ImportEntry> getImportEntries() {
        return this.importEntries;
    }

    public List<ExportEntry> getLocalExportEntries() {
        return this.localExportEntries;
    }

    public List<ExportEntry> getIndirectExportEntries() {
        return this.indirectExportEntries;
    }

    public List<ExportEntry> getStarExportEntries() {
        return this.starExportEntries;
    }

    public List<ImportNode> getImports() {
        return this.imports;
    }

    public List<ExportNode> getExports() {
        return this.exports;
    }

    public String toString() {
        return "Module [requestedModules=" + this.requestedModules + ", importEntries=" + this.importEntries + ", localExportEntries=" + this.localExportEntries + ", indirectExportEntries=" + this.indirectExportEntries + ", starExportEntries=" + this.starExportEntries + ", imports=" + this.imports + ", exports=" + this.exports + "]";
    }

    public static final class ImportEntry {
        private final String moduleRequest;
        private final String importName;
        private final String localName;

        private ImportEntry(String moduleRequest, String importName, String localName) {
            this.moduleRequest = moduleRequest;
            this.importName = importName;
            this.localName = localName;
        }

        public static ImportEntry importDefault(String localName) {
            return new ImportEntry(null, Module.DEFAULT_NAME, localName);
        }

        public static ImportEntry importStarAsNameSpaceFrom(String localNameSpace) {
            return new ImportEntry(null, Module.STAR_NAME, localNameSpace);
        }

        public static ImportEntry importSpecifier(String importName, String localName) {
            return new ImportEntry(null, importName, localName);
        }

        public static ImportEntry importSpecifier(String importName) {
            return ImportEntry.importSpecifier(importName, importName);
        }

        public ImportEntry withFrom(String moduleRequest) {
            return new ImportEntry(moduleRequest, this.importName, this.localName);
        }

        public String getModuleRequest() {
            return this.moduleRequest;
        }

        public String getImportName() {
            return this.importName;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String toString() {
            return "ImportEntry [moduleRequest=" + this.moduleRequest + ", importName=" + this.importName + ", localName=" + this.localName + "]";
        }
    }

    public static final class ExportEntry {
        private final String exportName;
        private final String moduleRequest;
        private final String importName;
        private final String localName;

        private ExportEntry(String exportName, String moduleRequest, String importName, String localName) {
            this.exportName = exportName;
            this.moduleRequest = moduleRequest;
            this.importName = importName;
            this.localName = localName;
        }

        public static ExportEntry exportStarFrom(String moduleRequest) {
            return new ExportEntry(null, moduleRequest, Module.STAR_NAME, null);
        }

        public static ExportEntry exportDefault() {
            return ExportEntry.exportDefault(Module.DEFAULT_EXPORT_BINDING_NAME);
        }

        public static ExportEntry exportDefault(String localName) {
            return new ExportEntry(Module.DEFAULT_NAME, null, null, localName);
        }

        public static ExportEntry exportSpecifier(String exportName, String localName) {
            return new ExportEntry(exportName, null, null, localName);
        }

        public static ExportEntry exportSpecifier(String exportName) {
            return ExportEntry.exportSpecifier(exportName, exportName);
        }

        public ExportEntry withFrom(String moduleRequest) {
            return new ExportEntry(this.exportName, moduleRequest, this.localName, null);
        }

        public String getExportName() {
            return this.exportName;
        }

        public String getModuleRequest() {
            return this.moduleRequest;
        }

        public String getImportName() {
            return this.importName;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String toString() {
            return "ExportEntry [exportName=" + this.exportName + ", moduleRequest=" + this.moduleRequest + ", importName=" + this.importName + ", localName=" + this.localName + "]";
        }
    }
}

