/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBufferRef;
import org.llvm.support.impl.MemoryBufferMem;
import org.llvm.support.impl.MemoryBufferStatics;
import org.llvm.support.llvm;
import org.llvm.support.sys.sys;

public abstract class MemoryBuffer
implements Destructors.ClassWithDestructor {
    private StringRef $StringRef;
    private char.ptr BufferStart;
    private char.ptr BufferEnd;
    private boolean InvalidBufferFlag = false;
    private int[] $SourceLineCache = null;
    private MemoryBuffer $TokenCacheFileMemoryBuffer = null;

    private MemoryBuffer(MemoryBuffer $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private MemoryBuffer $assign(MemoryBuffer $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected MemoryBuffer() {
    }

    protected void init(char.ptr BufStart, char.ptr BufEnd, boolean RequiresNullTerminator) {
        assert (!RequiresNullTerminator || BufEnd.$at(0) == 0) : "Buffer is not null terminated!";
        this.BufferStart = Native.$toConst((char.ptr)BufStart);
        this.BufferEnd = Native.$toConst((char.ptr)BufEnd);
        this.$StringRef = new StringRef(BufStart, this.BufferEnd.$sub((abstract_iterator)this.BufferStart));
    }

    public boolean isInvalid() {
        return this.InvalidBufferFlag;
    }

    public void setInvalid() {
        this.InvalidBufferFlag = true;
    }

    public void $destroy() {
    }

    public char.ptr getBufferStart() {
        return this.BufferStart;
    }

    public char.ptr getBufferEnd() {
        return this.BufferEnd;
    }

    public int getBufferSize() {
        return this.BufferEnd.$sub((abstract_iterator)this.BufferStart);
    }

    public StringRef getBuffer() {
        return this.$StringRef;
    }

    public char.ptr getBufferIdentifier() {
        return NativePointer.$((String)"Unknown buffer");
    }

    public static ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getFile(Twine Filename) {
        return MemoryBuffer.getFile(Filename, -1L, true, false);
    }

    public static ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getFile(Twine Filename, long FileSize) {
        return MemoryBuffer.getFile(Filename, FileSize, true, false);
    }

    public static ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getFile(Twine Filename, long FileSize, boolean RequiresNullTerminator) {
        return MemoryBuffer.getFile(Filename, FileSize, RequiresNullTerminator, false);
    }

    public static ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getFile(Twine Filename, long FileSize, boolean RequiresNullTerminator, boolean IsVolatileSize) {
        return MemoryBufferStatics.getFileAux(Filename, FileSize, FileSize, 0L, RequiresNullTerminator, IsVolatileSize);
    }

    public static ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getOpenFileSlice(int FD, Twine Filename, long MapSize, long Offset) {
        assert (MapSize != -1L);
        return MemoryBufferStatics.getOpenFileImpl(FD, Filename, -1L, MapSize, Offset, false, false);
    }

    public static ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getOpenFile(int FD, Twine Filename, long FileSize) {
        return MemoryBuffer.getOpenFile(FD, Filename, FileSize, true, false);
    }

    public static ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getOpenFile(int FD, Twine Filename, long FileSize, boolean RequiresNullTerminator) {
        return MemoryBuffer.getOpenFile(FD, Filename, FileSize, RequiresNullTerminator, false);
    }

    public static ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getOpenFile(int FD, Twine Filename, long FileSize, boolean RequiresNullTerminator, boolean IsVolatileSize) {
        return MemoryBufferStatics.getOpenFileImpl(FD, Filename, FileSize, FileSize, 0L, RequiresNullTerminator, IsVolatileSize);
    }

    public static std_ptr.unique_ptr<MemoryBuffer> getMemBuffer(StringRef InputData) {
        return MemoryBuffer.getMemBuffer(InputData, StringRef.R$EMPTY, true);
    }

    public static std_ptr.unique_ptr<MemoryBuffer> getMemBuffer(StringRef InputData, StringRef BufferName) {
        return MemoryBuffer.getMemBuffer(InputData, BufferName, true);
    }

    public static std_ptr.unique_ptr<MemoryBuffer> getMemBuffer(StringRef InputData, StringRef BufferName, boolean RequiresNullTerminator) {
        char.ptr copyOfName = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)(BufferName.size() + 1), (byte[])new byte[0]));
        MemoryBufferStatics.CopyStringRef(copyOfName, BufferName);
        MemoryBufferMem Ret = new MemoryBufferMem(new StringRef(InputData), RequiresNullTerminator, copyOfName);
        return new std_ptr.unique_ptr((Object)Ret);
    }

    public static std_ptr.unique_ptr<MemoryBuffer> getMemBuffer(MemoryBufferRef Ref) {
        return MemoryBuffer.getMemBuffer(Ref, true);
    }

    public static std_ptr.unique_ptr<MemoryBuffer> getMemBuffer(MemoryBufferRef Ref, boolean RequiresNullTerminator) {
        return MemoryBuffer.getMemBuffer(Ref.getBuffer(), Ref.getBufferIdentifier(), RequiresNullTerminator);
    }

    public static std_ptr.unique_ptr<MemoryBuffer> getMemBufferCopy(StringRef InputData) {
        return MemoryBuffer.getMemBufferCopy(InputData, Twine.T$EMPTY);
    }

    public static std_ptr.unique_ptr<MemoryBuffer> getMemBufferCopy(StringRef InputData, Twine BufferName) {
        std_ptr.unique_ptr<MemoryBuffer> Buf = MemoryBuffer.getNewUninitMemBuffer(null, InputData.size(), BufferName);
        if (!Buf.$bool()) {
            return new std_ptr.unique_ptr((Object)null);
        }
        std.memcpy((char.ptr)((MemoryBuffer)Buf.$arrow()).getBufferStart(), (char.ptr)InputData.data(), (int)InputData.size());
        return Buf;
    }

    public static std_ptr.unique_ptr<MemoryBuffer> getNewMemBuffer(int Size) {
        return MemoryBuffer.getNewMemBuffer(null, Size, StringRef.R$EMPTY);
    }

    public static std_ptr.unique_ptr<MemoryBuffer> getNewMemBuffer(int Size, StringRef BufferName) {
        return MemoryBuffer.getNewMemBuffer(null, Size, BufferName);
    }

    public static std_ptr.unique_ptr<MemoryBuffer> getNewMemBuffer(NativeMemory.Allocator Alloc, int Size, StringRef BufferName) {
        std_ptr.unique_ptr<MemoryBuffer> SB = MemoryBuffer.getNewUninitMemBuffer(Alloc, Size, MemoryBuffer.$getMemBufferName(BufferName));
        if (!SB.$bool()) {
            return new std_ptr.unique_ptr((Object)null);
        }
        std.memset((char.ptr)((MemoryBuffer)SB.$arrow()).getBufferStart(), (byte)0, (int)Size);
        return SB;
    }

    private static Twine $getMemBufferName(StringRef name) {
        if (StringRef.R$EMPTY.equals(name)) {
            return Twine.T$EMPTY;
        }
        if (StringRef.R$scratch_space_marker.equals(name)) {
            return Twine.T$scratch_space_marker;
        }
        return new Twine(name);
    }

    public static std_ptr.unique_ptr<MemoryBuffer> getNewUninitMemBuffer(int Size) {
        return MemoryBuffer.getNewUninitMemBuffer(null, Size, Twine.T$EMPTY);
    }

    public static std_ptr.unique_ptr<MemoryBuffer> getNewUninitMemBuffer(int Size, Twine BufferName) {
        return MemoryBuffer.getNewUninitMemBuffer(null, Size, BufferName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std_ptr.unique_ptr<MemoryBuffer> getNewUninitMemBuffer(NativeMemory.Allocator Alloc, int Size, Twine BufferName) {
        SmallVectorImplChar NameBuf = null;
        try {
            char.ptr copyOfName;
            if (BufferName.$eq(Twine.T$EMPTY)) {
                copyOfName = NativePointer.$EMPTY;
            } else if (BufferName.$eq(Twine.T$scratch_space_marker)) {
                copyOfName = NativePointer.$scratch_space_marker;
            } else if (BufferName.$eq(Twine.T$invalid_marker)) {
                copyOfName = NativePointer.$invalid_marker;
            } else {
                NameBuf = new SmallString(256);
                StringRef NameRef = BufferName.toStringRef((SmallString)NameBuf);
                assert (Alloc == null) : "must not be any allocators here to prevent destroy of cached buffers";
                copyOfName = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)(NameRef.size() + 1), (byte[])new byte[0]));
                MemoryBufferStatics.CopyStringRef(copyOfName, NameRef);
            }
            char.ptr Buf = Alloc == null ? NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)(Size + 1), (byte[])new byte[0])) : Alloc.Allocate(Size + 1);
            Buf.$set(Size, (byte)0);
            MemoryBufferMem Ret = new MemoryBufferMem(new StringRef(Buf, Size), true, copyOfName);
            std_ptr.unique_ptr unique_ptr2 = new std_ptr.unique_ptr((Object)Ret);
            return unique_ptr2;
        }
        finally {
            if (NameBuf != null) {
                NameBuf.$destroy();
            }
        }
    }

    public static ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getSTDIN() {
        sys.ChangeStdinToBinary();
        return MemoryBufferStatics.getMemoryBufferForStream(0, new Twine(NativePointer.$((String)"<stdin>")));
    }

    public static ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getFileOrSTDIN(Twine Filename) {
        return MemoryBuffer.getFileOrSTDIN(Filename, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getFileOrSTDIN(Twine Filename, long FileSize) {
        SmallString NameBuf = null;
        try {
            NameBuf = new SmallString(256);
            StringRef NameRef = Filename.toStringRef(NameBuf);
            if (llvm.$eq_StringRef(new StringRef(NameRef), StringRef.R$MINUS)) {
                ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> errorOr = MemoryBuffer.getSTDIN();
                return errorOr;
            }
            ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> errorOr = MemoryBuffer.getFile(Filename, FileSize);
            return errorOr;
        }
        finally {
            if (NameBuf != null) {
                NameBuf.$destroy();
            }
        }
    }

    public static ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getFileSlice(Twine FilePath, long MapSize, long Offset) {
        return MemoryBufferStatics.getFileAux(FilePath, -1L, MapSize, Offset, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceLineCache(int[] SourceLineCache, int NumLines) {
        assert (SourceLineCache.length == NumLines) : NumLines + " vs. " + SourceLineCache.length;
        MemoryBuffer memoryBuffer = this;
        synchronized (memoryBuffer) {
            this.$SourceLineCache = SourceLineCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getSourceLineCache() {
        MemoryBuffer memoryBuffer = this;
        synchronized (memoryBuffer) {
            return this.$SourceLineCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryBuffer setTokenCacheBuffer(MemoryBuffer tokenFileBuffer) {
        assert (tokenFileBuffer != null);
        MemoryBuffer memoryBuffer = this;
        synchronized (memoryBuffer) {
            if (this.$TokenCacheFileMemoryBuffer == null) {
                this.$TokenCacheFileMemoryBuffer = tokenFileBuffer;
            }
            return this.$TokenCacheFileMemoryBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryBuffer getTokenCacheBuffer() {
        MemoryBuffer memoryBuffer = this;
        synchronized (memoryBuffer) {
            return this.$TokenCacheFileMemoryBuffer;
        }
    }

    public abstract BufferKind getBufferKind();

    public MemoryBufferRef getMemBufferRef() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public String toString() {
        return (this.InvalidBufferFlag ? "INVALID;" : "") + "Name=" + Casts.toJavaString((char.ptr)this.getBufferIdentifier()) + ";Size=" + this.getBufferSize() + ";BufferStart=" + this.BufferStart + ", BufferEnd=" + this.BufferEnd;
    }

    public static final class BufferKind
    extends Enum<BufferKind> {
        public static final /* enum */ BufferKind MemoryBuffer_Malloc = new BufferKind(0);
        public static final /* enum */ BufferKind MemoryBuffer_MMap = new BufferKind(MemoryBuffer_Malloc.getValue() + 1);
        private final int value;
        private static final /* synthetic */ BufferKind[] $VALUES;

        public static BufferKind[] values() {
            return (BufferKind[])$VALUES.clone();
        }

        public static BufferKind valueOf(String name) {
            return Enum.valueOf(BufferKind.class, name);
        }

        public static BufferKind valueOf(int val) {
            BufferKind out;
            BufferKind bufferKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private BufferKind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new BufferKind[]{MemoryBuffer_Malloc, MemoryBuffer_MMap};
        }

        private static final class Values {
            private static final BufferKind[] VALUES;
            private static final BufferKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (BufferKind kind : BufferKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new BufferKind[min < 0 ? 1 - min : 0];
                VALUES = new BufferKind[max >= 0 ? 1 + max : 0];
                for (BufferKind kind : BufferKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((BufferKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((BufferKind)kind).value] = kind;
                }
            }
        }
    }
}

