/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netserver.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;
import org.netbeans.modules.netserver.ReadHandler;
import org.netbeans.modules.netserver.SocketClient;
import org.netbeans.modules.netserver.SocketFramework;
import org.netbeans.modules.netserver.api.ProtocolDraft;
import org.netbeans.modules.netserver.api.WebSocketReadHandler;
import org.netbeans.modules.netserver.websocket.WebSocketChanelHandler;
import org.netbeans.modules.netserver.websocket.WebSocketHandlerClient7;
import org.netbeans.modules.netserver.websocket.WebSocketHandlerClient75;
import org.netbeans.modules.netserver.websocket.WebSocketHandlerClient76;

public class WebSocketClientImpl
extends SocketClient {
    static final Logger LOG = SocketFramework.LOG;
    private volatile WebSocketReadHandler handler;
    private URI uri;
    private WebSocketChanelHandler innerHandler;

    public WebSocketClientImpl(URI uri, ProtocolDraft draft) throws IOException {
        this(new InetSocketAddress(uri.getHost(), uri.getPort()), draft);
        this.uri = uri;
    }

    public WebSocketClientImpl(URI uri) throws IOException {
        this(uri, ProtocolDraft.getRFC());
    }

    private WebSocketClientImpl(SocketAddress address, ProtocolDraft draft) throws IOException {
        super(address);
        this.setReadHandler(new WebSocketClientHandler());
        if (draft.isRFC() || draft.getDraft() == null) {
            this.setHandler(new WebSocketHandlerClient7(this, draft.getVersion()));
        } else if (draft.getDraft() == ProtocolDraft.Draft.Draft75) {
            this.setHandler(new WebSocketHandlerClient75(this));
        } else if (draft.getDraft() == ProtocolDraft.Draft.Draft76) {
            this.setHandler(new WebSocketHandlerClient76(this));
        }
    }

    public void sendMessage(String message) {
        SelectionKey key = this.getKey();
        if (key == null) {
            this.stop();
            return;
        }
        byte[] bytes = this.getHandler().createTextFrame(message);
        this.send(bytes, key);
    }

    public void setWebSocketReadHandler(WebSocketReadHandler handler) {
        this.handler = handler;
    }

    public WebSocketReadHandler getWebSocketReadHandler() {
        return this.handler;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public void close(SelectionKey key) throws IOException {
        if (key == null) {
            return;
        }
        super.close(key);
        this.stop();
    }

    @Override
    protected void chanelClosed(SelectionKey key) {
        this.getWebSocketReadHandler().closed(key);
    }

    protected SelectionKey getKey() {
        return this.getChannel().keyFor(this.getSelector());
    }

    @Override
    protected SocketChannel getChannel() {
        return super.getChannel();
    }

    @Override
    protected void finishConnect(SelectionKey key) throws IOException {
        super.finishConnect(key);
        this.getHandler().sendHandshake();
    }

    void setHandler(WebSocketChanelHandler handler) {
        this.innerHandler = handler;
    }

    WebSocketChanelHandler getHandler() {
        return this.innerHandler;
    }

    protected class WebSocketClientHandler
    implements ReadHandler {
        private ByteBuffer byteBuffer = ByteBuffer.allocate(1000);

        @Override
        public void read(SelectionKey key) throws IOException {
            WebSocketClientImpl.this.getHandler().read(this.byteBuffer);
        }
    }
}

