/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.checkout;

import org.netbeans.modules.git.remote.ui.checkout.AbstractCheckoutAction;
import org.netbeans.modules.git.remote.ui.checkout.AbstractCheckoutRevision;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.ui.repository.RevisionDialogController;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CheckoutRevisionAction
extends AbstractCheckoutAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/remote/resources/icons/checkout.png";

    public CheckoutRevisionAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        this.checkoutRevision(repository, info.getActiveBranch().getName().equals("(no branch)") ? "HEAD" : info.getActiveBranch().getName());
    }

    public void checkoutRevision(VCSFileProxy repository, String preselectedRevision) {
        this.checkoutRevision(repository, new CheckoutRevision(repository, RepositoryInfo.getInstance(repository), preselectedRevision), "LBL_CheckoutRevisionAction.progressName", new HelpCtx(CheckoutRevisionAction.class));
    }

    private static class CheckoutRevision
    extends AbstractCheckoutRevision {
        public CheckoutRevision(VCSFileProxy repository, RepositoryInfo info, String initialRevision) {
            super(info, new RevisionDialogController(repository, new VCSFileProxy[]{repository}, initialRevision));
            this.panel.jLabel1.setText(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"CheckoutRevision.jLabel1.text"));
        }

        @Override
        protected String getOkButtonLabel() {
            return NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevision.OKButton.text");
        }

        @Override
        protected String getDialogTitle() {
            return NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevision.title");
        }
    }
}

