/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.reset;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import org.netbeans.modules.git.remote.cli.GitClient;
import org.netbeans.modules.git.remote.ui.repository.RevisionDialogController;
import org.netbeans.modules.git.remote.ui.reset.ResetPanel;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class Reset
implements ActionListener {
    private final ResetPanel panel;
    private final RevisionDialogController revisionPicker;
    private JButton okButton;
    private DialogDescriptor dd;
    private boolean valid = true;

    Reset(VCSFileProxy repository, VCSFileProxy[] roots) {
        this.revisionPicker = new RevisionDialogController(repository, roots, "HEAD");
        this.panel = new ResetPanel(this.revisionPicker.getPanel());
    }

    String getRevision() {
        return this.revisionPicker.getRevision().getRevision();
    }

    boolean show() {
        this.panel.rbSoft.addActionListener(this);
        this.panel.rbMixed.addActionListener(this);
        this.panel.rbHard.addActionListener(this);
        this.okButton = new JButton(NbBundle.getMessage(Reset.class, (String)"LBL_Reset.OKButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)this.okButton.getText());
        this.dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(Reset.class, (String)"LBL_Reset.title"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, new HelpCtx(Reset.class), null);
        this.revisionPicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "RevisionDialogController.valid") {
                    Reset.this.setRevisionValid(Boolean.TRUE.equals(evt.getNewValue()));
                }
            }
        });
        Dialog d = DialogDisplayer.getDefault().createDialog(this.dd);
        this.validate();
        d.setVisible(true);
        return this.okButton == this.dd.getValue();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.validate();
    }

    private void setRevisionValid(boolean flag) {
        this.valid = flag;
        this.validate();
    }

    GitClient.ResetType getType() {
        String cmd = null;
        for (JRadioButton btn : new JRadioButton[]{this.panel.rbHard, this.panel.rbMixed, this.panel.rbSoft}) {
            if (!btn.isSelected()) continue;
            cmd = btn.getActionCommand();
            break;
        }
        return GitClient.ResetType.valueOf(cmd);
    }

    private void validate() {
        boolean flag = this.valid && (this.panel.rbHard.isSelected() || this.panel.rbMixed.isSelected() || this.panel.rbSoft.isSelected());
        this.okButton.setEnabled(flag);
        this.dd.setValid(flag);
    }
}

