/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.revert;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRevertResult;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.progress.NotificationListener;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.GitAction;
import org.netbeans.modules.git.remote.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.remote.ui.output.OutputLogger;
import org.netbeans.modules.git.remote.ui.revert.RevertCommit;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.git.remote.utils.ResultProcessor;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class RevertCommitAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(RevertCommitAction.class.getName());

    @Override
    protected void performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        this.revert(repository, roots, "HEAD");
    }

    public void revert(final VCSFileProxy repository, VCSFileProxy[] roots, String preselectedRevision) {
        final RevertCommit revert = new RevertCommit(repository, roots, preselectedRevision);
        if (revert.show()) {
            new GitProgressSupport(){

                @Override
                protected void perform() {
                    try {
                        GitUtils.runWithoutIndexing(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                boolean cont;
                                GitClient client = this.getClient();
                                client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(new VCSFileProxy[]{repository}));
                                String revision = revert.getRevision();
                                LOG.log(Level.FINE, "Reverting revision {0}", revision);
                                RevertResultProcessor mrp = new RevertResultProcessor(client, repository, revision, this.getLogger(), this.getProgressMonitor());
                                do {
                                    cont = false;
                                    try {
                                        GitRevertResult result = client.revert(revision, revert.getMessage(), revert.isCommitEnabled(), this.getProgressMonitor());
                                        mrp.processResult(result);
                                        GitUtils.headChanged(repository);
                                    }
                                    catch (GitException.CheckoutConflictException ex) {
                                        if (LOG.isLoggable(Level.FINE)) {
                                            LOG.log(Level.FINE, "Local modifications in WT during revert: {0} - {1}", new Object[]{repository, Arrays.asList(ex.getConflicts())});
                                        }
                                        cont = mrp.resolveLocalChanges(ex.getConflicts());
                                    }
                                } while (cont);
                                return null;
                            }
                        }, repository);
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                    finally {
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                    }
                }
            }.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(RevertCommitAction.class, (String)"LBL_RevertCommitAction.progress"));
        }
    }

    public static class RevertResultProcessor
    extends ResultProcessor {
        private final OutputLogger logger;
        private final String revision;

        public RevertResultProcessor(GitClient client, VCSFileProxy repository, String revision, OutputLogger logger, ProgressMonitor pm) {
            super(client, repository, revision, pm);
            this.revision = revision;
            this.logger = logger;
        }

        public void processResult(GitRevertResult result) {
            StringBuilder sb = new StringBuilder(NbBundle.getMessage(RevertCommit.class, (String)"MSG_RevertCommitAction.result", (Object)result.getStatus().toString()));
            GitRevisionInfo info = result.getNewHead();
            switch (result.getStatus()) {
                case NO_CHANGE: {
                    sb.append(NbBundle.getMessage(RevertCommit.class, (String)"MSG_RevertCommitAction.result.noChange", (Object)this.revision));
                    break;
                }
                case REVERTED_IN_INDEX: {
                    sb.append(NbBundle.getMessage(RevertCommit.class, (String)"MSG_RevertCommitAction.result.revertedIndex", (Object)this.revision));
                    break;
                }
                case REVERTED: {
                    sb.append(NbBundle.getMessage(RevertCommit.class, (String)"MSG_RevertCommitAction.result.reverted", (Object)this.revision));
                    GitUtils.printInfo(sb, info);
                    break;
                }
                case CONFLICTING: {
                    sb.append(NbBundle.getMessage(RevertCommit.class, (String)"MSG_RevertCommitAction.result.conflict", (Object)this.revision));
                    this.printConflicts(this.logger, sb, result.getConflicts());
                    this.resolveConflicts(result.getConflicts());
                    break;
                }
                case FAILED: {
                    final Action openAction = this.logger.getOpenOutputAction();
                    if (openAction != null) {
                        try {
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    openAction.actionPerformed(new ActionEvent(RevertResultProcessor.this, 1001, null));
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                    }
                    sb.append(NbBundle.getMessage(RevertCommit.class, (String)"MSG_RevertCommitAction.result.failedFiles", (Object)this.revision));
                    this.printConflicts(this.logger, sb, result.getFailures());
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RevertCommit.class, (String)"MSG_RevertCommitAction.result.failed", (Object)this.revision), 0));
                }
            }
            if (sb.length() > 0) {
                this.logger.outputLine(sb.toString());
            }
        }
    }
}

