/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.performance.guitracker;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.modules.performance.guitracker.LoggingRepaintManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ActionTracker {
    public static final int TRACK_START = 1;
    public static final int TRACK_PAINT = 2;
    public static final int TRACK_MOUSE_PRESS = 10;
    public static final int TRACK_MOUSE_RELEASE = 11;
    public static final int TRACK_MOUSE_DRAGGED = 12;
    public static final int TRACK_MOUSE_MOVED = 13;
    public static final int TRACK_KEY_PRESS = 20;
    public static final int TRACK_KEY_RELEASE = 21;
    private static final int TRACK_FRAME = 1000;
    private static final int TRACK_DIALOG = 2000;
    private static final int TRACK_COMPONENT = 3000;
    public static final int TRACK_FRAME_SHOW = 1102;
    public static final int TRACK_FRAME_HIDE = 1103;
    public static final int TRACK_FRAME_RESIZE = 1101;
    public static final int TRACK_DIALOG_SHOW = 2102;
    public static final int TRACK_DIALOG_HIDE = 2103;
    public static final int TRACK_DIALOG_RESIZE = 2101;
    public static final int TRACK_COMPONENT_SHOW = 3102;
    public static final int TRACK_COMPONENT_HIDE = 3103;
    public static final int TRACK_COMPONENT_RESIZE = 3101;
    public static final int TRACK_APPLICATION_MESSAGE = 50;
    public static final int TRACK_CONFIG_APPLICATION_MESSAGE = 51;
    public static final int TRACK_TRACE_MESSAGE = 52;
    public static final int TRACK_OPEN_BEFORE_TRACE_MESSAGE = 53;
    public static final int TRACK_OPEN_AFTER_TRACE_MESSAGE = 54;
    public static final int TRACK_FOCUS_GAINED = 80;
    public static final int TRACK_FOCUS_LOST = 81;
    public static final int TRACK_INVOCATION = 82;
    public static final int TRACK_UNKNOWN = 83;
    public static final String TN_ROOT_ELEMENT = "action-tracking";
    public static final String TN_EVENT_LIST = "event-list";
    public static final String TN_EVENT = "event";
    public static final String ATTR_START = "start";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_TIME = "time";
    public static final String ATTR_TIME_DIFF_START = "diff";
    public static final String ATTR_TIME_DIFF_DRAG = "diffdrag";
    public static final String ATTR_MEASURED = "measured";
    private static ActionTracker instance = null;
    private LinkedList<EventList> eventLists = null;
    private EventList currentEvents = null;
    private OurAWTEventListener awt_listener = null;
    private boolean connected = false;
    private String fnActionOutput = null;
    private boolean exportXmlWhenScenarioFinished = false;
    private boolean allowRecording = true;
    private DocumentBuilder dbld = null;
    private DocumentBuilderFactory dbfactory = null;
    private TransformerFactory tfactory = null;
    private long default_awt_event_mask = 57L;
    long awt_event_mask = this.default_awt_event_mask;
    private boolean interactive;
    private static String actionTrackerXslLocation = "";

    public static ActionTracker getInstance() {
        if (instance == null) {
            instance = new ActionTracker();
        }
        return instance;
    }

    private ActionTracker() {
    }

    void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public void stopRecording() {
        this.allowRecording = false;
    }

    public void startRecording() {
        this.allowRecording = true;
    }

    public boolean isRecording() {
        return this.allowRecording;
    }

    public void setOutputFileName(String fn) {
        this.fnActionOutput = fn;
    }

    public void setExportXMLWhenScenarioFinished(boolean export) {
        this.exportXmlWhenScenarioFinished = export;
    }

    public EventList getCurrentEvents() {
        return this.currentEvents;
    }

    public void forgetCurrentEvents() {
        this.currentEvents = null;
        if (this.eventLists != null) {
            this.eventLists.removeLast();
        }
    }

    public LinkedList<EventList> getEventLists() {
        return this.eventLists;
    }

    public void forgetAllEvents() {
        if (this.eventLists != null) {
            this.eventLists.clear();
        }
        if (this.currentEvents != null) {
            this.currentEvents.clear();
        }
        this.currentEvents = null;
    }

    public void startNewEventList(String name) {
        if (this.eventLists == null) {
            this.eventLists = new LinkedList();
        }
        this.currentEvents = new EventList(name);
        this.eventLists.add(this.currentEvents);
        this.currentEvents.start();
        this.startRecording();
        this.add(1, "START", this.currentEvents.startMillies);
    }

    public void setAWTEventListeningMask(long mask) {
        this.awt_event_mask = mask;
    }

    public long getAWTEventListengingMask() {
        return this.awt_event_mask;
    }

    public void connectToAWT(boolean connect) {
        if (connect) {
            if (this.awt_listener == null) {
                this.awt_listener = new OurAWTEventListener(this);
            }
            if (!this.connected) {
                Toolkit.getDefaultToolkit().addAWTEventListener(this.awt_listener, this.awt_event_mask);
            }
            this.connected = true;
        } else {
            if (this.awt_listener != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.awt_listener);
            }
            this.connected = false;
        }
    }

    public void add(Tuple t) {
        if (!this.isRecording()) {
            return;
        }
        if (this.currentEvents != null) {
            this.currentEvents.add(t);
        }
    }

    public void add(int code, String name, long millies) {
        EventList ce = this.getCurrentEvents();
        this.add(new Tuple(code, name, millies, ce != null ? ce.startMillies : -1L));
    }

    public void add(int code, String name) {
        EventList ce = this.getCurrentEvents();
        this.add(new Tuple(code, name, ce != null ? ce.startMillies : -1L));
    }

    public void add(int code, String name, boolean measured) {
        EventList ce = this.getCurrentEvents();
        Tuple t = new Tuple(code, name, System.nanoTime(), ce != null ? ce.startMillies : -1L, measured);
        this.add(t);
    }

    public void add(AWTEvent event) {
        if (event instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)event;
            int id = me.getID();
            if (id == 501 || id == 502) {
                String mr = id == 501 ? "MOUSE PRESSED" : "MOUSE RELEASED";
                int bmask = me.getButton();
                this.add(id == 501 ? 10 : 11, mr + " bmask=" + Integer.toString(bmask) + " modifiers=" + MouseEvent.getMouseModifiersText(me.getModifiers()));
            }
            if (id == 503 || id == 506) {
                String mm = id == 503 ? "MOUSE MOVED" : "MOUSE DRAGGED";
                this.add(id == 503 ? 13 : 12, mm + " " + Integer.toString(me.getX()) + "," + Integer.toString(me.getY()));
            }
        } else if (event instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)event;
            int id = ke.getID();
            if (id == 401 || id == 402) {
                String kr = id == 401 ? "KEY PRESSED" : "KEY RELEASED";
                int kc = ke.getKeyCode();
                this.add(id == 401 ? 20 : 21, kr + " keycode=" + Integer.toString(kc) + " keytext=" + KeyEvent.getKeyText(kc) + " modtext=" + KeyEvent.getKeyModifiersText(ke.getModifiers()));
            }
        } else if (!(event instanceof WindowEvent)) {
            if (event instanceof FocusEvent) {
                FocusEvent fe = (FocusEvent)event;
                int id = fe.getID();
                Component opposite = fe.getOppositeComponent();
                Component thisone = fe.getComponent();
                boolean temp = fe.isTemporary();
                if (id == 1004) {
                    this.add(80, (temp ? "temp " : "perm ") + "opp " + opposite + "this " + thisone);
                } else if (id == 1005) {
                    this.add(81, (temp ? "temp " : "perm ") + "opp " + opposite + "this " + thisone);
                }
            } else if (event instanceof ComponentEvent) {
                ComponentEvent ce = (ComponentEvent)event;
                int id = ce.getID();
                if (id == 103 || id == 102) {
                    Component c = ce.getComponent();
                    if (c instanceof Frame || c instanceof JFrame) {
                        this.add(1000 + id, ce.paramString() + " " + ActionTracker.logComponentAndItsParents(c));
                    } else if (c instanceof Dialog || c instanceof JDialog) {
                        this.add(2000 + id, ce.paramString() + " " + ActionTracker.logComponentAndItsParents(c));
                    } else {
                        this.add(3000 + id, ce.paramString() + " " + ActionTracker.logComponentAndItsParents(c));
                    }
                }
            } else if (!(event instanceof InvocationEvent)) {
                this.add(83, "Unknown event: " + event.paramString());
            }
        }
    }

    public static String logComponentAndItsParents(Component c) {
        if (c instanceof Container) {
            return LoggingRepaintManager.logContainerAndItsParents((Container)c);
        }
        return LoggingRepaintManager.logComponent(c);
    }

    public void scenarioFinished() {
        this.add(50, "ScenarioFinished");
        if (this.exportXmlWhenScenarioFinished) {
            try {
                this.exportAsXML();
            }
            catch (Exception e) {
                System.err.println("Unable to export to XML because " + e);
                e.printStackTrace();
            }
        }
    }

    TransformerFactory getTransformerFactory() throws TransformerConfigurationException {
        if (this.tfactory == null) {
            this.tfactory = TransformerFactory.newInstance();
        }
        return this.tfactory;
    }

    DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.dbfactory == null) {
            this.dbfactory = DocumentBuilderFactory.newInstance();
        }
        if (this.dbld == null) {
            this.dbld = this.dbfactory.newDocumentBuilder();
        }
        return this.dbld;
    }

    public void exportAsXML() throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        PrintStream out = System.out;
        if (this.fnActionOutput != null) {
            try {
                out = new PrintStream(new FileOutputStream(new File(this.fnActionOutput)));
            }
            catch (Exception e) {
                out = System.out;
            }
        }
        this.exportAsXML(null, out);
    }

    public void exportAsXML(PrintStream out) throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        this.exportAsXML(null, out);
    }

    public void exportAsXML(Document style, PrintStream out) throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        Document doc = this.getDocumentBuilder().getDOMImplementation().createDocument(null, TN_ROOT_ELEMENT, null);
        Element root = doc.getDocumentElement();
        for (EventList eventList : this.eventLists) {
            Element evlistElement = doc.createElement(TN_EVENT_LIST);
            root.appendChild(evlistElement);
            evlistElement.setAttribute(ATTR_START, Long.toString(eventList.getStartMillis()));
            evlistElement.setAttribute(ATTR_NAME, eventList.getName());
            Tuple previous = new Tuple(0, "", 0L, 0L);
            for (Tuple t : Collections.unmodifiableList(eventList)) {
                if (t != null && !t.equals(previous)) {
                    Element eventElement = doc.createElement(TN_EVENT);
                    evlistElement.appendChild(eventElement);
                    eventElement.setAttribute(ATTR_TYPE, t.getCodeName());
                    eventElement.setAttribute(ATTR_NAME, ActionTracker.getShortenName(t.getName()));
                    eventElement.setAttribute(ATTR_TIME, ActionTracker.getTimeMillisForLog(t));
                    eventElement.setAttribute(ATTR_TIME_DIFF_START, Long.toString(t.getTimeDifference()));
                    if (t.getMeasured()) {
                        eventElement.setAttribute(ATTR_MEASURED, "true");
                    }
                }
                previous = t;
            }
        }
        Transformer tr = style != null ? this.getTransformerFactory().newTransformer(new DOMSource(style)) : this.getTransformerFactory().newTransformer();
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource docSrc = new DOMSource(doc);
        StreamResult rslt = new StreamResult(out);
        out.println("<?xml version=\"1.0\" ?>");
        out.println("<?xml-stylesheet type=\"text/xsl\" href=\"" + ActionTracker.getPathToXsl() + "\" media=\"screen\"?>");
        tr.transform(docSrc, rslt);
    }

    private static String getShortenName(String name) {
        name = name.replaceAll("javax.swing", "j");
        name = name.replaceAll("org.netbeans.modules", "o.n.m");
        name = name.replaceAll("org.netbeans", "o.n");
        name = name.replaceAll("org.openide.awt", "o.o.a");
        name = name.replaceAll("org.openide", "o.o");
        return name;
    }

    public static String getNameForCode(int code) {
        String cname = "unk";
        switch (code) {
            case 1: {
                cname = ATTR_START;
                break;
            }
            case 2: {
                cname = "paint";
                break;
            }
            case 10: {
                cname = "user_action";
                break;
            }
            case 11: {
                cname = "user_action";
                break;
            }
            case 12: {
                cname = "user_action";
                break;
            }
            case 13: {
                cname = "user_action";
                break;
            }
            case 20: {
                cname = "user_action";
                break;
            }
            case 21: {
                cname = "user_action";
                break;
            }
            case 1102: {
                cname = "paint";
                break;
            }
            case 1103: {
                cname = "app_message";
                break;
            }
            case 2102: {
                cname = "paint";
                break;
            }
            case 2103: {
                cname = "app_message";
                break;
            }
            case 3102: {
                cname = "paint";
                break;
            }
            case 3103: {
                cname = "app_message";
                break;
            }
            case 82: {
                cname = "app_message";
                break;
            }
            case 83: {
                cname = "unknown";
                break;
            }
            case 50: {
                cname = "app_message";
                break;
            }
            case 51: {
                cname = "config_message";
                break;
            }
            case 52: {
                cname = "trace_message";
            }
        }
        return cname;
    }

    static long nanoToMili(long nano) {
        return nano / 1000000L;
    }

    private static String getTimeMillisForLog(Tuple t) {
        return Long.toString(t.getTimeMillis() - t.getTimeMillis() / 10000000L * 10000000L);
    }

    public void setXslLocation(String xslLocation) {
        actionTrackerXslLocation = xslLocation;
    }

    private static String getPathToXsl() {
        StringBuilder pathToXsl = new StringBuilder();
        String workdir = System.getProperty("nbjunit.workdir");
        pathToXsl.append(workdir).append(File.separator);
        pathToXsl.append("../../../../../src/org/netbeans/modules/performance/resources/ActionTracker.xsl");
        return pathToXsl.toString();
    }

    class OurAWTEventListener
    implements AWTEventListener {
        ActionTracker tracker = null;

        public OurAWTEventListener(ActionTracker t) {
            this.tracker = t;
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            this.tracker.add(event);
        }
    }

    public final class Tuple {
        private int code;
        private String name;
        private long millies;
        private long diffies;
        private boolean measured;
        private String measurementThreadName;

        public Tuple(int code, String name, long start) {
            this(code, name, System.nanoTime(), start);
        }

        public Tuple(int code, String name, long millies, long start) {
            this(code, name, millies, start, false);
        }

        public Tuple(int code, String name, long millies, long start, boolean measured) {
            this.code = code;
            this.name = name;
            this.millies = millies;
            this.diffies = millies - start;
            this.measured = measured;
            this.measurementThreadName = Thread.currentThread().getName();
        }

        public String getCodeName() {
            return ActionTracker.getNameForCode(this.code);
        }

        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public long getTimeMillis() {
            return ActionTracker.nanoToMili(this.millies);
        }

        public long getTimeDifference() {
            return ActionTracker.nanoToMili(this.diffies);
        }

        public void setMeasured(boolean measured) {
            this.measured = measured;
        }

        public boolean getMeasured() {
            return this.measured;
        }

        public String getMeasurementThreadName() {
            return this.measurementThreadName;
        }

        public String toString() {
            return this.getCodeName() + " " + this.getName() + " " + Long.toString(this.getTimeMillis()) + " " + Long.toString(this.getTimeDifference());
        }

        public boolean equals(Object obj) {
            Tuple t = (Tuple)obj;
            return this.getCode() == t.getCode() && this.getName().equalsIgnoreCase(t.getName()) && (this.getTimeMillis() == t.getTimeMillis() || this.getTimeDifference() == t.getTimeDifference());
        }
    }

    public final class EventList
    extends LinkedList<Tuple> {
        private String name = "unknown";
        private long startMillies = -1L;

        EventList() {
        }

        public EventList(String name) {
            this();
            if (name == null || name.length() <= 0) {
                throw new RuntimeException("Must provide a name");
            }
            this.name = name;
        }

        public void start() {
            if (this.startMillies == -1L) {
                this.startMillies = System.nanoTime();
            }
        }

        public long getStartMillis() {
            return ActionTracker.nanoToMili(this.startMillies);
        }

        public String getName() {
            return this.name;
        }

        @Override
        public boolean add(Tuple o) {
            if (ActionTracker.this.interactive) {
                int c = o.getCode();
                if (c != 50 && c != 13) {
                    System.out.println(o.toString());
                }
                if (c == 11 || c == 10 || c == 20) {
                    ActionTracker.this.forgetAllEvents();
                    ActionTracker.this.startNewEventList("ad hoc");
                }
            }
            if (o == null) {
                return false;
            }
            return super.add(o);
        }

        @Override
        public String toString() {
            return this.getName() + " (" + this.size() + ") " + new Date(this.getStartMillis()).toString();
        }
    }
}

