/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TypeNameIdGenerator {
    private static final String ARRAY_SUFFIX = "Arr";
    private final Elements elements;
    private final Types types;
    private final Map<String, String> qualNameToId;

    private TypeNameIdGenerator(Elements elements, Types types) {
        this.elements = elements;
        this.types = types;
        this.qualNameToId = new HashMap<String, String>(20);
    }

    static TypeNameIdGenerator createFor(Collection<TypeMirror> paramTypes, Elements elements, Types types) {
        TypeNameIdGenerator inst = new TypeNameIdGenerator(elements, types);
        inst.generateMapping(paramTypes);
        return inst;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void generateMapping(Collection<TypeMirror> paramTypes) {
        String briefTypeName;
        String fullTypeName;
        int typesCount = paramTypes.size();
        int uniqueTypesCountExp = Math.max(5, typesCount / 3);
        ArrayList<String> fullTypeNames = new ArrayList<String>(uniqueTypesCountExp);
        ArrayList<String> briefTypeNames = new ArrayList<String>(uniqueTypesCountExp);
        HashSet<String> processedTypes = new HashSet<String>((paramTypes.size() * 3 + 1) / 2);
        HashMap<String, Object> briefTypeIdsUsage = new HashMap<String, Object>(typesCount * 3 / 2);
        BitSet briefTypeIdsConflicting = new BitSet(typesCount);
        BitSet briefTypeIdsRegistered = new BitSet(typesCount);
        int registeredTypeIdsCount = 0;
        int conflictingTypeIdsCount = 0;
        HashSet<String> reservedTypeIds = new HashSet<String>(13);
        int index = 0;
        for (TypeMirror type : paramTypes) {
            block29: {
                TypeKind kind = type.getKind();
                if (kind != TypeKind.DECLARED && kind != TypeKind.ARRAY) continue;
                if (kind == TypeKind.ARRAY) {
                    TypeKind compTypeKind;
                    int arrayDim = 0;
                    StringBuilder fullTypeNameBuf = new StringBuilder(20);
                    StringBuilder briefTypeNameBuf = new StringBuilder(26);
                    TypeMirror compType = type;
                    do {
                        ++arrayDim;
                        fullTypeNameBuf.append('[');
                        briefTypeNameBuf.append(ARRAY_SUFFIX);
                    } while ((compTypeKind = (compType = ((ArrayType)compType).getComponentType()).getKind()) == TypeKind.ARRAY);
                    if (compTypeKind == TypeKind.DECLARED) {
                        String compTypeFullName = this.getTypeFullName(compType);
                        fullTypeName = fullTypeNameBuf.append(compTypeFullName).toString();
                        if (!processedTypes.add(fullTypeName)) continue;
                        briefTypeName = briefTypeNameBuf.insert(0, TypeNameIdGenerator.getTypeBriefName(compTypeFullName)).toString();
                        break block29;
                    } else {
                        String typeId = compTypeKind.isPrimitive() ? this.getParamTypeId(type) : this.getParamTypeId(compType);
                        assert ((conflictingTypeIdsCount += this.registerPrimitiveTypeIdUsage(typeId, briefTypeIdsUsage, briefTypeIdsConflicting, reservedTypeIds)) <= registeredTypeIdsCount);
                        continue;
                    }
                }
                assert (kind == TypeKind.DECLARED);
                fullTypeName = this.getTypeFullName(type);
                if (!processedTypes.add(fullTypeName)) continue;
                briefTypeName = TypeNameIdGenerator.getTypeBriefName(fullTypeName);
            }
            fullTypeNames.add(fullTypeName);
            briefTypeNames.add(briefTypeName);
            briefTypeIdsRegistered.set(index);
            ++registeredTypeIdsCount;
            conflictingTypeIdsCount += this.registerBriefTypeIdUsage(briefTypeName, index, briefTypeIdsUsage, briefTypeIdsConflicting, reservedTypeIds);
            ++index;
        }
        processedTypes.clear();
        processedTypes = null;
        assert (conflictingTypeIdsCount <= registeredTypeIdsCount);
        assert (conflictingTypeIdsCount == briefTypeIdsConflicting.cardinality());
        assert (registeredTypeIdsCount == briefTypeIdsRegistered.cardinality());
        int uniqueTypeIdsCount = registeredTypeIdsCount - conflictingTypeIdsCount;
        if (uniqueTypeIdsCount > 0) {
            BitSet unique = (BitSet)briefTypeIdsRegistered.clone();
            unique.andNot(briefTypeIdsConflicting);
            index = unique.nextSetBit(0);
            while (index >= 0) {
                String fullTypeName2 = (String)fullTypeNames.get(index);
                String briefTypeName2 = (String)briefTypeNames.get(index);
                reservedTypeIds.add(briefTypeName2);
                this.qualNameToId.put(fullTypeName2, briefTypeName2);
                index = unique.nextSetBit(index + 1);
            }
        }
        if (conflictingTypeIdsCount > 0) {
            BitSet conflicting = (BitSet)briefTypeIdsConflicting.clone();
            briefTypeIdsUsage.clear();
            briefTypeIdsRegistered.clear();
            briefTypeIdsConflicting.clear();
            registeredTypeIdsCount = 0;
            conflictingTypeIdsCount = 0;
            String[] longerTypeNames = new String[typesCount];
            index = conflicting.nextSetBit(0);
            while (index >= 0) {
                String longerTypeName;
                fullTypeName = (String)fullTypeNames.get(index);
                briefTypeName = (String)briefTypeNames.get(index);
                longerTypeNames[index] = longerTypeName = TypeNameIdGenerator.getLongerTypeId(fullTypeName, briefTypeName);
                briefTypeIdsRegistered.set(index);
                ++registeredTypeIdsCount;
                conflictingTypeIdsCount += this.registerBriefTypeIdUsage(longerTypeName, index, briefTypeIdsUsage, briefTypeIdsConflicting, reservedTypeIds);
                index = conflicting.nextSetBit(index + 1);
            }
            assert (conflictingTypeIdsCount <= registeredTypeIdsCount);
            assert (conflictingTypeIdsCount == briefTypeIdsConflicting.cardinality());
            assert (registeredTypeIdsCount == briefTypeIdsRegistered.cardinality());
            uniqueTypeIdsCount = registeredTypeIdsCount - conflictingTypeIdsCount;
            if (uniqueTypeIdsCount > 0) {
                BitSet unique = (BitSet)briefTypeIdsRegistered.clone();
                unique.andNot(briefTypeIdsConflicting);
                index = unique.nextSetBit(0);
                while (index >= 0 && index < typesCount) {
                    String fullTypeName3 = (String)fullTypeNames.get(index);
                    String longerTypeId = longerTypeNames[index];
                    reservedTypeIds.add(longerTypeId);
                    this.qualNameToId.put(fullTypeName3, longerTypeId);
                    index = unique.nextSetBit(index + 1);
                }
            }
        }
        if (conflictingTypeIdsCount > 0) {
            HashMap<String, Integer> usageNumbers = new HashMap<String, Integer>(conflictingTypeIdsCount * 3 / 2);
            BitSet conflicting = briefTypeIdsConflicting;
            index = conflicting.nextSetBit(0);
            while (index >= 0) {
                String longestTypeId;
                String briefTypeId = (String)briefTypeNames.get(index);
                Integer oldValue = (Integer)usageNumbers.get(briefTypeId);
                int suffix = oldValue == null ? 0 : oldValue;
                String fullTypeName4 = (String)fullTypeNames.get(index);
                while (reservedTypeIds.contains(longestTypeId = briefTypeId + ++suffix)) {
                }
                usageNumbers.put(briefTypeId, suffix);
                reservedTypeIds.add(longestTypeId);
                this.qualNameToId.put(fullTypeName4, longestTypeId);
                index = conflicting.nextSetBit(index + 1);
            }
        }
        if (fullTypeNames != null) {
            fullTypeNames = null;
        }
        if (briefTypeNames != null) {
            briefTypeNames = null;
        }
        if (briefTypeIdsUsage != null) {
            briefTypeIdsUsage.clear();
        }
        if (briefTypeIdsRegistered != null) {
            briefTypeIdsRegistered.clear();
        }
        if (briefTypeIdsConflicting != null) {
            briefTypeIdsConflicting.clear();
        }
        if (reservedTypeIds != null) {
            reservedTypeIds.clear();
            reservedTypeIds = null;
        }
        if (paramTypes != null) {
            paramTypes.clear();
        }
    }

    private int registerPrimitiveTypeIdUsage(String typeId, Map<String, Object> typeIdUsage, BitSet conflictingTypesIndices, Collection<String> reservedTypeIds) {
        if (!reservedTypeIds.add(typeId)) {
            return 0;
        }
        int rv = 0;
        Object oldValue = typeIdUsage.get(typeId);
        if (oldValue != null && oldValue != Boolean.TRUE) {
            assert (oldValue.getClass() == Integer.class);
            int conflictingTypeIndex = (Integer)oldValue;
            assert (!conflictingTypesIndices.get(conflictingTypeIndex));
            conflictingTypesIndices.set(conflictingTypeIndex);
            typeIdUsage.put(typeId, Boolean.TRUE);
            ++rv;
        }
        return rv;
    }

    private int registerBriefTypeIdUsage(String typeId, int index, Map<String, Object> typeIdUsage, BitSet conflictingTypesIndices, Collection<String> reservedTypeIds) {
        boolean nameConflict;
        Object oldValue = typeIdUsage.put(typeId, index);
        boolean bl = nameConflict = oldValue != null || reservedTypeIds != null && reservedTypeIds.contains(typeId);
        assert (!conflictingTypesIndices.get(index));
        int rv = 0;
        if (nameConflict) {
            if (oldValue != null && oldValue != Boolean.TRUE) {
                assert (oldValue.getClass() == Integer.class);
                int conflictingTypeIndex = (Integer)oldValue;
                assert (!conflictingTypesIndices.get(conflictingTypeIndex));
                conflictingTypesIndices.set(conflictingTypeIndex);
                ++rv;
            }
            conflictingTypesIndices.set(index);
            typeIdUsage.put(typeId, Boolean.TRUE);
            ++rv;
        }
        return rv;
    }

    /*
     * Enabled aggressive block sorting
     */
    String getParamTypeId(TypeMirror type) {
        String id;
        String fullTypeName;
        block24: {
            if (type == null) {
                throw new IllegalArgumentException("null");
            }
            TypeKind kind = type.getKind();
            if (kind != TypeKind.DECLARED && kind != TypeKind.ARRAY) {
                if (kind.isPrimitive()) {
                    return type.toString();
                }
                switch (kind) {
                    case ERROR: {
                        return "ErrorType";
                    }
                    case NONE: {
                        assert (false);
                        return "NoType";
                    }
                    case VOID: {
                        assert (false);
                        return "VoidType";
                    }
                    case NULL: {
                        assert (false);
                        return "NullType";
                    }
                    case EXECUTABLE: 
                    case PACKAGE: 
                    case WILDCARD: {
                        assert (false);
                        return null;
                    }
                    case TYPEVAR: {
                        return "GenericType";
                    }
                }
                return "UnknownType";
            }
            if (kind == TypeKind.ARRAY) {
                TypeKind compTypeKind;
                int arrayDim = 0;
                StringBuilder fullTypeNameBuf = new StringBuilder(20);
                TypeMirror compType = type;
                do {
                    ++arrayDim;
                    fullTypeNameBuf.append('[');
                } while ((compTypeKind = (compType = ((ArrayType)compType).getComponentType()).getKind()) == TypeKind.ARRAY);
                if (compTypeKind == TypeKind.DECLARED) {
                    fullTypeName = fullTypeNameBuf.append(this.getTypeFullName(compType)).toString();
                    break block24;
                } else {
                    if (!compTypeKind.isPrimitive()) {
                        return this.getParamTypeId(compType);
                    }
                    StringBuilder paramTypeIdBuf = new StringBuilder(17);
                    paramTypeIdBuf.append(compType.toString());
                    int i = 0;
                    while (true) {
                        if (i >= arrayDim) {
                            return paramTypeIdBuf.toString();
                        }
                        paramTypeIdBuf.append(ARRAY_SUFFIX);
                        ++i;
                    }
                }
            }
            assert (kind == TypeKind.DECLARED);
            fullTypeName = this.getTypeFullName(type);
        }
        if ((id = this.qualNameToId.get(fullTypeName)) == null) {
            throw new IllegalArgumentException("unknown type");
        }
        return id;
    }

    private String getTypeFullName(TypeMirror type) {
        assert (type.getKind() == TypeKind.DECLARED);
        DeclaredType typeErasure = (DeclaredType)this.types.erasure(type);
        TypeElement typeErasureElem = (TypeElement)typeErasure.asElement();
        return this.elements.getBinaryName(typeErasureElem).toString();
    }

    private static String getTypeBriefName(String typeFullName) {
        int dotIndex = typeFullName.lastIndexOf(46);
        String result = dotIndex == -1 ? typeFullName : typeFullName.substring(dotIndex + 1);
        int dollarIndex = result.lastIndexOf(36);
        if (dollarIndex != -1) {
            StringBuilder buf = new StringBuilder(result);
            do {
                buf.deleteCharAt(dollarIndex);
            } while ((dollarIndex = result.lastIndexOf(36, dollarIndex - 1)) != -1);
            result = buf.toString();
        }
        return result;
    }

    private static String getLongerTypeId(String typeFullName, String briefTypeId) {
        int lastDot;
        if (typeFullName.charAt(0) == '[') {
            int startIndex = 0;
            while (typeFullName.charAt(++startIndex) == '[') {
            }
            typeFullName = typeFullName.substring(startIndex);
        }
        if ((lastDot = typeFullName.lastIndexOf(46)) == -1) {
            return briefTypeId;
        }
        String pkgName = typeFullName.substring(0, lastDot);
        StringBuilder buf = new StringBuilder(10);
        int nextDot = -1;
        do {
            int pkgPartStart = nextDot + 1;
            buf.append(pkgName.charAt(pkgPartStart));
            nextDot = pkgName.indexOf(46, pkgPartStart);
            assert (nextDot != pkgPartStart);
        } while (nextDot != -1);
        return buf.append(briefTypeId).toString();
    }
}

