/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.config.management.policy.ManagedServiceAssertion;
import com.sun.xml.ws.config.management.ManagementConstants;
import com.sun.xml.ws.config.management.ManagementMessages;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public class ManagementUtil {
    public static final String DATA_SOURCE_PARAMETER_NAME = "DATA_SOURCE_NAME";
    private static final String DEFAULT_DATA_SOURCE_NAME = "jdbc/metro/management";
    private static final Logger LOGGER = Logger.getLogger(ManagementUtil.class);

    public static String convert(Reader reader) throws WebServiceException {
        try {
            int count;
            StringBuilder data = new StringBuilder();
            char[] buffer = new char[1024];
            while ((count = reader.read(buffer)) >= 0) {
                data.append(buffer, 0, count);
            }
            return data.toString();
        }
        catch (IOException e) {
            throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_5018_FAILED_READ(), (Throwable)e));
        }
    }

    public static DataSource getJdbcDataSource(ManagedServiceAssertion.ImplementationRecord record, String defaultClassName) throws WebServiceException {
        Map<QName, String> parameters;
        String className;
        String sourceName = DEFAULT_DATA_SOURCE_NAME;
        if (record != null && ((className = record.getImplementation()) == null || defaultClassName.equals(className)) && (parameters = record.getParameters()) != null) {
            sourceName = parameters.get(ManagementConstants.JDBC_DATA_SOURCE_PARAMETER_NAME);
        }
        try {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(ManagementMessages.WSM_5020_LOOKUP_DATASOURCE(sourceName));
            }
            InitialContext initCtx = new InitialContext();
            return (DataSource)initCtx.lookup(sourceName);
        }
        catch (NamingException e) {
            throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_5019_FAILED_LOOKUP(sourceName), (Throwable)e));
        }
    }

    public static JdbcTableNames getJdbcTableNames(ManagedServiceAssertion.ImplementationRecord record, String defaultClassName) {
        String className;
        String tableName = "METRO_CONFIG";
        String idName = "id";
        String versionName = "version";
        String configName = "config";
        if (record != null && ((className = record.getImplementation()) == null || className.equals(defaultClassName))) {
            Map<QName, String> parameters = record.getParameters();
            if (parameters.containsKey(ManagementConstants.JDBC_TABLE_NAME_PARAMETER_NAME)) {
                tableName = parameters.get(ManagementConstants.JDBC_TABLE_NAME_PARAMETER_NAME);
            }
            if (parameters.containsKey(ManagementConstants.JDBC_ID_COLUMN_NAME_PARAMETER_NAME)) {
                idName = parameters.get(ManagementConstants.JDBC_ID_COLUMN_NAME_PARAMETER_NAME);
            }
            if (parameters.containsKey(ManagementConstants.JDBC_VERSION_COLUMN_NAME_PARAMETER_NAME)) {
                versionName = parameters.get(ManagementConstants.JDBC_VERSION_COLUMN_NAME_PARAMETER_NAME);
            }
            if (parameters.containsKey(ManagementConstants.JDBC_CONFIG_COLUMN_NAME_PARAMETER_NAME)) {
                configName = parameters.get(ManagementConstants.JDBC_CONFIG_COLUMN_NAME_PARAMETER_NAME);
            }
        }
        return new JdbcTableNames(tableName, idName, versionName, configName);
    }

    public static class JdbcTableNames {
        private final String tableName;
        private final String idName;
        private final String versionName;
        private final String configName;

        private JdbcTableNames(String tableName, String idName, String versionName, String configName) {
            this.tableName = tableName;
            this.idName = idName;
            this.versionName = versionName;
            this.configName = configName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getIdName() {
            return this.idName;
        }

        public String getVersionName() {
            return this.versionName;
        }

        public String getConfigName() {
            return this.configName;
        }
    }
}

